/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.item;

import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.item.Shoot;
import de.tomalbrc.filament.item.SimpleItem;
import de.tomalbrc.filament.mixin.accessor.AbstractArrowAccessor;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2752;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3966;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class BaseProjectileEntity
extends class_1665
implements PolymerEntity {
    protected class_1799 projectileStack = class_1802.field_8831.method_7854();
    protected class_1799 pickupStack;
    protected class_1799 base;
    private boolean dealtDamage;
    protected final ElementHolder holder = new ElementHolder(){

        protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
        }

        protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> packetConsumer) {
            packetConsumer.accept((class_2596<class_2602>)new class_2752((class_1297)BaseProjectileEntity.this));
        }
    };
    protected ItemDisplayElement mainDisplayElement = new ItemDisplayElement();
    protected final InteractionElement interactionElement = new InteractionElement();
    protected final InteractionElement interactionElement2 = new InteractionElement();
    public Shoot.Config config;

    protected void createMainDisplayElement() {
        this.mainDisplayElement.setItem(this.projectileStack);
        if (!this.holder.getElements().contains(this.mainDisplayElement)) {
            this.holder.addElement((VirtualElement)this.mainDisplayElement);
            VirtualEntityUtils.addVirtualPassenger((class_1297)this, (int)this.mainDisplayElement.getEntityId());
        }
        this.mainDisplayElement.setItemDisplayContext(this.config.display);
        this.mainDisplayElement.setLeftRotation((Quaternionfc)class_7833.field_40718.rotationDegrees(180.0f));
        this.mainDisplayElement.setRightRotation((Quaternionfc)new Quaternionf().rotateY((float)Math.toRadians(this.method_36454())).mul((Quaternionfc)this.config.rotation).normalize());
        this.mainDisplayElement.setTranslation((Vector3fc)new Vector3f(0.0f, 0.15f, 0.0f).add((Vector3fc)this.config.translation));
        this.mainDisplayElement.setScale((Vector3fc)this.config.scale);
    }

    public BaseProjectileEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        EntityAttachment.of((ElementHolder)this.holder, (class_1297)this);
        this.interactionElement.setSize(0.5f, 0.25f);
        this.interactionElement2.setSize(0.5f, -0.25f);
        this.holder.addElement((VirtualElement)this.interactionElement);
        this.holder.addElement((VirtualElement)this.interactionElement2);
        VirtualEntityUtils.addVirtualPassenger((class_1297)this, (int)this.interactionElement.getEntityId());
        VirtualEntityUtils.addVirtualPassenger((class_1297)this, (int)this.interactionElement2.getEntityId());
    }

    public ItemDisplayElement getDisplayElement() {
        return this.mainDisplayElement;
    }

    public void setProjectileStack(class_1799 projectileStack) {
        this.projectileStack = projectileStack;
        this.createMainDisplayElement();
    }

    public void setPickupStack(class_1799 itemStack) {
        this.pickupStack = itemStack;
    }

    public void setBase(class_1799 itemStack) {
        ((AbstractArrowAccessor)((Object)this)).setFiredFromWeapon(itemStack);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        super.method_5773();
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    public class_1299<?> getPolymerEntityType(PacketContext packetContext) {
        return class_1299.field_6131;
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))));
        data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.NO_GRAVITY, (Object)true));
        data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.SILENT, (Object)true));
        data.add(class_2945.class_7834.method_46360((class_2940)class_1531.field_7107, (Object)17));
    }

    @NotNull
    protected class_1799 method_7445() {
        return this.pickupStack == null ? this.projectileStack : this.pickupStack.method_7972();
    }

    @NotNull
    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
        if (this.config.dropAsItem && !this.method_73183().method_8608()) {
            this.method_5775((class_3218)this.method_73183(), this.method_7445());
            this.method_31472();
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309) {
                class_1297 class_12973;
                class_1309 livingEntity = (class_1309)class_12972;
                this.dealtDamage = true;
                class_1282 damageSource = this.method_48923().method_48800((class_1297)this, livingEntity);
                double damage = ((AbstractArrowAccessor)((Object)this)).getBaseDamage();
                if (target.method_64397((class_3218)this.method_73183(), damageSource, (float)damage) && target.method_5864() != class_1299.field_6091 && (class_12973 = this.method_24921()) instanceof class_1309) {
                    class_1309 livingOwner = (class_1309)class_12973;
                    class_1890.method_60619((class_3218)((class_3218)target.method_73183()), (class_1297)livingOwner, (class_1282)damageSource, (class_1799)this.method_59958());
                    this.method_7450(target);
                }
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(class_3414.method_47908((class_2960)this.config.hitSound), this.config.hitVolume, this.config.hitPitch);
    }

    @NotNull
    protected class_3414 method_7440() {
        return class_3414.method_47908((class_2960)this.config.hitGroundSound);
    }

    public void method_5694(class_1657 player) {
        if (this.field_5960 || this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    public void method_5749(class_11368 input) {
        SimpleItem simpleItem;
        super.method_5749(input);
        this.base = input.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        this.projectileStack = input.method_71426("ProjectileItem", class_1799.field_24671).orElse(this.base);
        this.pickupStack = input.method_71426("PickupItem", class_1799.field_24671).orElse(class_1799.field_8037);
        class_1792 class_17922 = this.base.method_7909();
        if (class_17922 instanceof SimpleItem && (simpleItem = (SimpleItem)class_17922).has(Behaviours.SHOOT)) {
            this.config = ((Shoot)simpleItem.getOrThrow(Behaviours.SHOOT)).getConfig();
        }
        this.createMainDisplayElement();
        this.dealtDamage = input.method_71433("DealtDamage", true);
    }

    public void method_5652(class_11372 output) {
        super.method_5652(output);
        if (this.projectileStack != null && !this.projectileStack.method_7960()) {
            output.method_71468("Item", class_1799.field_24671, (Object)this.projectileStack);
        }
        if (this.pickupStack != null && !this.pickupStack.method_7960()) {
            output.method_71468("PickupItem", class_1799.field_24671, (Object)this.pickupStack);
        }
        output.method_71472("DealtDamage", this.dealtDamage);
    }

    protected boolean method_34713(class_1657 player) {
        return this.config.canPickUp && super.method_34713(player);
    }
}

