/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.event.FilamentRegistrationEvents;
import de.tomalbrc.filament.behaviour.BehaviourUtil;
import de.tomalbrc.filament.block.SimpleBlock;
import de.tomalbrc.filament.block.SimpleBlockItem;
import de.tomalbrc.filament.block.SimpleBlockWithEntity;
import de.tomalbrc.filament.block.SimpleVirtualBlock;
import de.tomalbrc.filament.block.SimpleVirtualBlockWithEntity;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.datafixer.config.BlockDataFix;
import de.tomalbrc.filament.item.FilamentItem;
import de.tomalbrc.filament.registry.ItemRegistry;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.FilamentConfig;
import de.tomalbrc.filament.util.FilamentSynchronousResourceReloadListener;
import de.tomalbrc.filament.util.Json;
import de.tomalbrc.filament.util.RPUtil;
import de.tomalbrc.filament.util.Translations;
import de.tomalbrc.filament.util.Util;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public class BlockRegistry {
    public static Map<class_2960, Collection<class_2960>> BLOCKS_TAGS = new Object2ReferenceOpenHashMap();

    public static void register(InputStream inputStream) throws IOException {
        block2: {
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(inputStream));
            try {
                BlockData data = (BlockData)Json.GSON.fromJson(element, BlockData.class);
                BlockDataFix.fixup(element, data);
                Util.handleComponentsCustom(element, data);
                BlockRegistry.register(data);
            }
            catch (Exception e) {
                Filament.LOGGER.error("Could not load file! Error: {}", (Object)String.valueOf(e.fillInStackTrace()));
                Filament.LOGGER.info(element.toString());
                if (!FilamentConfig.getInstance().debug) break block2;
                e.printStackTrace();
            }
        }
    }

    public static void register(BlockData data) {
        if (class_7923.field_41175.method_10250(data.id())) {
            class_2248 block = (class_2248)class_7923.field_41175.method_63535(data.id());
            if (block instanceof SimpleBlock) {
                SimpleBlock filamentBlock = (SimpleBlock)block;
                class_1792 class_17922 = block.method_8389();
                if (class_17922 instanceof FilamentItem) {
                    FilamentItem filamentItem = (FilamentItem)class_17922;
                    filamentItem.initBehaviours(data.behaviour());
                    filamentBlock.initBehaviours(data.behaviour());
                    BlockRegistry.postRegistration(filamentItem, filamentBlock, data);
                }
            }
            return;
        }
        BlockProperties properties = data.properties();
        class_4970.class_2251 blockProperties = properties.toBlockProperties();
        SimpleBlock customBlock = data.requiresEntityBlock() ? (data.virtual() ? (SimpleBlock)BlockRegistry.registerBlock(BlockRegistry.key(data.id()), props -> new SimpleVirtualBlockWithEntity((class_4970.class_2251)props, data), blockProperties, data.blockTags()) : (SimpleBlock)BlockRegistry.registerBlock(BlockRegistry.key(data.id()), props -> new SimpleBlockWithEntity((class_4970.class_2251)props, data), blockProperties, data.blockTags())) : (data.virtual() ? (SimpleBlock)BlockRegistry.registerBlock(BlockRegistry.key(data.id()), props -> new SimpleVirtualBlock((class_4970.class_2251)props, data), blockProperties, data.blockTags()) : BlockRegistry.registerBlock(BlockRegistry.key(data.id()), props -> new SimpleBlock((class_4970.class_2251)props, data), blockProperties, data.blockTags()));
        class_1792.class_1793 itemProperties = data.properties().toItemProperties();
        if (data.properties().copyComponents) {
            for (class_9336 component : data.vanillaItem().method_57347()) {
                itemProperties.method_57349(component.comp_2443(), component.comp_2444());
            }
        }
        for (class_9336 component : data.components()) {
            itemProperties.method_57349(component.comp_2443(), component.comp_2444());
        }
        SimpleBlockItem item = ItemRegistry.registerItem(ItemRegistry.key(data.id()), newProps -> new SimpleBlockItem((class_1792.class_1793)newProps, customBlock, data), itemProperties, data.group() != null ? data.group() : Constants.BLOCK_GROUP_ID, data.itemTags());
        BlockRegistry.postRegistration(item, customBlock, data);
        ((FilamentRegistrationEvents.BlockRegistration)FilamentRegistrationEvents.BLOCK.invoker()).registered(data, item, customBlock);
    }

    static void postRegistration(FilamentItem item, SimpleBlock customBlock, Data<?> data) {
        BehaviourUtil.postInitItem(item.asItem(), item, data.behaviour());
        BehaviourUtil.postInitBlock(customBlock, data.behaviour());
        Translations.add(item.asItem(), customBlock, data);
        RPUtil.create(item, data);
        customBlock.postRegister();
    }

    public static class_5321<class_2248> key(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id);
    }

    public static <T extends class_2248> T registerBlock(class_5321<class_2248> resourceKey, Function<class_4970.class_2251, T> function, class_4970.class_2251 properties, @Nullable Set<class_2960> blockTags) {
        class_2248 block = (class_2248)function.apply(properties.method_63500(resourceKey));
        if (blockTags != null) {
            for (class_2960 tag : blockTags) {
                Collection list = BLOCKS_TAGS.computeIfAbsent(tag, x -> new ArrayList());
                list.add(resourceKey.method_29177());
            }
        }
        return (T)((class_2248)class_2378.method_39197((class_2378)class_7923.field_41175, resourceKey, (Object)block));
    }

    public static class BlockDataReloadListener
    implements FilamentSynchronousResourceReloadListener {
        public class_2960 getFabricId() {
            return class_2960.method_60655((String)"filament", (String)"filament");
        }

        public void method_14491(class_3300 resourceManager) {
            this.load("filament/block", null, resourceManager, (id, inputStream) -> {
                try {
                    BlockRegistry.register(inputStream);
                }
                catch (IOException e) {
                    Filament.LOGGER.error("Failed to load block resource \"{}\".", id);
                }
            });
        }
    }
}

