/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.registry.BehaviourRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class BehaviourList
implements Iterable<Behaviour<?>> {
    public static final BehaviourList EMPTY = new BehaviourList();
    private final List<Behaviour<?>> behaviourList = new ObjectArrayList();

    public <T extends Behaviour<E>, E> void add(Behaviour<?> behaviour) {
        this.behaviourList.add(behaviour);
    }

    public void from(BehaviourList configMap) {
        if (configMap != null) {
            configMap.forEach(this::add);
        }
    }

    public boolean isEmpty() {
        return this.behaviourList.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Behaviour<?>> iterator() {
        return this.behaviourList.iterator();
    }

    public static class Deserializer
    implements JsonDeserializer<BehaviourList> {
        public BehaviourList deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonArray array = jsonElement.getAsJsonArray();
            BehaviourList behaviourConfigMap = new BehaviourList();
            for (JsonElement entry : array) {
                JsonObject obj = entry.getAsJsonObject();
                String typeId = obj.get("type").getAsString();
                class_2960 resourceLocation = typeId.contains(":") ? class_2960.method_60654((String)typeId) : class_2960.method_60655((String)"filament", (String)typeId);
                BehaviourType behaviourType = BehaviourRegistry.getType(resourceLocation);
                if (behaviourType == null || behaviourType.configType() == null) {
                    Filament.LOGGER.error("Could not load behaviour {}", (Object)resourceLocation);
                    continue;
                }
                Class clazz = behaviourType.configType();
                Object deserialized = jsonDeserializationContext.deserialize(entry, clazz);
                behaviourConfigMap.add((Behaviour<?>)behaviourType.createInstance(deserialized));
            }
            return behaviourConfigMap;
        }
    }
}

