/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import java.util.OptionalInt;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class LeafDecay
implements BlockBehaviour<Config> {
    private final Config config;

    public LeafDecay(Config config) {
        this.config = config;
        if (this.config.blockTag != null) {
            this.config.supportBlock = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)this.config.blockTag);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    public int getLightBlock(class_2680 state) {
        return 1;
    }

    @Override
    public class_2680 modifyPolymerBlockState(class_2680 original, class_2680 blockState) {
        return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(7))).method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(7))).method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12541, class_2741.field_12514});
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 selfDefault, class_1750 context) {
        class_2680 blockState = (class_2680)selfDefault.method_11657((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true));
        return this.updateDistance(blockState, (class_1936)context.method_8045(), context.method_8037());
    }

    @Override
    public class_265 getBlockSupportShape(class_2680 state, class_1922 level, class_2338 pos) {
        return class_259.method_1073();
    }

    @Override
    public boolean isRandomlyTicking(class_2680 state) {
        return (Integer)state.method_11654((class_2769)class_2741.field_12541) == 7 && (Boolean)state.method_11654((class_2769)class_2741.field_12514) == false;
    }

    @Override
    public void randomTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (this.decaying(state) && random.method_43057() <= this.config.decayChance) {
            class_2248.method_9497((class_2680)state, (class_1937)level, (class_2338)pos);
            level.method_8650(pos, false);
        }
    }

    protected boolean decaying(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12514) == false && (Integer)state.method_11654((class_2769)class_2741.field_12541) == 7;
    }

    @Override
    public class_2680 updateShape(class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_5819 randomSource) {
        int dist;
        if (blockState.method_28498((class_2769)class_2741.field_12508) && ((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        if ((dist = this.getDistanceAt(blockState2) + 1) != 1 || (Integer)blockState.method_11654((class_2769)class_2741.field_12541) != dist) {
            scheduledTickAccess.method_64310(blockPos, blockState.method_26204(), 1);
        }
        return blockState;
    }

    @Override
    public void tick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        level.method_8652(pos, this.updateDistance(state, (class_1936)level, pos), 3);
    }

    private class_2680 updateDistance(class_2680 state, class_1936 level, class_2338 pos) {
        int dist = 7;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_25505((class_2382)pos, direction);
            dist = Math.min(dist, this.getDistanceAt(level.method_8320((class_2338)mutableBlockPos)) + 1);
            if (dist == 1) break;
        }
        return (class_2680)state.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(dist));
    }

    private int getDistanceAt(class_2680 neighbor) {
        return this.getOptionalDistanceAt(neighbor).orElse(7);
    }

    public OptionalInt getOptionalDistanceAt(class_2680 blockState) {
        if (blockState.method_26164(this.config.supportBlock)) {
            return OptionalInt.of(0);
        }
        return blockState.method_28498((class_2769)class_2741.field_12541) ? OptionalInt.of((Integer)blockState.method_11654((class_2769)class_2741.field_12541)) : OptionalInt.empty();
    }

    public static class Config {
        class_2960 blockTag;
        float decayChance = 1.0f;
        private transient class_6862<class_2248> supportBlock = class_3481.field_15475;
    }
}

