/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.behaviour.block;

import de.tomalbrc.filament.api.behaviour.BlockBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.Behaviours;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2459;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_9902;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;

public class Repeater
implements BlockBehaviour<Config> {
    private final Config config;
    public static final class_2758 SIGNAL = class_2758.method_11867((String)"signal", (int)0, (int)15);
    public static final class_2754<class_2350> FACING = class_2318.field_10927;
    public static final class_2746 POWERED = class_2746.method_11825((String)"powered");

    public Repeater(Config config) {
        this.config = config;
    }

    @Override
    public class_2680 modifyDefaultState(class_2680 blockState) {
        return (class_2680)((class_2680)blockState.method_11657((class_2769)SIGNAL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void createBlockStateDefinition(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, SIGNAL});
    }

    @Override
    public class_2680 getStateForPlacement(class_2680 block, class_1750 blockPlaceContext) {
        class_2350 dir = blockPlaceContext.method_7715();
        class_2680 state = (class_2680)block.method_11657(FACING, (Comparable)dir);
        int s = this.getInputSignal(blockPlaceContext.method_8045(), blockPlaceContext.method_8037(), state);
        state = (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(s > 0))).method_11657((class_2769)SIGNAL, (Comparable)Integer.valueOf(s));
        return state;
    }

    @Override
    public void onPlace(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        this.updateNeighborsInFront(level, pos, state);
    }

    @Override
    public int getDirectSignal(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        return blockGetter.method_8320(blockPos.method_10093(direction)).method_26212(blockGetter, blockPos.method_10093(direction)) ? blockState.method_26195(blockGetter, blockPos, direction) : 0;
    }

    @Override
    public int getSignal(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        if (!((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) {
            return 0;
        }
        return blockState.method_11654(FACING) == direction ? (Integer)blockState.method_11654((class_2769)SIGNAL) - this.config.loss : 0;
    }

    @Override
    public void neighborChanged(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_9904 orientation, boolean bl) {
        this.checkTickOnNeighbor(blockState.method_26204(), level, blockPos, blockState);
    }

    protected void checkTickOnNeighbor(class_2248 self, class_1937 level, class_2338 blockPos, class_2680 blockState) {
        boolean powered = (Boolean)blockState.method_11654((class_2769)POWERED);
        int power = (Integer)blockState.method_11654((class_2769)SIGNAL);
        int s = this.getInputSignal(level, blockPos, blockState);
        if (!(s == power && powered == s > 0 || level.method_8397().method_8677(blockPos, (Object)self))) {
            class_1953 tickPriority = class_1953.field_9310;
            if (this.shouldPrioritize((class_1922)level, blockPos, blockState)) {
                tickPriority = class_1953.field_9315;
            } else if (powered) {
                tickPriority = class_1953.field_9313;
            }
            level.method_64311(blockPos, self, this.config.delay, tickPriority);
        }
    }

    public static boolean isRelay(class_2680 blockState) {
        BehaviourHolder behaviourHolder;
        class_2248 class_22482 = blockState.method_26204();
        return class_22482 instanceof BehaviourHolder && (behaviourHolder = (BehaviourHolder)class_22482).has(Behaviours.REPEATER);
    }

    public boolean shouldPrioritize(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState) {
        class_2350 direction = ((class_2350)blockState.method_11654(FACING)).method_10153();
        class_2680 blockState2 = blockGetter.method_8320(blockPos.method_10093(direction));
        return Repeater.isRelay(blockState2) && blockState2.method_11654(FACING) != direction;
    }

    @Override
    public void tick(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        boolean powered = (Boolean)blockState.method_11654((class_2769)POWERED);
        int power = (Integer)blockState.method_11654((class_2769)SIGNAL);
        int inputPower = this.getInputSignal((class_1937)serverLevel, blockPos, blockState);
        if (powered && inputPower <= 0) {
            serverLevel.method_8501(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SIGNAL, (Comparable)Integer.valueOf(0)));
        } else if (!powered || power != inputPower) {
            serverLevel.method_8501(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)SIGNAL, (Comparable)Integer.valueOf(inputPower)));
            if (inputPower <= 0) {
                serverLevel.method_64311(blockPos, blockState.method_26204(), this.config.delay, class_1953.field_9313);
            }
        }
    }

    protected int getInputSignal(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2350 direction = (class_2350)blockState.method_11654(FACING);
        class_2338 blockPos2 = blockPos.method_10093(direction);
        class_2680 state = level.method_8320(blockPos2);
        if (Repeater.isRelay(state)) {
            return (Integer)state.method_11654((class_2769)SIGNAL);
        }
        if (state.method_27852(class_2246.field_10091)) {
            return (Integer)state.method_11654((class_2769)class_2457.field_11432);
        }
        if (state.method_27852(class_2246.field_10301) && ((Boolean)state.method_11654((class_2769)class_2459.field_11446)).booleanValue()) {
            return 15;
        }
        return level.method_49808(blockPos2, direction);
    }

    @Override
    public class_2680 modifyPolymerBlockState(class_2680 original, class_2680 blockState) {
        return (class_2680)blockState.method_11657((class_2769)SIGNAL, (Comparable)Integer.valueOf(0));
    }

    @Override
    public boolean isSignalSource(class_2680 state) {
        return true;
    }

    @Override
    public void affectNeighborsAfterRemoval(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, boolean movedByPiston) {
        if (!movedByPiston) {
            this.updateNeighborsInFront((class_1937)serverLevel, blockPos, blockState);
        }
    }

    protected void updateNeighborsInFront(class_1937 level, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_9904 orientation = class_9902.method_61826((class_1937)level, (class_2350)direction.method_10153(), (class_2350)class_2350.field_11036);
        level.method_8492(blockPos, state.method_26204(), orientation);
        level.method_8508(blockPos, state.method_26204(), direction, orientation);
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    public static class Config {
        public int delay = 0;
        public int loss = 0;
    }
}

