/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.BlockBehaviourWithEntity;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2259;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockData<BlockPropertyLike extends BlockProperties>
extends Data<BlockPropertyLike> {
    @Nullable
    private final Set<class_2960> blockTags;
    @Nullable
    private final BlockResource blockResource;

    public AbstractBlockData(@NotNull class_2960 id, @Nullable class_1792 vanillaItem, @Nullable Map<String, String> translations, @Nullable class_2561 displayName, @Nullable ItemResource itemResource, @Nullable BlockResource blockResource, @Nullable class_2960 itemModel, @Nullable BehaviourConfigMap behaviourConfig, @Nullable class_9323 components, @Nullable class_2960 itemGroup, @Nullable BlockPropertyLike properties, @Nullable Set<class_2960> itemTags, @Nullable Set<class_2960> blockTags) {
        super(id, vanillaItem, translations, displayName, itemResource, itemModel, properties, behaviourConfig, components, itemGroup, itemTags);
        this.blockTags = blockTags;
        this.blockResource = blockResource;
    }

    public boolean requiresEntityBlock() {
        return this.behaviour().test(behaviourType -> BlockBehaviourWithEntity.class.isAssignableFrom(behaviourType.type()));
    }

    @NotNull
    public abstract BlockPropertyLike properties();

    public abstract boolean virtual();

    public abstract Map<class_2680, BlockData.BlockStateMeta> createStandardStateMap();

    public BlockResource blockResource() {
        return this.blockResource;
    }

    @Nullable
    public Set<class_2960> blockTags() {
        return this.blockTags;
    }

    public String toString() {
        return "AbstractBlockData[id=" + String.valueOf(this.id) + ", vanillaItem=" + String.valueOf(this.vanillaItem) + ", itemResource=" + String.valueOf(this.itemResource) + ", properties=" + String.valueOf(this.properties) + ", behaviourConfig=" + String.valueOf(this.behaviour) + ", components=" + String.valueOf(this.components) + ", itemGroup=" + String.valueOf(this.group) + "]";
    }

    protected BlockModelType safeBlockModelType(BlockModelType blockModelType) {
        if (PolymerBlockResourceUtils.getBlocksLeft((BlockModelType)blockModelType) <= 0) {
            blockModelType = BlockModelType.FULL_BLOCK;
            if (PolymerBlockResourceUtils.getBlocksLeft((BlockModelType)blockModelType) <= 0) {
                Filament.LOGGER.error("Filament: Ran out of blockModelTypes to use AND FULL_BLOCK ran out too! Using Bedrock block temporarily. Fix your Block-Config for {}!", (Object)this.id());
                return null;
            }
            Filament.LOGGER.error("Filament: Ran out of blockModelTypes to use! Using FULL_BLOCK for {}", (Object)this.id());
        }
        return blockModelType;
    }

    protected static class_2680 blockState(String str) {
        class_2259.class_7211 parsed;
        try {
            parsed = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Invalid BlockState value: " + str);
        }
        return parsed.comp_622();
    }
}

