/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.data;

import de.tomalbrc.filament.api.behaviour.Behaviour;
import de.tomalbrc.filament.api.behaviour.BehaviourType;
import de.tomalbrc.filament.api.behaviour.ContainerLike;
import de.tomalbrc.filament.api.behaviour.DecorationBehaviour;
import de.tomalbrc.filament.behaviour.BehaviourConfigMap;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.BlockData;
import de.tomalbrc.filament.data.properties.BlockStateMappedProperty;
import de.tomalbrc.filament.data.properties.DecorationProperties;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.util.DecorationUtil;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class DecorationData
extends AbstractBlockData<DecorationProperties> {
    @Nullable
    private final List<BlockConfig> blocks;
    @Nullable
    private final Vector2f size;
    @Nullable
    private final Boolean itemFrame;
    @Nullable
    private final BlockStateMappedProperty<class_2680> block;

    public DecorationData(@NotNull class_2960 id, @Nullable class_1792 vanillaItem, @Nullable Map<String, String> translations, @Nullable class_2561 displayName, @Nullable ItemResource itemResource, @Nullable BlockResource blockResource, @Nullable class_2960 itemModel, @Nullable BehaviourConfigMap behaviourConfig, @Nullable class_9323 components, @Nullable class_2960 itemGroup, @Nullable Set<class_2960> itemTags, @Nullable Set<class_2960> blockTags, @Nullable DecorationProperties properties, @Nullable List<BlockConfig> blocks, @Nullable BlockStateMappedProperty<class_2680> block, @Nullable Vector2f size, @Nullable Boolean itemFrame) {
        super(id, vanillaItem, translations, displayName, itemResource, blockResource, itemModel, behaviourConfig, components, itemGroup, properties, itemTags, blockTags);
        this.blocks = blocks;
        this.size = size;
        this.itemFrame = itemFrame;
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceProvider preferredResource() {
        assert (this.itemResource != null);
        return this.itemResource;
    }

    @Override
    @NotNull
    public DecorationProperties properties() {
        if (this.properties == null) {
            this.properties = new DecorationProperties();
        }
        return (DecorationProperties)this.properties;
    }

    public boolean isContainer() {
        return this.behaviour().test(behaviourType -> ContainerLike.class.isAssignableFrom(behaviourType.type()));
    }

    public static ContainerLike getFirstContainer(BehaviourHolder holder) {
        for (Map.Entry<BehaviourType<?, ?>, Behaviour<?>> behaviour : holder.getBehaviours()) {
            Behaviour<?> behaviour2 = behaviour.getValue();
            if (!(behaviour2 instanceof ContainerLike)) continue;
            ContainerLike containerLike = (ContainerLike)((Object)behaviour2);
            return containerLike;
        }
        return null;
    }

    public boolean hasBlocks() {
        return this.blocks != null;
    }

    public int countBlocks() {
        if (!this.hasBlocks()) {
            return 0;
        }
        int count = 0;
        for (BlockConfig block : this.blocks) {
            count += (int)(block.size().x() * block.size().y() * block.size().z());
        }
        return count;
    }

    @Override
    public boolean requiresEntityBlock() {
        boolean singleBlock = !this.hasBlocks() || DecorationUtil.barrierDimensions(Objects.requireNonNull(this.blocks()), 0.0f).equals(1.0f, 1.0f);
        boolean hasDecorationBehaviour = this.behaviour().test(a -> DecorationBehaviour.class.isAssignableFrom(a.type()));
        boolean canBeDyed = this.vanillaItem != null && (this.vanillaItem == class_1802.field_18138 || this.vanillaItem == class_1802.field_8450);
        boolean groundOnly = !this.properties().placement.wall() && !this.properties().placement.ceiling();
        return !groundOnly || canBeDyed || hasDecorationBehaviour || !singleBlock && this.size == null;
    }

    @Nullable
    public List<BlockConfig> blocks() {
        return this.blocks;
    }

    @Nullable
    public Vector2f size() {
        return this.size;
    }

    @Nullable
    public Boolean itemFrame() {
        return this.itemFrame;
    }

    @Nullable
    public class_2680 block(class_2680 blockState) {
        return this.block != null ? (class_2680)this.block.getOrDefault(blockState, null) : null;
    }

    @Override
    public Map<class_2680, BlockData.BlockStateMeta> createStandardStateMap() {
        Reference2ReferenceArrayMap val = new Reference2ReferenceArrayMap();
        if (this.blockResource() != null && this.blockResource().models() != null) {
            for (Map.Entry<String, PolymerBlockModel> entry : this.blockResource().models().entrySet()) {
                if (entry.getKey().equals("default")) {
                    class_2680 customState = ((class_2248)class_7923.field_41175.method_63535(this.id)).method_9564();
                    val.put((Object)customState, (Object)BlockData.BlockStateMeta.of(null, entry.getValue()));
                    continue;
                }
                class_2680 state = DecorationData.blockState(String.format("%s[%s]", this.id, entry.getKey()));
                if (state.method_28498((class_2769)class_2741.field_12508) && !entry.getKey().contains(class_2741.field_12508.method_11899() + "=")) {
                    val.put((Object)((class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)class_2741.field_12508) == false))), (Object)BlockData.BlockStateMeta.of(null, entry.getValue()));
                }
                val.put((Object)state, (Object)BlockData.BlockStateMeta.of(null, entry.getValue()));
            }
        }
        return val;
    }

    @Override
    public boolean virtual() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DecorationData that = (DecorationData)obj;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public String toString() {
        return "DecorationData[id=" + String.valueOf(this.id) + ", itemResource=" + String.valueOf(this.itemResource) + ", vanillaItem=" + String.valueOf(this.vanillaItem) + ", blocks=" + String.valueOf(this.blocks) + ", size=" + String.valueOf(this.size) + ", properties=" + String.valueOf(this.properties) + ", behaviourConfig=" + String.valueOf(this.behaviour) + ", components=" + String.valueOf(this.components) + ", itemGroup=" + String.valueOf(this.group) + "]";
    }

    public record BlockConfig(Vector3f origin, Vector3f size) {
        private final Vector3f origin;

        public Vector3f origin() {
            return this.origin == null ? class_243.field_1353.method_46409() : this.origin;
        }
    }
}

