/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.datafixer.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.tomalbrc.filament.Filament;
import de.tomalbrc.filament.api.behaviour.DecorationRotationProvider;
import de.tomalbrc.filament.behaviour.Behaviours;
import de.tomalbrc.filament.behaviour.block.Rotating;
import de.tomalbrc.filament.behaviour.block.Waterloggable;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.datafixer.config.BlockDataFix;
import java.util.HashMap;
import net.minecraft.class_2960;

public class DecorationDataFix {
    public static void fixup(JsonElement element, DecorationData data) {
        BlockDataFix.fixup(element, data);
        JsonObject root = element.getAsJsonObject();
        JsonElement props = root.get("properties");
        if (props == null) {
            data.behaviour().put(Behaviours.WATERLOGGABLE, new Waterloggable.Config());
        } else {
            JsonElement waterloggable = props.getAsJsonObject().get("waterloggable");
            if (waterloggable == null || waterloggable.getAsBoolean()) {
                data.behaviour().put(Behaviours.WATERLOGGABLE, new Waterloggable.Config());
            }
            JsonElement rotate = props.getAsJsonObject().get("rotate");
            JsonElement rotateSmooth = props.getAsJsonObject().get("rotateSmooth");
            JsonElement rotate_smooth = props.getAsJsonObject().get("rotate_smooth");
            boolean hasRotBeh = data.behaviour().test(x -> DecorationRotationProvider.class.isAssignableFrom(x.type()));
            if (!hasRotBeh && (rotate == null && data.properties().placement.wall() || rotate != null && rotate.getAsBoolean())) {
                Rotating.Config conf = new Rotating.Config();
                conf.smooth = rotateSmooth != null && rotateSmooth.getAsBoolean() || rotate_smooth != null && rotate_smooth.getAsBoolean();
                data.behaviour().put(Behaviours.ROTATING, conf);
            }
        }
        JsonElement veryOldFormat_Model = element.getAsJsonObject().get("model");
        if (!root.has("itemResource")) {
            try {
                HashMap<String, class_2960> map = new HashMap<String, class_2960>();
                map.put("default", class_2960.method_60654((String)veryOldFormat_Model.getAsString()));
                data.setItemResource(new ItemResource(map, null, null));
            }
            catch (Exception e) {
                Filament.LOGGER.error("Could not fix legacy 'model' field");
            }
        }
    }
}

