/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.annotations.SerializedName;
import de.tomalbrc.filament.datafixer.DataFix;
import de.tomalbrc.filament.util.Constants;
import de.tomalbrc.filament.util.Json;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class FilamentConfig {
    static Path CONFIG_FILE_PATH = Constants.CONFIG_DIR.resolve("filament.json");
    static FilamentConfig instance;
    @SerializedName(value="debug")
    public boolean debug = false;
    @SerializedName(value="use_minimessage")
    public boolean minimessage = false;
    @SerializedName(value="commands")
    public boolean commands = true;
    @SerializedName(value="add_custom_menu_assets")
    public boolean addCustomMenuAssets = true;
    @SerializedName(value="prevent_adventure_mode_decoration_interaction")
    public boolean preventAdventureModeDecorationInteraction = true;
    @SerializedName(value="alternative_block_placement")
    public boolean alternativeBlockPlacement = false;
    @SerializedName(value="alternative_cosmetic_placement")
    public boolean alternativeCosmeticPlacement = false;
    @SerializedName(value="entity_module")
    public boolean entityModule = true;
    @SerializedName(value="version")
    public Integer version;

    public static FilamentConfig getInstance() {
        if (instance == null) {
            if (!FilamentConfig.load()) {
                FilamentConfig.save();
                if (FilamentConfig.instance.version == null) {
                    FilamentConfig.instance.version = 1;
                }
            } else if (FilamentConfig.instance.version == null) {
                FilamentConfig.instance.version = DataFix.VERSION;
            }
        }
        return instance;
    }

    public static boolean load() {
        if (!CONFIG_FILE_PATH.toFile().exists()) {
            instance = new FilamentConfig();
            try {
                if (CONFIG_FILE_PATH.toFile().createNewFile()) {
                    FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());
                    stream.write(Json.GSON.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        try {
            instance = (FilamentConfig)Json.GSON.fromJson((Reader)new FileReader(CONFIG_FILE_PATH.toFile()), FilamentConfig.class);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static void save() {
        try (FileOutputStream stream = new FileOutputStream(CONFIG_FILE_PATH.toFile());){
            stream.write(Json.GSON.toJson((Object)instance).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

