/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.filament.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.tomalbrc.filament.behaviour.BehaviourHolder;
import de.tomalbrc.filament.behaviour.ItemPredicateModelProvider;
import de.tomalbrc.filament.data.AbstractBlockData;
import de.tomalbrc.filament.data.Data;
import de.tomalbrc.filament.data.DecorationData;
import de.tomalbrc.filament.data.properties.BlockProperties;
import de.tomalbrc.filament.data.resource.BlockResource;
import de.tomalbrc.filament.data.resource.ItemResource;
import de.tomalbrc.filament.data.resource.ResourceProvider;
import de.tomalbrc.filament.generator.ItemAssetGenerator;
import de.tomalbrc.filament.util.Json;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_9334;

public class RPUtil {
    public static void create(BehaviourHolder behaviourHolder, Data<?> data) {
        ResourceProvider resource = data.itemResource();
        if (data instanceof AbstractBlockData) {
            AbstractBlockData blockData = (AbstractBlockData)data;
            if (data.itemResource() == null && blockData.blockResource() != null) {
                resource = blockData.blockResource();
            }
            if (((BlockProperties)blockData.properties()).virtual || blockData instanceof DecorationData) {
                RPUtil.createBlockItemAssets(blockData.id(), blockData.blockResource());
            }
            RPUtil.createBlockModels(blockData.id(), blockData.blockResource());
        }
        if (resource != null && !data.components().method_57832(class_9334.field_54199) && data.itemModel() == null && (resource.getModels() != null || resource.couldGenerate())) {
            if (behaviourHolder.getBehaviours() != null && !behaviourHolder.getBehaviours().isEmpty()) {
                for (Map.Entry entry : behaviourHolder.getBehaviours()) {
                    ItemPredicateModelProvider modelProvider;
                    Object v = entry.getValue();
                    if (!(v instanceof ItemPredicateModelProvider) || !(modelProvider = (ItemPredicateModelProvider)v).hasRequiredModels(data)) continue;
                    if (resource instanceof ItemResource) {
                        ItemResource ir = (ItemResource)resource;
                        if (!modelProvider.canCreateItemModels()) {
                            ItemAssetGenerator.createItemModels(data.id(), ir);
                        }
                    }
                    modelProvider.generate(data);
                    return;
                }
            }
            if (resource instanceof ItemResource) {
                ItemResource ir = (ItemResource)resource;
                ItemAssetGenerator.createItemModels(data.id(), ir);
            }
            ResourceProvider finalItemResources = resource;
            PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createDefault(resourcePackBuilder, data.id(), finalItemResources, data.components().method_57832(class_9334.field_49644) || data.vanillaItem().method_57347().method_57832(class_9334.field_49644)));
        }
    }

    public static void createBlockItemAssets(class_2960 id, BlockResource blockResource) {
        if (blockResource != null) {
            PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(resourcePackBuilder -> ItemAssetGenerator.createDefault(resourcePackBuilder, id.method_45138("block/"), blockResource, false));
        }
    }

    private static void createBlockModels(class_2960 id, BlockResource blockResource) {
        if (blockResource != null && blockResource.couldGenerate()) {
            int index = 1;
            Object2ObjectOpenHashMap localCache = new Object2ObjectOpenHashMap();
            for (Map.Entry<String, BlockResource.TextureBlockModel> entry : blockResource.textures().entrySet()) {
                class_2960 model = id.method_45138("block/").method_48331("_" + index);
                if (localCache.containsKey(entry.getValue().textures())) {
                    model = (class_2960)localCache.get(entry.getValue().textures());
                } else {
                    localCache.put(entry.getValue().textures(), model);
                    class_2960 modelId = model;
                    PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(builder -> {
                        JsonObject object = new JsonObject();
                        object.add("parent", (JsonElement)new JsonPrimitive(blockResource.parent().method_12836().equals("minecraft") ? blockResource.parent().method_12832() : blockResource.parent().toString()));
                        JsonObject textures = new JsonObject();
                        for (Map.Entry<String, class_2960> texturesMapEntry : ((BlockResource.TextureBlockModel)entry.getValue()).textures().entrySet()) {
                            textures.add(texturesMapEntry.getKey(), (JsonElement)new JsonPrimitive(texturesMapEntry.getValue().method_12836().equals("minecraft") ? texturesMapEntry.getValue().method_12832() : texturesMapEntry.getValue().toString()));
                        }
                        object.add("textures", (JsonElement)textures);
                        builder.addData("assets/" + modelId.method_12836() + "/models/" + modelId.method_12832() + ".json", Json.GSON.toJson((JsonElement)object).getBytes(StandardCharsets.UTF_8));
                    });
                }
                blockResource.addModel(entry.getKey(), PolymerBlockModel.of((class_2960)model, (int)entry.getValue().x(), (int)entry.getValue().y(), (boolean)entry.getValue().uvLock(), (int)entry.getValue().weight()));
                ++index;
            }
        }
    }
}

