/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.codwiz.init;

import net.mcreator.codwiz.entity.BloopEntity;
import net.mcreator.codwiz.entity.CodFrogEntity;
import net.mcreator.codwiz.entity.CodShipEntity;
import net.mcreator.codwiz.entity.CodwisEntity;
import net.mcreator.codwiz.entity.CodwizKingEntity;
import net.mcreator.codwiz.entity.DeadCodEntity;
import net.mcreator.codwiz.entity.NotCodEntity;
import net.mcreator.codwiz.entity.StopNCodEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CodwizModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"codwiz");
    public static final DeferredHolder<EntityType<?>, EntityType<DeadCodEntity>> DEAD_COD = CodwizModEntities.register("dead_cod", EntityType.Builder.of(DeadCodEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<BloopEntity>> BLOOP = CodwizModEntities.register("bloop", EntityType.Builder.of(BloopEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(7.0f, 12.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CodwizKingEntity>> CODWIZ_KING = CodwizModEntities.register("codwiz_king", EntityType.Builder.of(CodwizKingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CodFrogEntity>> COD_FROG = CodwizModEntities.register("cod_frog", EntityType.Builder.of(CodFrogEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<CodShipEntity>> COD_SHIP = CodwizModEntities.register("cod_ship", EntityType.Builder.of(CodShipEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(2.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CodwisEntity>> CODWIS = CodwizModEntities.register("codwis", EntityType.Builder.of(CodwisEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<NotCodEntity>> NOT_COD = CodwizModEntities.register("not_cod", EntityType.Builder.of(NotCodEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<StopNCodEntity>> STOP_N_COD = CodwizModEntities.register("stop_n_cod", EntityType.Builder.of(StopNCodEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DeadCodEntity.init(event);
        BloopEntity.init(event);
        CodwizKingEntity.init(event);
        CodFrogEntity.init(event);
        CodShipEntity.init(event);
        CodwisEntity.init(event);
        NotCodEntity.init(event);
        StopNCodEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DEAD_COD.get(), DeadCodEntity.createAttributes().build());
        event.put((EntityType)BLOOP.get(), BloopEntity.createAttributes().build());
        event.put((EntityType)CODWIZ_KING.get(), CodwizKingEntity.createAttributes().build());
        event.put((EntityType)COD_FROG.get(), CodFrogEntity.createAttributes().build());
        event.put((EntityType)COD_SHIP.get(), CodShipEntity.createAttributes().build());
        event.put((EntityType)CODWIS.get(), CodwisEntity.createAttributes().build());
        event.put((EntityType)NOT_COD.get(), NotCodEntity.createAttributes().build());
        event.put((EntityType)STOP_N_COD.get(), StopNCodEntity.createAttributes().build());
    }
}

