/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.letsparkour_common_neoforge.block.specific;

import com.google.common.collect.ImmutableMap;
import com.natamus.letsparkour_common_neoforge.block.base.ParkourSlab;
import com.natamus.letsparkour_common_neoforge.config.ConfigHandler;
import com.natamus.letsparkour_common_neoforge.data.ParkourBlocks;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TrapdoorParkourSlab
extends ParkourSlab {
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.TILT;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), object2IntArrayMap -> {
        object2IntArrayMap.defaultReturnValue(-1);
        object2IntArrayMap.put((Object)Tilt.UNSTABLE, 10);
        object2IntArrayMap.put((Object)Tilt.PARTIAL, 10);
        object2IntArrayMap.put((Object)Tilt.FULL, 100);
    });
    private static final Map<Tilt, VoxelShape> TRAPDOOR_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Tilt.UNSTABLE, (Object)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Tilt.PARTIAL, (Object)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (Object)Tilt.FULL, (Object)Shapes.empty());
    private final Function<BlockState, VoxelShape> shapesCache;

    public TrapdoorParkourSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TILT, (Comparable)Tilt.NONE));
        this.shapesCache = this.getShapeForEachState(TrapdoorParkourSlab::calculateShape);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{TYPE, WATERLOGGED, FACING, TILT, BLOCK_HEIGHT});
    }

    private static VoxelShape calculateShape(BlockState state) {
        return Shapes.or((VoxelShape)TRAPDOOR_SHAPES.get(state.getValue(TILT)), (VoxelShape[])new VoxelShape[0]);
    }

    protected static boolean place(LevelAccessor level, BlockPos pos, FluidState fluidState, Direction direction) {
        BlockState blockState = (BlockState)ParkourBlocks.TRAPDOOR_PARKOUR_SLAB.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        return level.setBlock(pos, blockState, 3);
    }

    protected void onProjectileHit(@NotNull Level level, @NotNull BlockState state, BlockHitResult hit, @NotNull Projectile projectile) {
        this.setTiltAndScheduleTick(state, level, hit.getBlockPos(), Tilt.FULL, SoundEvents.COPPER_HIT);
    }

    protected void entityInside(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (!level.isClientSide() && state.getValue(TILT) == Tilt.NONE && TrapdoorParkourSlab.canEntityTilt(pos, entity) && !level.hasNeighborSignal(pos)) {
            this.setTiltAndScheduleTick(state, level, pos, Tilt.UNSTABLE, null);
        }
    }

    @Override
    public void tick(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
        if (serverLevel.hasNeighborSignal(blockPos)) {
            TrapdoorParkourSlab.resetTilt(blockState, (Level)serverLevel, blockPos);
        } else {
            Tilt tilt = (Tilt)blockState.getValue(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(blockState, (Level)serverLevel, blockPos, Tilt.PARTIAL, SoundEvents.COPPER_HIT);
            } else if (tilt == Tilt.PARTIAL) {
                this.setTiltAndScheduleTick(blockState, (Level)serverLevel, blockPos, Tilt.FULL, SoundEvents.COPPER_HIT);
            } else if (tilt == Tilt.FULL) {
                TrapdoorParkourSlab.resetTilt(blockState, (Level)serverLevel, blockPos);
            }
        }
    }

    public void neighborChanged(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Block block, @NotNull BlockPos blockPos2, boolean bl) {
        if (level.hasNeighborSignal(blockPos)) {
            TrapdoorParkourSlab.resetTilt(blockState, level, blockPos);
        }
    }

    private static void playTiltSound(Level level, BlockPos pos, SoundEvent sound) {
        float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
        level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos blockPos, Entity entity) {
        return entity.onGround() && entity.position().y > (double)((float)blockPos.getY() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState state, Level level, BlockPos pos, Tilt tilt, @Nullable SoundEvent sound) {
        int i;
        if (!ConfigHandler.enableTrapdoorParkourBlock) {
            return;
        }
        TrapdoorParkourSlab.setTilt(state, level, pos, tilt);
        if (sound != null) {
            TrapdoorParkourSlab.playTiltSound(level, pos, sound);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            level.scheduleTick(pos, (Block)this, i);
        }
    }

    private static void resetTilt(BlockState blockState, Level level, BlockPos blockPos) {
        TrapdoorParkourSlab.setTilt(blockState, level, blockPos, Tilt.NONE);
        if (blockState.getValue(TILT) != Tilt.NONE) {
            TrapdoorParkourSlab.playTiltSound(level, blockPos, SoundEvents.COPPER_HIT);
        }
    }

    private static void setTilt(BlockState blockState, Level level, BlockPos blockPos, Tilt tilt) {
        Tilt tilt2 = (Tilt)blockState.getValue(TILT);
        level.setBlock(blockPos, (BlockState)blockState.setValue(TILT, (Comparable)tilt), 2);
        if (tilt.causesVibration() && tilt != tilt2) {
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        }
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return TRAPDOOR_SHAPES.get(blockState.getValue(TILT));
    }

    @Override
    @NotNull
    public VoxelShape getShape(BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return this.shapesCache.apply(blockState);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().below());
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean bl = blockState.is((Block)ParkourBlocks.TRAPDOOR_PARKOUR_SLAB);
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(bl ? (Direction)blockState.getValue((Property)FACING) : context.getHorizontalDirection().getOpposite()));
    }
}

