/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.letsparkour_common_fabric.block.specific;

import com.google.common.collect.ImmutableMap;
import com.natamus.letsparkour_common_fabric.block.base.ParkourSlab;
import com.natamus.letsparkour_common_fabric.config.ConfigHandler;
import com.natamus.letsparkour_common_fabric.data.ParkourBlocks;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5816;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrapdoorParkourSlab
extends ParkourSlab {
    private static final class_2754<class_5816> TILT = class_2741.field_28717;
    private static final Object2IntMap<class_5816> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)class_156.method_654((Object)new Object2IntArrayMap(), object2IntArrayMap -> {
        object2IntArrayMap.defaultReturnValue(-1);
        object2IntArrayMap.put((Object)class_5816.field_28719, 10);
        object2IntArrayMap.put((Object)class_5816.field_28720, 10);
        object2IntArrayMap.put((Object)class_5816.field_28721, 100);
    });
    private static final Map<class_5816, class_265> TRAPDOOR_SHAPES = ImmutableMap.of((Object)class_5816.field_28718, (Object)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)class_5816.field_28719, (Object)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)class_5816.field_28720, (Object)class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (Object)class_5816.field_28721, (Object)class_259.method_1073());
    private final Function<class_2680, class_265> shapesCache;

    public TrapdoorParkourSlab(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(TILT, (Comparable)class_5816.field_28718));
        this.shapesCache = this.method_33615(TrapdoorParkourSlab::calculateShape);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
        stateBuilder.method_11667(new class_2769[]{TYPE, WATERLOGGED, field_11177, TILT, BLOCK_HEIGHT});
    }

    private static class_265 calculateShape(class_2680 state) {
        return class_259.method_17786((class_265)TRAPDOOR_SHAPES.get(state.method_11654(TILT)), (class_265[])new class_265[0]);
    }

    protected static boolean place(class_1936 level, class_2338 pos, class_3610 fluidState, class_2350 direction) {
        class_2680 blockState = (class_2680)ParkourBlocks.TRAPDOOR_PARKOUR_SLAB.method_9564().method_11657((class_2769)field_11177, (Comparable)direction);
        return level.method_8652(pos, blockState, 3);
    }

    protected void method_19286(@NotNull class_1937 level, @NotNull class_2680 state, class_3965 hit, @NotNull class_1676 projectile) {
        this.setTiltAndScheduleTick(state, level, hit.method_17777(), class_5816.field_28721, class_3417.field_26963);
    }

    protected void entityInside(@NotNull class_2680 state, class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity) {
        if (!level.method_8608() && state.method_11654(TILT) == class_5816.field_28718 && TrapdoorParkourSlab.canEntityTilt(pos, entity) && !level.method_49803(pos)) {
            this.setTiltAndScheduleTick(state, level, pos, class_5816.field_28719, null);
        }
    }

    @Override
    public void method_9588(@NotNull class_2680 blockState, @NotNull class_3218 serverLevel, @NotNull class_2338 blockPos, @NotNull class_5819 randomSource) {
        if (serverLevel.method_49803(blockPos)) {
            TrapdoorParkourSlab.resetTilt(blockState, (class_1937)serverLevel, blockPos);
        } else {
            class_5816 tilt = (class_5816)blockState.method_11654(TILT);
            if (tilt == class_5816.field_28719) {
                this.setTiltAndScheduleTick(blockState, (class_1937)serverLevel, blockPos, class_5816.field_28720, class_3417.field_26963);
            } else if (tilt == class_5816.field_28720) {
                this.setTiltAndScheduleTick(blockState, (class_1937)serverLevel, blockPos, class_5816.field_28721, class_3417.field_26963);
            } else if (tilt == class_5816.field_28721) {
                TrapdoorParkourSlab.resetTilt(blockState, (class_1937)serverLevel, blockPos);
            }
        }
    }

    public void neighborChanged(@NotNull class_2680 blockState, class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2248 block, @NotNull class_2338 blockPos2, boolean bl) {
        if (level.method_49803(blockPos)) {
            TrapdoorParkourSlab.resetTilt(blockState, level, blockPos);
        }
    }

    private static void playTiltSound(class_1937 level, class_2338 pos, class_3414 sound) {
        float f = class_3532.method_32750((class_5819)level.field_9229, (float)0.8f, (float)1.2f);
        level.method_8396(null, pos, sound, class_3419.field_15245, 1.0f, f);
    }

    private static boolean canEntityTilt(class_2338 blockPos, class_1297 entity) {
        return entity.method_24828() && entity.method_73189().field_1351 > (double)((float)blockPos.method_10264() + 0.6875f);
    }

    private void setTiltAndScheduleTick(class_2680 state, class_1937 level, class_2338 pos, class_5816 tilt, @Nullable class_3414 sound) {
        int i;
        if (!ConfigHandler.enableTrapdoorParkourBlock) {
            return;
        }
        TrapdoorParkourSlab.setTilt(state, level, pos, tilt);
        if (sound != null) {
            TrapdoorParkourSlab.playTiltSound(level, pos, sound);
        }
        if ((i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)tilt)) != -1) {
            level.method_64310(pos, (class_2248)this, i);
        }
    }

    private static void resetTilt(class_2680 blockState, class_1937 level, class_2338 blockPos) {
        TrapdoorParkourSlab.setTilt(blockState, level, blockPos, class_5816.field_28718);
        if (blockState.method_11654(TILT) != class_5816.field_28718) {
            TrapdoorParkourSlab.playTiltSound(level, blockPos, class_3417.field_26963);
        }
    }

    private static void setTilt(class_2680 blockState, class_1937 level, class_2338 blockPos, class_5816 tilt) {
        class_5816 tilt2 = (class_5816)blockState.method_11654(TILT);
        level.method_8652(blockPos, (class_2680)blockState.method_11657(TILT, (Comparable)tilt), 2);
        if (tilt.method_33636() && tilt != tilt2) {
            level.method_33596(null, (class_6880)class_5712.field_28733, blockPos);
        }
    }

    @NotNull
    public class_265 method_9549(class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        return TRAPDOOR_SHAPES.get(blockState.method_11654(TILT));
    }

    @Override
    @NotNull
    public class_265 method_9530(class_2680 blockState, @NotNull class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_3726 collisionContext) {
        return this.shapesCache.apply(blockState);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037().method_10074());
        class_3610 fluidState = context.method_8045().method_8316(context.method_8037());
        boolean bl = blockState.method_27852((class_2248)ParkourBlocks.TRAPDOOR_PARKOUR_SLAB);
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)(bl ? (class_2350)blockState.method_11654((class_2769)field_11177) : context.method_8042().method_10153()));
    }
}

