/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.letsparkour_common_forge.mixin;

import com.natamus.letsparkour_common_forge.block.base.ParkourSlab;
import com.natamus.letsparkour_common_forge.block.specific.FastParkourSlab;
import com.natamus.letsparkour_common_forge.block.specific.JumpParkourSlab;
import com.natamus.letsparkour_common_forge.block.specific.SlowParkourSlab;
import com.natamus.letsparkour_common_forge.block.type.SpeedParkourSlab;
import com.natamus.letsparkour_common_forge.config.ConfigHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1001)
public abstract class EntityMixin {
    @Shadow
    private Level level;
    @Shadow
    private BlockPos blockPosition;

    @Inject(method={"getBlockJumpFactor()F"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockJumpFactor(CallbackInfoReturnable<Float> cir) {
        if (!ConfigHandler.enableJumpParkourBlock) {
            return;
        }
        BlockState blockState = this.level.getBlockState(this.blockPosition);
        if (!(blockState.getBlock() instanceof JumpParkourSlab) && !((blockState = this.level.getBlockState(this.blockPosition.below())).getBlock() instanceof JumpParkourSlab)) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf((float)ConfigHandler.jumpBlockBaseJumpFactor * (1.0f + (float)((Integer)blockState.getValue((Property)ParkourSlab.BLOCK_HEIGHT) - 1) * 0.25f)));
    }

    @Inject(method={"getBlockSpeedFactor()F"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        BlockState blockState = this.level.getBlockState(this.blockPosition);
        if (!(blockState.getBlock() instanceof SpeedParkourSlab) && !((blockState = this.level.getBlockState(this.blockPosition.below())).getBlock() instanceof SpeedParkourSlab)) {
            return;
        }
        Entity entity = (Entity)this;
        if (entity.getDeltaMovement().y != 0.0) {
            return;
        }
        Block block = blockState.getBlock();
        if (ConfigHandler.enableFastParkourBlock && block instanceof FastParkourSlab) {
            cir.setReturnValue((Object)Float.valueOf((float)ConfigHandler.fastBlockBaseSpeedFactor * (1.0f + (float)((Integer)blockState.getValue((Property)ParkourSlab.BLOCK_HEIGHT) - 1) * 0.25f)));
        } else if (ConfigHandler.enableSlowParkourBlock && block instanceof SlowParkourSlab) {
            cir.setReturnValue((Object)Float.valueOf((float)ConfigHandler.slowBlockBaseSpeedFactor / (1.0f + (float)((Integer)blockState.getValue((Property)ParkourSlab.BLOCK_HEIGHT) - 1) * 1.0f)));
        }
    }
}

