/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.letsparkour_common_neoforge.block.base;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.natamus.letsparkour_common_neoforge.data.ParkourBlockStateProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParkourSlab
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ParkourSlab> CODEC = ParkourSlab.simpleCodec(ParkourSlab::new);
    public static final EnumProperty<SlabType> TYPE;
    public static final BooleanProperty WATERLOGGED;
    public static final IntegerProperty BLOCK_HEIGHT;
    private static final int maxTotalHeight;
    protected static final VoxelShape BOTTOM_AABB;
    protected static final VoxelShape TOP_AABB;
    private final Set<BlockPos> processingPositions = new HashSet<BlockPos>();

    @NotNull
    public MapCodec<ParkourSlab> codec() {
        return CODEC;
    }

    public ParkourSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_HEIGHT, (Comparable)Integer.valueOf(1)));
    }

    protected boolean useShapeForLightOcclusion(BlockState blockState) {
        return blockState.getValue(TYPE) != SlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{TYPE, WATERLOGGED, BLOCK_HEIGHT});
    }

    @NotNull
    protected VoxelShape getShape(BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        SlabType slabType = (SlabType)blockState.getValue(TYPE);
        switch (slabType) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_AABB;
            }
        }
        return BOTTOM_AABB;
    }

    public void tick(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource randomSource) {
    }

    @NotNull
    public BlockState updateShape(BlockState blockStateA, @NotNull LevelReader levelReader, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos blockPosA, @NotNull Direction direction, @NotNull BlockPos blockPosB, @NotNull BlockState blockStateB, @NotNull RandomSource randomSource) {
        if (((Boolean)blockStateA.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(blockPosA, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return super.updateShape(blockStateA, levelReader, scheduledTickAccess, blockPosB, direction, blockPosA, blockStateB, randomSource);
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean bl) {
        if (!this.processingPositions.contains(blockPos)) {
            this.calculateBlockHeight(blockState, level, blockPos);
        }
    }

    public void onRemove(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState2, boolean bl) {
        if (blockState2.isAir()) {
            this.calculateBlockHeight(blockState, level, blockPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculateBlockHeight(BlockState blockState, Level level, BlockPos blockPos) {
        if (this.processingPositions.contains(blockPos)) {
            return;
        }
        this.processingPositions.add(blockPos);
        try {
            int y;
            BlockPos checkBlockPos;
            BlockState checkBlockState;
            int yo;
            Block thisBlock = blockState.getBlock();
            int totalHeight = 0;
            ArrayList<Pair> blockStatesToSet = new ArrayList<Pair>();
            for (yo = y = blockPos.getY(); yo >= level.getMinY() && (checkBlockState = level.getBlockState(checkBlockPos = new BlockPos(blockPos.getX(), yo, blockPos.getZ()))).getBlock().equals(thisBlock); --yo) {
                totalHeight = checkBlockState.getValue(TYPE) == SlabType.DOUBLE ? (totalHeight += 2) : ++totalHeight;
                blockStatesToSet.add(Pair.of((Object)checkBlockPos.immutable(), (Object)checkBlockState));
            }
            for (yo = y + 1; yo < level.getMaxY() && (checkBlockState = level.getBlockState(checkBlockPos = new BlockPos(blockPos.getX(), yo, blockPos.getZ()))).getBlock().equals(thisBlock); ++yo) {
                totalHeight = checkBlockState.getValue(TYPE) == SlabType.DOUBLE ? (totalHeight += 2) : ++totalHeight;
                blockStatesToSet.add(Pair.of((Object)checkBlockPos.immutable(), (Object)checkBlockState));
            }
            if (totalHeight > maxTotalHeight) {
                totalHeight = maxTotalHeight;
            }
            for (Pair pair : blockStatesToSet) {
                if ((Integer)((BlockState)pair.getSecond()).getValue((Property)BLOCK_HEIGHT) == totalHeight) continue;
                level.setBlock((BlockPos)pair.getFirst(), (BlockState)((BlockState)pair.getSecond()).setValue((Property)BLOCK_HEIGHT, (Comparable)Integer.valueOf(totalHeight)), 3);
            }
        }
        finally {
            this.processingPositions.remove(blockPos);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        BlockState blockState0 = blockPlaceContext.getLevel().getBlockState(blockPos);
        if (blockState0.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)blockState0.setValue(TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BLOCK_HEIGHT, (Comparable)Integer.valueOf(1));
        }
        FluidState fluidState = blockPlaceContext.getLevel().getFluidState(blockPos);
        BlockState blockState1 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER))).setValue((Property)BLOCK_HEIGHT, (Comparable)Integer.valueOf(1));
        Direction direction = blockPlaceContext.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && blockPlaceContext.getClickLocation().y - (double)blockPos.getY() > 0.5) ? blockState1 : (BlockState)blockState1.setValue(TYPE, (Comparable)SlabType.TOP);
    }

    protected boolean canBeReplaced(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        ItemStack itemStack = blockPlaceContext.getItemInHand();
        SlabType slabType = (SlabType)blockState.getValue(TYPE);
        if (slabType != SlabType.DOUBLE && itemStack.is(this.asItem())) {
            if (blockPlaceContext.replacingClickedOnBlock()) {
                boolean b = blockPlaceContext.getClickLocation().y - (double)blockPlaceContext.getClickedPos().getY() > 0.5;
                Direction direction = blockPlaceContext.getClickedFace();
                if (slabType == SlabType.BOTTOM) {
                    return direction == Direction.UP || b && direction.getAxis().isHorizontal();
                }
                return direction == Direction.DOWN || !b && direction.getAxis().isHorizontal();
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public boolean placeLiquid(@NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPos, BlockState blockState, @NotNull FluidState fluidState) {
        return blockState.getValue(TYPE) != SlabType.DOUBLE && super.placeLiquid(levelAccessor, blockPos, blockState, fluidState);
    }

    public boolean canPlaceLiquid(@Nullable Player player, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, BlockState blockState, @NotNull Fluid fluid) {
        return blockState.getValue(TYPE) != SlabType.DOUBLE && super.canPlaceLiquid((LivingEntity)player, blockGetter, blockPos, blockState, fluid);
    }

    protected boolean isPathfindable(@NotNull BlockState blockState, @NotNull PathComputationType pathComputationType) {
        if (Objects.requireNonNull(pathComputationType) == PathComputationType.WATER) {
            return blockState.getFluidState().is(FluidTags.WATER);
        }
        return false;
    }

    static {
        maxTotalHeight = ParkourBlockStateProperties.BLOCK_HEIGHT.getPossibleValues().size() - 1;
        TYPE = BlockStateProperties.SLAB_TYPE;
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        BLOCK_HEIGHT = ParkourBlockStateProperties.BLOCK_HEIGHT;
        BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

