/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.dialingspoon.partialhearts.PartialHearts;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;

public class PatternManager {
    public static final String ORIGINAL_PATTERN = "original";
    public static final String RANDOM_PATTERN = "random";
    private static String selectedPatternName = "original";
    private static int[] selectedPattern;
    private static final Gson GSON;

    public static String getSelectedPatternName() {
        return selectedPatternName;
    }

    public static void savePatterns(Map<String, int[]> patterns, String selectedName, int[] selectedPattern) {
        try {
            selectedPatternName = selectedName;
            PatternManager.selectedPattern = selectedPattern;
            File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            HashMap<String, int[]> savePatterns = new HashMap<String, int[]>(patterns);
            savePatterns.remove(ORIGINAL_PATTERN);
            savePatterns.remove(RANDOM_PATTERN);
            PatternsConfig value = new PatternsConfig(savePatterns, selectedPatternName);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)value, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, int[]> loadPatterns() {
        File configFile = new File(class_310.method_1551().field_1697, "config/partialhearts.json");
        HashMap<String, int[]> patterns = new HashMap<String, int[]>();
        patterns.put(ORIGINAL_PATTERN, PatternManager.createOriginalPattern());
        patterns.put(RANDOM_PATTERN, PatternManager.createRandomPattern());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                PatternsConfig loadedConfig = (PatternsConfig)GSON.fromJson((Reader)reader, PatternsConfig.class);
                patterns.putAll(loadedConfig.patterns);
                selectedPatternName = loadedConfig.selectedPattern;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        selectedPattern = (int[])patterns.get(selectedPatternName);
        return patterns;
    }

    public static int[] createOriginalPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        int value = 1;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = value++;
            }
        }
        return resultArray;
    }

    public static int[] createRandomPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        long visibleCount = Arrays.stream(resultArray).filter(value -> value == -1).count();
        ArrayList<Integer> randomValues = new ArrayList<Integer>();
        int i = 1;
        while ((long)i <= visibleCount) {
            randomValues.add(i);
            ++i;
        }
        Collections.shuffle(randomValues);
        int randomIndex = 0;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = (Integer)randomValues.get(randomIndex++);
            }
        }
        return resultArray;
    }

    public static int[] getUsedPixels() {
        int[] usedArray = new int[81];
        Arrays.fill(usedArray, 0);
        for (int[] spriteData : PartialHearts.CAPTURED_SPRITES.values()) {
            class_1011 image = PatternManager.loadImageFromArray(spriteData);
            for (int i = 0; i < 81; ++i) {
                int x = i % 9;
                int y = i / 9;
                int pixel = image.method_61940(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                usedArray[i] = -1;
            }
            image.close();
        }
        return usedArray;
    }

    public static void renderHeart(class_1011 heartImage, class_332 guiGraphics, float health, int heartX, int heartY) {
        int[] pixelOrder = selectedPattern;
        long usedIndicesCount = Arrays.stream(pixelOrder).max().getAsInt();
        double lastHeartFraction = 1.0 - (double)(health % 2.0f) / 2.0;
        lastHeartFraction = lastHeartFraction == 1.0 ? 0.0 : lastHeartFraction;
        int fullPixelsToRemove = (int)Math.ceil(lastHeartFraction * (double)(usedIndicesCount + 1L));
        for (int i = 0; i < pixelOrder.length; ++i) {
            if (pixelOrder[i] >= fullPixelsToRemove || pixelOrder[i] == 0) continue;
            int x = i % 9;
            int y = i / 9;
            heartImage.method_61941(x, y, 0);
        }
        class_1043 dynamicTexture = new class_1043(() -> "heartTexture", heartImage);
        class_2960 textureLocation = class_2960.method_60655((String)"partialhearts", (String)"dynamic_heart_texture");
        class_310.method_1551().method_1531().method_4616(textureLocation, (class_1044)dynamicTexture);
        guiGraphics.method_25302(class_10799.field_56883, textureLocation, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9, 9, 9);
        heartImage.close();
    }

    public static void onResourceManagerReload(class_3300 resourceManager) {
        Map resources = resourceManager.method_14488("textures/gui/sprites/hud/heart", fileName -> fileName.toString().endsWith(".png"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 original = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            String path = original.method_12832();
            String cleanPath = path.substring("textures/gui/sprites/".length(), path.length() - ".png".length());
            class_2960 resourceLocation = class_2960.method_60655((String)original.method_12836(), (String)cleanPath);
            try {
                InputStream inputStream = resource.method_14482();
                try {
                    class_1011 image = class_1011.method_4309((InputStream)inputStream);
                    int[] spriteData = image.method_61942();
                    image.close();
                    PartialHearts.CAPTURED_SPRITES.put(resourceLocation, spriteData);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PatternManager.loadPatterns();
    }

    public static class_1011 loadImageFromArray(int[] data) {
        class_1011 loadedImage = new class_1011(9, 9, false);
        for (int i = 0; i < data.length; ++i) {
            int x = i % 9;
            int y = i / 9;
            loadedImage.method_61941(x, y, data[i]);
        }
        return loadedImage;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public record PatternsConfig(Map<String, int[]> patterns, String selectedPattern) {
    }
}

