/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.dialingspoon.partialhearts.gui.PatternListScreen;
import net.dialingspoon.partialhearts.mixin.ScreenAccessor;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8208;
import net.minecraft.class_8666;

public class PatternEditScreen
extends class_437 {
    private static final int GRID_SIZE = 9;
    private static final int MAX_VALUE = 81;
    private static final int BUTTON_SIZE = 16;
    private final PatternListScreen parent;
    private final String oldName;
    private final int[] oldData;
    private final List<class_329.class_6411> backgroundSprites = new ArrayList<class_329.class_6411>();
    private int spriteIndex = 0;
    private class_342 nameField;
    private List<NumberButton> buttons;
    private int topOffset;
    private int leftOffset;
    private boolean mouseDown = false;
    private NumberButton hoveredButton;
    private String currentInput = "";

    public PatternEditScreen(PatternListScreen parent) {
        this(parent, null, null);
    }

    public PatternEditScreen(PatternListScreen parent, String oldName, int[] oldData) {
        super((class_2561)class_2561.method_43471((String)"pattern_edit_screen.title"));
        this.parent = parent;
        this.oldName = oldName;
        this.oldData = oldData;
    }

    protected void method_25426() {
        NumberButton btn;
        this.topOffset = 50;
        this.leftOffset = (this.field_22789 - 144) / 2;
        class_8208 infoSprite = class_8208.method_52720((int)5, (int)5, (class_2960)new class_2960("partialhearts", "info"));
        infoSprite.method_48229((this.field_22793.method_27525((class_5348)this.field_22785) + this.field_22789) / 2 + 2, 2);
        infoSprite.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"pattern_edit_screen.info")));
        this.method_37063((class_364)infoSprite);
        this.nameField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 20, 200, 20, (class_2561)class_2561.method_43473());
        this.nameField.method_1880(100);
        this.method_37063((class_364)this.nameField);
        class_8666 sprites = new class_8666(new class_2960("partialhearts", "scroll_left"), new class_2960("partialhearts", "scroll_left_highlighted"));
        this.method_37063((class_364)new ArrowButton(this.field_22789 / 2 - 96 - 32, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.decrementSpriteIndex()));
        sprites = new class_8666(new class_2960("partialhearts", "scroll_right"), new class_2960("partialhearts", "scroll_right_highlighted"));
        this.method_37063((class_364)new ArrowButton(this.field_22789 / 2 + 96, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.incrementSpriteIndex()));
        this.buttons = new ArrayList<NumberButton>();
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                btn = new NumberButton(this.leftOffset + x * 16, this.topOffset + y * 16, 16, 16, this::onButtonClick);
                this.buttons.add(btn);
                this.method_37063((class_364)btn);
            }
        }
        if (this.oldName != null && this.oldData != null) {
            this.nameField.method_1852(this.oldName);
            for (int i = 0; i < this.oldData.length && i < 81; ++i) {
                int val = this.oldData[i];
                if (val <= 0) continue;
                btn = this.buttons.get(i);
                btn.setValue(val);
            }
        }
        for (class_329.class_6411 type : class_329.class_6411.values()) {
            if (type == class_329.class_6411.field_33944 || this.backgroundSprites.contains(type)) continue;
            this.backgroundSprites.add(type);
        }
        int buttonY = this.topOffset + 144 + 16;
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.method_25419()).method_46433(this.field_22789 / 2 - 55, buttonY).method_46437(50, 20).method_46431();
        class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.onSave()).method_46433(this.field_22789 / 2 + 5, buttonY).method_46437(50, 20).method_46431();
        this.method_37063((class_364)saveButton);
        this.method_37063((class_364)cancelButton);
    }

    public void incrementSpriteIndex() {
        ++this.spriteIndex;
        if (this.spriteIndex >= this.backgroundSprites.size() * 4) {
            this.spriteIndex = 0;
        }
    }

    public void decrementSpriteIndex() {
        --this.spriteIndex;
        if (this.spriteIndex < 0) {
            this.spriteIndex = this.backgroundSprites.size() * 4 - 1;
        }
    }

    private void onButtonClick(NumberButton btn) {
        if (!btn.isPressed()) {
            int lowest = this.getLowestUnused();
            this.currentInput = String.valueOf(lowest);
            btn.setValue(lowest);
        } else {
            this.currentInput = "";
            btn.setValue(0);
        }
    }

    public int getLowestUnused() {
        boolean[] present = new boolean[81];
        for (NumberButton button : this.buttons) {
            if (!button.isPressed()) continue;
            present[button.getValue() - 1] = true;
        }
        for (int i = 1; i <= 81; ++i) {
            if (present[i - 1]) continue;
            return i;
        }
        return 81;
    }

    private void onSave() {
        String newName = this.nameField.method_1882().trim();
        if (newName.isEmpty()) {
            newName = "new pattern";
        }
        int[] values = new int[81];
        for (int i = 0; i < this.buttons.size() && i < 81; ++i) {
            NumberButton btn = this.buttons.get(i);
            values[i] = btn.isPressed() ? btn.getValue() : 0;
        }
        this.parent.onPatternSaved(this.oldName, newName, values);
        this.field_22787.method_1507((class_437)this.parent);
    }

    public void method_25419() {
        this.parent.onPatternEditCanceled();
        this.field_22787.method_1507((class_437)this.parent);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseDown = true;
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseDown = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        boolean buttonHovered = false;
        for (NumberButton btn : this.buttons) {
            if (!btn.method_25405(mouseX, mouseY)) continue;
            buttonHovered = true;
            if (this.hoveredButton == btn) break;
            this.finalizeNumber();
            this.hoveredButton = btn;
            if (this.mouseDown) {
                btn.method_25348(mouseX, mouseY);
            }
            this.currentInput = btn.isPressed() ? String.valueOf(btn.getValue()) : "";
            break;
        }
        if (!buttonHovered) {
            this.finalizeNumber();
            this.hoveredButton = null;
            this.currentInput = "";
        }
    }

    private void finalizeNumber() {
        if (this.hoveredButton == null) {
            return;
        }
        int val = this.parseSafe(this.currentInput);
        if (val < 1 || val > 81) {
            this.hoveredButton.setValue(0);
        } else {
            this.hoveredButton.setValue(val);
        }
        this.currentInput = "";
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.hoveredButton != null && keyCode >= 48 && keyCode <= 57) {
            this.nameField.method_25365(false);
            int digit = keyCode - 48;
            this.handleDigitInput(digit);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void handleDigitInput(int digit) {
        Object newInput = this.currentInput + digit;
        int val = this.parseSafe((String)newInput);
        while (val > 81) {
            newInput = ((String)newInput).length() > 1 ? ((String)newInput).substring(1) : "";
            val = this.parseSafe((String)newInput);
        }
        if (val == 0) {
            this.currentInput = "";
            return;
        }
        this.currentInput = newInput;
    }

    private int parseSafe(String input) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void method_25394(class_332 gg, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gg, mouseX, mouseY, partialTicks);
        class_329.class_6411 heartType = this.backgroundSprites.get(this.spriteIndex / 4);
        boolean hardcore = this.spriteIndex / 2 % 2 == 1;
        boolean blinking = this.spriteIndex % 2 == 1;
        gg.method_52706(heartType.method_52705(hardcore, false, blinking), this.leftOffset, this.topOffset, 144, 144);
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            renderable.method_25394(gg, mouseX, mouseY, partialTicks);
        }
        gg.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 5, 0xFFFFFF);
        this.nameField.method_25394(gg, mouseX, mouseY, partialTicks);
    }

    public class ArrowButton
    extends class_4185 {
        private final class_8666 sprites;

        public ArrowButton(int i, int j, int k, int l, class_8666 widgetSprites, class_4185.class_4241 onPress) {
            super(i, j, k, l, class_5244.field_39003, onPress, field_40754);
            this.sprites = widgetSprites;
        }

        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_2960 resourceLocation = this.sprites.method_52729(this.method_37303(), this.field_22762 && PatternEditScreen.this.mouseDown);
            guiGraphics.method_52706(resourceLocation, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        }
    }

    class NumberButton
    extends class_339 {
        private int value;
        private final Consumer<NumberButton> onPress;

        public NumberButton(int x, int y, int width, int height, Consumer<NumberButton> onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.value = 0;
            this.onPress = onPress;
        }

        public void method_25348(double mouseX, double mouseY) {
            this.onPress.accept(this);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
            narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43470((String)String.valueOf(this.value)));
        }

        public void method_48579(class_332 gg, int mouseX, int mouseY, float partialTicks) {
            int color = -2139062144;
            int displayNumber = this.value;
            if (this == PatternEditScreen.this.hoveredButton) {
                displayNumber = PatternEditScreen.this.parseSafe(PatternEditScreen.this.currentInput);
            }
            if (displayNumber > 0) {
                color = -2143272896;
            }
            gg.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, color);
            if (displayNumber > 0) {
                String numStr = String.valueOf(displayNumber);
                int textWidth = PatternEditScreen.this.field_22793.method_1727(numStr);
                int textX = this.method_46426() + (this.field_22758 - textWidth) / 2;
                int n = this.method_46427();
                Objects.requireNonNull(PatternEditScreen.this.field_22793);
                int textY = n + (this.field_22759 - 9) / 2;
                gg.method_51433(PatternEditScreen.this.field_22793, numStr, textX, textY, -1, false);
            }
        }

        public boolean isPressed() {
            return this.value > 0;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

