/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.dialingspoon.partialhearts.PartialHearts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class PatternManager {
    public static final String ORIGINAL_PATTERN = "original";
    public static final String RANDOM_PATTERN = "random";
    private static String selectedPatternName = "original";
    private static int[] selectedPattern;
    private static final Gson GSON;

    public static String getSelectedPatternName() {
        return selectedPatternName;
    }

    public static void savePatterns(Map<String, int[]> patterns, String selectedName, int[] selectedPattern) {
        try {
            selectedPatternName = selectedName;
            PatternManager.selectedPattern = selectedPattern;
            File configFile = new File(Minecraft.getInstance().gameDirectory, "config/partialhearts.json");
            configFile.getParentFile().mkdirs();
            configFile.createNewFile();
            HashMap<String, int[]> savePatterns = new HashMap<String, int[]>(patterns);
            savePatterns.remove(ORIGINAL_PATTERN);
            savePatterns.remove(RANDOM_PATTERN);
            PatternsConfig value = new PatternsConfig(savePatterns, selectedPatternName);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((Object)value, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, int[]> loadPatterns() {
        File configFile = new File(Minecraft.getInstance().gameDirectory, "config/partialhearts.json");
        HashMap<String, int[]> patterns = new HashMap<String, int[]>();
        patterns.put(ORIGINAL_PATTERN, PatternManager.createOriginalPattern());
        patterns.put(RANDOM_PATTERN, PatternManager.createRandomPattern());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                PatternsConfig loadedConfig = (PatternsConfig)GSON.fromJson((Reader)reader, PatternsConfig.class);
                patterns.putAll(loadedConfig.patterns);
                selectedPatternName = loadedConfig.selectedPattern;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        selectedPattern = (int[])patterns.get(selectedPatternName);
        return patterns;
    }

    public static int[] createOriginalPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        int value = 1;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = value++;
            }
        }
        return resultArray;
    }

    public static int[] createRandomPattern() {
        int[] resultArray = PatternManager.getUsedPixels();
        long visibleCount = Arrays.stream(resultArray).filter(value -> value == -1).count();
        ArrayList<Integer> randomValues = new ArrayList<Integer>();
        int i = 1;
        while ((long)i <= visibleCount) {
            randomValues.add(i);
            ++i;
        }
        Collections.shuffle(randomValues);
        int randomIndex = 0;
        for (int col = 8; col >= 0; --col) {
            for (int row = 0; row < 9; ++row) {
                int index = row * 9 + col;
                if (resultArray[index] != -1) continue;
                resultArray[index] = (Integer)randomValues.get(randomIndex++);
            }
        }
        return resultArray;
    }

    public static int[] getUsedPixels() {
        int[] usedArray = new int[81];
        Arrays.fill(usedArray, 0);
        for (int[] spriteData : PartialHearts.CAPTURED_SPRITES.values()) {
            NativeImage image = PatternManager.loadImageFromArray(spriteData);
            for (int i = 0; i < 81; ++i) {
                int x = i % 9;
                int y = i / 9;
                int pixel = image.getPixel(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha == 0) continue;
                usedArray[i] = -1;
            }
            image.close();
        }
        return usedArray;
    }

    public static void renderHeart(NativeImage heartImage, GuiGraphics guiGraphics, float health, int heartX, int heartY) {
        int[] pixelOrder = selectedPattern;
        long usedIndicesCount = Arrays.stream(pixelOrder).max().getAsInt();
        double lastHeartFraction = 1.0 - (double)(health % 2.0f) / 2.0;
        lastHeartFraction = lastHeartFraction == 1.0 ? 0.0 : lastHeartFraction;
        int fullPixelsToRemove = (int)Math.ceil(lastHeartFraction * (double)(usedIndicesCount + 1L));
        for (int i = 0; i < pixelOrder.length; ++i) {
            if (pixelOrder[i] >= fullPixelsToRemove || pixelOrder[i] == 0) continue;
            int x = i % 9;
            int y = i / 9;
            heartImage.setPixel(x, y, 0);
        }
        DynamicTexture dynamicTexture = new DynamicTexture(() -> "heartTexture", heartImage);
        ResourceLocation textureLocation = ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"dynamic_heart_texture");
        Minecraft.getInstance().getTextureManager().register(textureLocation, (AbstractTexture)dynamicTexture);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureLocation, heartX, heartY, 0.0f, 0.0f, 9, 9, 9, 9, 9, 9);
        heartImage.close();
    }

    public static void onResourceManagerReload(ResourceManager resourceManager) {
        Map resources = resourceManager.listResources("textures/gui/sprites/hud/heart", fileName -> fileName.toString().endsWith(".png"));
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation original = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            String path = original.getPath();
            String cleanPath = path.substring("textures/gui/sprites/".length(), path.length() - ".png".length());
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)original.getNamespace(), (String)cleanPath);
            try {
                InputStream inputStream = resource.open();
                try {
                    NativeImage image = NativeImage.read((InputStream)inputStream);
                    int[] spriteData = image.getPixels();
                    image.close();
                    PartialHearts.CAPTURED_SPRITES.put(resourceLocation, spriteData);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PatternManager.loadPatterns();
    }

    public static NativeImage loadImageFromArray(int[] data) {
        NativeImage loadedImage = new NativeImage(9, 9, false);
        for (int i = 0; i < data.length; ++i) {
            int x = i % 9;
            int y = i / 9;
            loadedImage.setPixel(x, y, data[i]);
        }
        return loadedImage;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }

    public record PatternsConfig(Map<String, int[]> patterns, String selectedPattern) {
    }
}

