/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.dialingspoon.partialhearts.gui.PatternListScreen;
import net.dialingspoon.partialhearts.mixin.ScreenAccessor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class PatternEditScreen
extends Screen {
    private static final int GRID_SIZE = 9;
    private static final int MAX_VALUE = 81;
    private static final int BUTTON_SIZE = 16;
    private final PatternListScreen parent;
    private final String oldName;
    private final int[] oldData;
    private final List<ResourceLocation> backgroundSprites = new ArrayList<ResourceLocation>();
    private int spriteIndex = 0;
    private EditBox nameField;
    private List<NumberButton> buttons;
    private int topOffset;
    private int leftOffset;
    private boolean mouseDown = false;
    private NumberButton hoveredButton;
    private String currentInput = "";

    public PatternEditScreen(PatternListScreen parent) {
        this(parent, null, null);
    }

    public PatternEditScreen(PatternListScreen parent, String oldName, int[] oldData) {
        super((Component)Component.translatable((String)"pattern_edit_screen.title"));
        this.parent = parent;
        this.oldName = oldName;
        this.oldData = oldData;
    }

    protected void init() {
        NumberButton btn;
        this.topOffset = 50;
        this.leftOffset = (this.width - 144) / 2;
        ImageWidget infoSprite = ImageWidget.sprite((int)5, (int)5, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"info"));
        infoSprite.setPosition((this.font.width((FormattedText)this.title) + this.width) / 2 + 2, 2);
        infoSprite.setTooltip(Tooltip.create((Component)Component.translatable((String)"pattern_edit_screen.info")));
        this.addRenderableWidget((GuiEventListener)infoSprite);
        this.nameField = new EditBox(this.font, this.width / 2 - 100, 20, 200, 20, (Component)Component.empty());
        this.nameField.setMaxLength(100);
        this.addRenderableWidget((GuiEventListener)this.nameField);
        WidgetSprites sprites = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"scroll_left"), ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"scroll_left_highlighted"));
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.width / 2 - 96 - 32, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.incrementSpriteIndex()));
        sprites = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"scroll_right"), ResourceLocation.fromNamespaceAndPath((String)"partialhearts", (String)"scroll_right_highlighted"));
        this.addRenderableWidget((GuiEventListener)new ArrowButton(this.width / 2 + 96, this.topOffset + 64 - 16, 32, 32, sprites, b -> this.decrementSpriteIndex()));
        this.buttons = new ArrayList<NumberButton>();
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                btn = new NumberButton(this.leftOffset + x * 16, this.topOffset + y * 16, 16, 16, this::onButtonClick);
                this.buttons.add(btn);
                this.addRenderableWidget((GuiEventListener)btn);
            }
        }
        if (this.oldName != null && this.oldData != null) {
            this.nameField.setValue(this.oldName);
            for (int i = 0; i < this.oldData.length && i < 81; ++i) {
                int val = this.oldData[i];
                if (val <= 0) continue;
                btn = this.buttons.get(i);
                btn.setValue(val);
            }
        }
        boolean[] booleans = new boolean[]{false, true};
        for (Gui.HeartType type : Gui.HeartType.values()) {
            if (type == Gui.HeartType.CONTAINER) continue;
            for (boolean hardcore : booleans) {
                for (boolean blinking : booleans) {
                    ResourceLocation sprite = type.getSprite(hardcore, false, blinking);
                    if (this.backgroundSprites.contains(sprite)) continue;
                    this.backgroundSprites.add(sprite);
                }
            }
        }
        int buttonY = this.topOffset + 144 + 16;
        Button saveButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.onSave()).pos(this.width / 2 - 55, buttonY).size(50, 20).build();
        Button cancelButton = Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onCancel()).pos(this.width / 2 + 5, buttonY).size(50, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.addRenderableWidget((GuiEventListener)cancelButton);
    }

    public void incrementSpriteIndex() {
        ++this.spriteIndex;
        if (this.spriteIndex >= this.backgroundSprites.size()) {
            this.spriteIndex = 0;
        }
    }

    public void decrementSpriteIndex() {
        --this.spriteIndex;
        if (this.spriteIndex < 0) {
            this.spriteIndex = this.backgroundSprites.size() - 1;
        }
    }

    private void onButtonClick(NumberButton btn) {
        if (!btn.isPressed()) {
            int lowest = this.getLowestUnused();
            this.currentInput = String.valueOf(lowest);
            btn.setValue(lowest);
        } else {
            this.currentInput = "";
            btn.setValue(0);
        }
    }

    public int getLowestUnused() {
        boolean[] present = new boolean[81];
        for (NumberButton button : this.buttons) {
            if (!button.isPressed()) continue;
            present[button.getValue() - 1] = true;
        }
        for (int i = 1; i <= 81; ++i) {
            if (present[i - 1]) continue;
            return i;
        }
        return 81;
    }

    private void onSave() {
        String newName = this.nameField.getValue().trim();
        if (newName.isEmpty()) {
            newName = "new pattern";
        }
        int[] values = new int[81];
        for (int i = 0; i < this.buttons.size() && i < 81; ++i) {
            NumberButton btn = this.buttons.get(i);
            values[i] = btn.isPressed() ? btn.getValue() : 0;
        }
        this.parent.onPatternSaved(this.oldName, newName, values);
        this.minecraft.setScreen((Screen)this.parent);
    }

    private void onCancel() {
        this.parent.onPatternEditCanceled();
        this.minecraft.setScreen((Screen)this.parent);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.mouseDown = true;
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        this.mouseDown = false;
        return super.mouseReleased(mouseButtonEvent);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        boolean buttonHovered = false;
        for (NumberButton btn : this.buttons) {
            if (!btn.isMouseOver(mouseX, mouseY)) continue;
            buttonHovered = true;
            if (this.hoveredButton == btn) break;
            this.finalizeNumber();
            this.hoveredButton = btn;
            if (this.mouseDown) {
                btn.acceptPress();
            }
            this.currentInput = btn.isPressed() ? String.valueOf(btn.getValue()) : "";
            break;
        }
        if (!buttonHovered) {
            this.finalizeNumber();
            this.hoveredButton = null;
            this.currentInput = "";
        }
    }

    private void finalizeNumber() {
        if (this.hoveredButton == null) {
            return;
        }
        int val = this.parseSafe(this.currentInput);
        if (val < 1 || val > 81) {
            this.hoveredButton.setValue(0);
        } else {
            this.hoveredButton.setValue(val);
        }
        this.currentInput = "";
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.hoveredButton != null && keyEvent.key() >= 48 && keyEvent.key() <= 57) {
            this.nameField.setFocused(false);
            int digit = keyEvent.key() - 48;
            this.handleDigitInput(digit);
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    private void handleDigitInput(int digit) {
        Object newInput = this.currentInput + digit;
        int val = this.parseSafe((String)newInput);
        while (val > 81) {
            newInput = ((String)newInput).length() > 1 ? ((String)newInput).substring(1) : "";
            val = this.parseSafe((String)newInput);
        }
        if (val == 0) {
            this.currentInput = "";
            return;
        }
        this.currentInput = newInput;
    }

    private int parseSafe(String input) {
        if (input == null || input.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        gg.blitSprite(RenderPipelines.GUI_TEXTURED, this.backgroundSprites.get(this.spriteIndex), this.leftOffset, this.topOffset, 144, 144);
        for (Renderable renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            renderable.render(gg, mouseX, mouseY, partialTicks);
        }
        gg.drawCenteredString(this.font, this.title, this.width / 2, 5, -1);
        this.nameField.render(gg, mouseX, mouseY, partialTicks);
    }

    public class ArrowButton
    extends Button {
        private final WidgetSprites sprites;

        public ArrowButton(int i, int j, int k, int l, WidgetSprites widgetSprites, Button.OnPress onPress) {
            super(i, j, k, l, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.sprites = widgetSprites;
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            ResourceLocation resourceLocation = this.sprites.get(this.isActive(), this.isHovered && PatternEditScreen.this.mouseDown);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation, this.getX(), this.getY(), this.width, this.height);
        }
    }

    class NumberButton
    extends AbstractWidget {
        private int value;
        private final Consumer<NumberButton> onPress;

        public NumberButton(int x, int y, int width, int height, Consumer<NumberButton> onPress) {
            super(x, y, width, height, (Component)Component.empty());
            this.value = 0;
            this.onPress = onPress;
        }

        public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
            super.onClick(mouseButtonEvent, bl);
            this.acceptPress();
        }

        public void acceptPress() {
            this.onPress.accept(this);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
            narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.literal((String)String.valueOf(this.value)));
        }

        public void renderWidget(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            int color = -2139062144;
            int displayNumber = this.value;
            if (this == PatternEditScreen.this.hoveredButton) {
                displayNumber = PatternEditScreen.this.parseSafe(PatternEditScreen.this.currentInput);
            }
            if (displayNumber > 0) {
                color = -2143272896;
            }
            gg.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, color);
            if (displayNumber > 0) {
                String numStr = String.valueOf(displayNumber);
                int textWidth = PatternEditScreen.this.font.width(numStr);
                int textX = this.getX() + (this.width - textWidth) / 2;
                int n = this.getY();
                Objects.requireNonNull(PatternEditScreen.this.font);
                int textY = n + (this.height - 9) / 2;
                gg.drawString(PatternEditScreen.this.font, numStr, textX, textY, -1, false);
            }
        }

        public boolean isPressed() {
            return this.value > 0;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

