/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dialingspoon.partialhearts.PatternManager;
import net.dialingspoon.partialhearts.gui.PatternEditScreen;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PatternListScreen
extends Screen {
    private String selectedPatternName = PatternManager.getSelectedPatternName();
    private final Map<String, int[]> patterns = PatternManager.loadPatterns();
    private PatternList patternList;

    public PatternListScreen(Screen parent) {
        super((Component)Component.translatable((String)"patternlist.title"));
    }

    protected void init() {
        this.patternList = new PatternList(this.minecraft, this.width, 175, 30, 22);
        this.addRenderableWidget((GuiEventListener)this.patternList);
        int buttonY = this.height - 26;
        Button newButton = Button.builder((Component)Component.translatable((String)"patternlist.new"), b -> this.minecraft.setScreen((Screen)new PatternEditScreen(this))).pos(this.width / 2 - 100, buttonY).size(60, 20).build();
        Button doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.onClose()).pos(this.width / 2 + 40, buttonY).size(60, 20).build();
        this.addRenderableWidget((GuiEventListener)newButton);
        this.addRenderableWidget((GuiEventListener)doneButton);
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        super.render(gg, mouseX, mouseY, partialTicks);
        gg.drawCenteredString(this.font, this.title, this.width / 2, 10, -1);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubled) {
        boolean result = super.mouseClicked(mouseButtonEvent, doubled);
        PatternEntry selected = (PatternEntry)this.patternList.getSelected();
        if (selected != null) {
            this.selectedPatternName = selected.getName();
        }
        return result;
    }

    public void onClose() {
        PatternManager.savePatterns(this.patterns, this.selectedPatternName, this.patterns.get(this.selectedPatternName));
        this.minecraft.setScreen(null);
    }

    public void onPatternSaved(String oldName, String newName, int[] newData) {
        if (oldName != null) {
            this.patterns.remove(oldName);
        }
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        this.patterns.put(newName, newData);
        this.selectedPatternName = newName;
        this.rebuildWidgets();
    }

    public void onPatternEditCanceled() {
        this.rebuildWidgets();
    }

    private void deletePattern(String name) {
        this.patterns.remove(name);
        if (this.selectedPatternName.equals(name)) {
            this.selectedPatternName = "original";
        }
        this.rebuildWidgets();
    }

    private void duplicatePattern(String name) {
        int[] data = this.patterns.get(name);
        String newName = this.incrementName(name);
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        int[] newData = Arrays.copyOf(data, data.length);
        this.patterns.put(newName, newData);
        this.rebuildWidgets();
    }

    private String incrementName(String name) {
        int numberVal;
        int len;
        int lastDigitStart = len = name.length();
        for (int i = len - 1; i >= 0; --i) {
            if (Character.isDigit(name.charAt(i))) continue;
            lastDigitStart = i + 1;
            break;
        }
        if (lastDigitStart == len) {
            return name + "2";
        }
        String prefix = name.substring(0, lastDigitStart);
        String numberStr = name.substring(lastDigitStart);
        try {
            numberVal = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            numberVal = 1;
        }
        return prefix + ++numberVal;
    }

    class PatternList
    extends ContainerObjectSelectionList<PatternEntry> {
        public PatternList(Minecraft minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
            this.addEntry(new PatternEntry("original", PatternListScreen.this.patterns.get("original"), true));
            this.addEntry(new PatternEntry("random", PatternListScreen.this.patterns.get("random"), true));
            List sortedEntries = PatternListScreen.this.patterns.entrySet().stream().filter(e -> !((String)e.getKey()).equals("original") && !((String)e.getKey()).equals("random")).sorted(Map.Entry.comparingByKey()).toList();
            for (Map.Entry entry : sortedEntries) {
                this.addEntry(new PatternEntry((String)entry.getKey(), (int[])entry.getValue(), false));
            }
        }

        public int getRowWidth() {
            return this.width - 60;
        }

        public boolean isFocused() {
            return PatternListScreen.this.getFocused() == this;
        }

        protected int addEntry(PatternEntry entry) {
            int i = super.addEntry((AbstractSelectionList.Entry)entry);
            if (entry.getName().equals(PatternListScreen.this.selectedPatternName)) {
                this.setSelected((AbstractSelectionList.Entry)entry);
            }
            return i;
        }
    }

    class PatternEntry
    extends ContainerObjectSelectionList.Entry<PatternEntry> {
        private final String name;
        private final int[] data;
        private final boolean special;
        private CheckButton selectButton;
        private Button editButton;
        private Button duplicateButton;
        private Button deleteButton;

        public PatternEntry(String name, int[] data, boolean special) {
            this.name = name;
            this.data = data;
            this.special = special;
            this.selectButton = new CheckButton(PatternListScreen.this.width / 2 - 5, 0, 20, this);
            PatternListScreen.this.addWidget((GuiEventListener)this.selectButton);
            if (!special) {
                this.editButton = Button.builder((Component)Component.translatable((String)"patternlist.edit"), b -> this.onEdit()).size(40, 20).build();
                this.duplicateButton = Button.builder((Component)Component.translatable((String)"patternlist.duplicate"), b -> this.onDuplicate()).size(60, 20).build();
                this.deleteButton = Button.builder((Component)Component.translatable((String)"patternlist.delete"), b -> this.onDelete()).size(50, 20).build();
            }
        }

        public String getName() {
            return this.name;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean bl, float deltaTicks) {
            int x = this.getContentX();
            int y = this.getContentY();
            PatternEntry.drawScrollableText(guiGraphics, PatternListScreen.this.font, (Component)Component.literal((String)this.name), x, y + 5, 160, 20, -1);
            this.selectButton.setPosition(x += 170, y);
            this.selectButton.render(guiGraphics, mouseX, mouseY, deltaTicks);
            x += 30;
            if (!this.special) {
                this.editButton.setPosition(x, y);
                this.editButton.render(guiGraphics, mouseX, mouseY, deltaTicks);
                this.duplicateButton.setPosition(x += 45, y);
                this.duplicateButton.render(guiGraphics, mouseX, mouseY, deltaTicks);
                this.deleteButton.setPosition(x += 65, y);
                this.deleteButton.render(guiGraphics, mouseX, mouseY, deltaTicks);
            }
        }

        protected static void drawScrollableText(GuiGraphics context, Font textRenderer, Component text, int startX, int startY, int width, int height, int color) {
            int endX = startX + width;
            int endY = startY + height;
            int i = textRenderer.width((FormattedText)text);
            int var10000 = startY + endY;
            Objects.requireNonNull(textRenderer);
            int j = (var10000 - 9) / 2 + 1;
            int k = endX - startX;
            if (i > k) {
                int l = i - k;
                double d = (double)Util.getMillis() / 250.0;
                double e = Math.max((double)l * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = Mth.lerp((double)f, (double)0.0, (double)l);
                context.enableScissor(startX, startY, endX, endY);
                context.drawString(textRenderer, text, startX - (int)g, j, color);
                context.disableScissor();
            } else {
                context.drawString(textRenderer, text, startX, j, color);
            }
        }

        public List<? extends GuiEventListener> children() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> narratables() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        private void onEdit() {
            PatternListScreen.this.minecraft.setScreen((Screen)new PatternEditScreen(PatternListScreen.this, this.name, this.data));
        }

        private void onDuplicate() {
            PatternListScreen.this.duplicatePattern(this.name);
        }

        private void onDelete() {
            PatternListScreen.this.deletePattern(this.name);
        }
    }

    public class CheckButton
    extends AbstractWidget {
        private final WidgetSprites sprites;
        private final PatternEntry parent;

        public CheckButton(int i, int j, int k, PatternEntry parent) {
            super(i, j, k, k, CommonComponents.EMPTY);
            this.sprites = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected"), ResourceLocation.withDefaultNamespace((String)"widget/checkbox"), ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected_highlighted"), ResourceLocation.withDefaultNamespace((String)"widget/checkbox_highlighted"));
            this.parent = parent;
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprites.get(PatternListScreen.this.patternList.getSelected() == this.parent, this.isHovered), this.getX(), this.getY(), this.width, this.height);
        }

        public void onClick(MouseButtonEvent mouseButtonEvent, boolean bl) {
            super.onClick(mouseButtonEvent, bl);
            PatternListScreen.this.patternList.setSelected((AbstractSelectionList.Entry)this.parent);
        }
    }
}

