/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.gui;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dialingspoon.partialhearts.PatternManager;
import net.dialingspoon.partialhearts.gui.PatternEditScreen;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class PatternListScreen
extends class_437 {
    private final class_437 parent;
    private String selectedPatternName = PatternManager.getSelectedPatternName();
    private final Map<String, int[]> patterns;
    private PatternList patternList;
    private long initTime;

    public PatternListScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"patternlist.title"));
        this.parent = parent;
        this.patterns = PatternManager.loadPatterns();
    }

    protected void method_25426() {
        this.initTime = class_156.method_658();
        this.patternList = new PatternList(this.field_22787, this.field_22789, 175, 30, 22);
        this.method_37063((class_364)this.patternList);
        int buttonY = this.field_22790 - 26;
        class_4185 newButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"patternlist.new"), b -> this.field_22787.method_1507((class_437)new PatternEditScreen(this))).method_46433(this.field_22789 / 2 - 100, buttonY).method_46437(60, 20).method_46431();
        class_4185 doneButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.method_25419()).method_46433(this.field_22789 / 2 + 40, buttonY).method_46437(60, 20).method_46431();
        this.method_37063((class_364)newButton);
        this.method_37063((class_364)doneButton);
    }

    public void method_25394(class_332 gg, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gg);
        super.method_25394(gg, mouseX, mouseY, partialTicks);
        gg.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean result = super.method_25402(mouseX, mouseY, button);
        PatternEntry selected = (PatternEntry)this.patternList.method_25334();
        if (selected != null) {
            this.selectedPatternName = selected.getName();
        }
        return result;
    }

    public void method_25419() {
        PatternManager.savePatterns(this.patterns, this.selectedPatternName, this.patterns.get(this.selectedPatternName));
        this.field_22787.method_1507(this.parent);
    }

    public void onPatternSaved(String oldName, String newName, int[] newData) {
        if (oldName != null) {
            this.patterns.remove(oldName);
        }
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        this.patterns.put(newName, newData);
        this.selectedPatternName = newName;
        this.method_41843();
    }

    public void onPatternEditCanceled() {
        this.method_41843();
    }

    private void deletePattern(String name) {
        this.patterns.remove(name);
        if (this.selectedPatternName.equals(name)) {
            this.selectedPatternName = "original";
        }
        this.method_41843();
    }

    private void duplicatePattern(String name) {
        int[] data = this.patterns.get(name);
        String newName = this.incrementName(name);
        while (this.patterns.containsKey(newName)) {
            newName = this.incrementName(newName);
        }
        int[] newData = Arrays.copyOf(data, data.length);
        this.patterns.put(newName, newData);
        this.method_41843();
    }

    private String incrementName(String name) {
        int numberVal;
        int len;
        int lastDigitStart = len = name.length();
        for (int i = len - 1; i >= 0; --i) {
            if (Character.isDigit(name.charAt(i))) continue;
            lastDigitStart = i + 1;
            break;
        }
        if (lastDigitStart == len) {
            return name + "2";
        }
        String prefix = name.substring(0, lastDigitStart);
        String numberStr = name.substring(lastDigitStart);
        try {
            numberVal = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            numberVal = 1;
        }
        return prefix + ++numberVal;
    }

    class PatternList
    extends class_4265<PatternEntry> {
        public PatternList(class_310 minecraft, int width, int height, int y, int itemHeight) {
            super(minecraft, width, height, y, y + height, itemHeight);
            this.addEntry(new PatternEntry("original", PatternListScreen.this.patterns.get("original"), true));
            this.addEntry(new PatternEntry("random", PatternListScreen.this.patterns.get("random"), true));
            List sortedEntries = PatternListScreen.this.patterns.entrySet().stream().filter(e -> !((String)e.getKey()).equals("original") && !((String)e.getKey()).equals("random")).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
            for (Map.Entry entry : sortedEntries) {
                this.addEntry(new PatternEntry((String)entry.getKey(), (int[])entry.getValue(), false));
            }
        }

        public int method_25322() {
            return this.field_22742 - 60;
        }

        public boolean method_25370() {
            return PatternListScreen.this.method_25399() == this;
        }

        protected int addEntry(PatternEntry entry) {
            this.method_25396().add(entry);
            if (entry.getName().equals(PatternListScreen.this.selectedPatternName)) {
                this.method_25313((class_350.class_351)entry);
            }
            return this.method_25396().size() - 1;
        }
    }

    class PatternEntry
    extends class_4265.class_4266<PatternEntry> {
        private final String name;
        private final int[] data;
        private final boolean special;
        private final CheckButton selectButton;
        private class_4185 editButton;
        private class_4185 duplicateButton;
        private class_4185 deleteButton;

        public PatternEntry(String name, int[] data, boolean special) {
            this.name = name;
            this.data = data;
            this.special = special;
            this.selectButton = new CheckButton(PatternListScreen.this.field_22789 / 2 - 5, 0, 20, this);
            PatternListScreen.this.method_25429((class_364)this.selectButton);
            if (!special) {
                this.editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"patternlist.edit"), b -> this.onEdit()).method_46437(40, 20).method_46431();
                this.duplicateButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"patternlist.duplicate"), b -> this.onDuplicate()).method_46437(60, 20).method_46431();
                this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"patternlist.delete"), b -> this.onDelete()).method_46437(50, 20).method_46431();
            }
        }

        public String getName() {
            return this.name;
        }

        public void method_25343(class_332 gg, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            PatternManager.setSelectedPattern(PatternListScreen.this.patterns.get(this.name));
            gg.method_25293(new class_2960("textures/gui/icons.png"), left - 20, top + 7, 18, 18, (float)class_329.class_6411.field_33944.method_37302(false, false), 0.0f, 9, 9, 256, 256);
            PatternManager.health = 2.0f - (float)(class_156.method_658() - PatternListScreen.this.initTime) / 500.0f % 20.0f / 10.0f;
            gg.method_25293(new class_2960("textures/gui/icons.png"), left - 20, top + 7, 18, 18, (float)class_329.class_6411.field_33945.method_37302(false, false), 0.0f, 9, 9, 256, 256);
            this.drawScrollableText(gg, PatternListScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.name), left += 5, top + 5, 160, 20, 0xFFFFFF);
            this.selectButton.method_48229(left += rowWidth / 2, top);
            this.selectButton.method_25394(gg, mouseX, mouseY, partialTick);
            left += rowWidth > 367 ? 30 : rowWidth / 12;
            if (!this.special) {
                this.editButton.method_48229(left, top);
                this.editButton.method_25394(gg, mouseX, mouseY, partialTick);
                this.duplicateButton.method_48229(left += rowWidth > 367 ? 45 : rowWidth / 8, top);
                this.duplicateButton.method_25394(gg, mouseX, mouseY, partialTick);
                this.deleteButton.method_48229(left += rowWidth > 367 ? 65 : (int)((float)rowWidth / 5.5f), top);
                this.deleteButton.method_25394(gg, mouseX, mouseY, partialTick);
            }
        }

        protected void drawScrollableText(class_332 context, class_327 textRenderer, class_2561 text, int startX, int startY, int width, int height, int color) {
            int endX = startX + width;
            int endY = startY + height;
            int i = textRenderer.method_27525((class_5348)text);
            int var10000 = startY + endY;
            Objects.requireNonNull(textRenderer);
            int j = (var10000 - 9) / 2 + 1;
            int k = endX - startX;
            if (i > k) {
                int l = i - k;
                double d = (double)class_156.method_658() / 250.0;
                double e = Math.max((double)l * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
                context.method_44379(startX, startY, endX, endY);
                context.method_27535(textRenderer, text, startX - (int)g, j, color);
                context.method_44380();
            } else {
                context.method_27535(textRenderer, text, startX, j, color);
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            if (this.special) {
                return Collections.emptyList();
            }
            return ImmutableList.of((Object)this.editButton, (Object)this.duplicateButton, (Object)this.deleteButton);
        }

        private void onEdit() {
            PatternListScreen.this.field_22787.method_1507((class_437)new PatternEditScreen(PatternListScreen.this, this.name, this.data));
        }

        private void onDuplicate() {
            PatternListScreen.this.duplicatePattern(this.name);
        }

        private void onDelete() {
            PatternListScreen.this.deletePattern(this.name);
        }
    }

    class CheckButton
    extends class_339 {
        private final class_2960 texture;
        private final PatternEntry parent;

        public CheckButton(int i, int j, int k, PatternEntry parent) {
            super(i, j, k, k, class_5244.field_39003);
            this.texture = new class_2960("partialhearts", "textures/gui/sprites/checkbox.png");
            this.parent = parent;
        }

        public void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            guiGraphics.method_25293(this.texture, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.field_22762 ? 20.0f : 0.0f, PatternListScreen.this.patternList.method_25334() == this.parent ? 20.0f : 0.0f, 20, 20, 64, 64);
        }

        public void method_25348(double d, double e) {
            PatternListScreen.this.patternList.method_25313((class_350.class_351)this.parent);
        }
    }
}

