/*
 * Decompiled with CFR 0.152.
 */
package net.dialingspoon.partialhearts.rendering;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import net.dialingspoon.partialhearts.PartialHearts;
import net.dialingspoon.partialhearts.PatternManager;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_9801;
import net.minecraft.class_9851;

public class HeartMaskRenderType
extends class_1921 {
    static final BiFunction<class_2960, Boolean, class_1921> OUTLINE = class_156.method_34865((resourceLocation, boolean_) -> class_1921.method_24048((String)"outline", (int)1536, (RenderPipeline)(boolean_ != false ? class_10799.field_56842 : class_10799.field_56843), (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, class_9851.field_52395, false)).method_23610(field_21359).method_24297(class_1921.class_4750.field_21854)));
    private final class_1921.class_4688 state;
    private final RenderPipeline renderPipeline;
    private final Optional<class_1921> outline;
    private final boolean isOutline;
    private float uvStartX;
    private float uvStartY;
    private float uvEndX;
    private float uvEndY;
    private float health;

    HeartMaskRenderType(String string, int i, boolean bl, boolean bl2, RenderPipeline renderPipeline, class_1921.class_4688 compositeState, float health, float u1, float v1, float u2, float v2) {
        super(string, i, bl, bl2, () -> compositeState.field_21422.forEach(class_4668::method_23516), () -> compositeState.field_21422.forEach(class_4668::method_23518));
        this.state = compositeState;
        this.renderPipeline = renderPipeline;
        this.outline = compositeState.field_21852 == class_1921.class_4750.field_21855 ? compositeState.field_21406.method_23564().map(resourceLocation -> OUTLINE.apply((class_2960)resourceLocation, renderPipeline.isCull())) : Optional.empty();
        this.isOutline = compositeState.field_21852 == class_1921.class_4750.field_21854;
        this.uvStartX = u1;
        this.uvStartY = v1;
        this.uvEndX = u2;
        this.uvEndY = v2;
        this.health = health;
    }

    public static HeartMaskRenderType heartMask(class_2960 texture, float health, float u1, float v1, float u2, float v2) {
        return new HeartMaskRenderType("partialhearts_heart_mask", 1536, false, false, PartialHearts.PIPELINE, class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, class_9851.field_52395, false)).method_23617(true), health, u1, v1, u2, v2);
    }

    public Optional<class_1921> method_23289() {
        return this.outline;
    }

    public boolean method_24295() {
        return this.isOutline;
    }

    public RenderPipeline method_68495() {
        return this.renderPipeline;
    }

    public VertexFormat method_23031() {
        return this.renderPipeline.getVertexFormat();
    }

    public VertexFormat.class_5596 method_23033() {
        return this.renderPipeline.getVertexFormatMode();
    }

    public void method_60895(class_9801 meshData) {
        RenderPipeline renderPipeline = this.method_68495();
        this.method_23516();
        class_9801 var3 = meshData;
        try {
            VertexFormat.class_5595 indexType;
            GpuBuffer gpuBuffer2;
            GpuBuffer gpuBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                gpuBuffer2 = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                gpuBuffer2 = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
            class_276 renderTarget = this.state.field_57931.method_68491();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(renderTarget.method_30277(), OptionalInt.empty(), renderTarget.field_1478 ? renderTarget.method_30278() : null, OptionalDouble.empty());){
                renderPass.setPipeline(renderPipeline);
                renderPass.setVertexBuffer(0, gpuBuffer);
                if (RenderSystem.SCISSOR_STATE.isEnabled()) {
                    renderPass.enableScissor(RenderSystem.SCISSOR_STATE);
                }
                renderPass.setUniform("UVStart", new float[]{this.uvStartX, this.uvStartY});
                renderPass.setUniform("UVEnd", new float[]{this.uvEndX, this.uvEndY});
                renderPass.setUniform("MaskBits", PatternManager.createMaskBits(this.health));
                for (int i = 0; i < 12; ++i) {
                    GpuTexture gpuTexture = RenderSystem.getShaderTexture((int)i);
                    if (gpuTexture == null) continue;
                    renderPass.bindSampler("Sampler" + i, gpuTexture);
                }
                renderPass.setIndexBuffer(gpuBuffer2, indexType);
                renderPass.drawIndexed(0, meshData.method_60822().comp_751());
            }
        }
        catch (Throwable var14) {
            if (meshData != null) {
                try {
                    var3.close();
                }
                catch (Throwable var11) {
                    var14.addSuppressed(var11);
                }
            }
            throw var14;
        }
        if (meshData != null) {
            meshData.close();
        }
        this.method_23518();
    }

    public class_276 method_68494() {
        return this.state.field_57931.method_68491();
    }

    public String toString() {
        String var10000 = this.field_21363;
        return "RenderType[" + var10000 + ":" + String.valueOf(this.state) + "]";
    }
}

