/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import me.khajiitos.chestedcompanions.common.client.renderer.layer.ChestLayer;
import me.khajiitos.chestedcompanions.common.config.CCConfig;
import me.khajiitos.chestedcompanions.common.mixin.accessor.CatModelAccessor;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public class CatChestLayer
extends ChestLayer<CatRenderState, CatModel> {
    public CatChestLayer(RenderLayerParent<CatRenderState, CatModel> renderLayerParent) {
        super(renderLayerParent);
    }

    @Override
    protected ModelPart getParentModelBody() {
        return ((CatModelAccessor)this.getParentModel()).getBody();
    }

    @Override
    protected Vec3i positionLeftChestCube() {
        return new Vec3i(-22, 4, 4);
    }

    @Override
    protected Vec3i positionRightChestCube() {
        return new Vec3i(-22, 4, -7);
    }

    @Override
    protected void setupPosition(CatRenderState catRenderState, ModelPart chestModelPart) {
        ModelPart catBody = this.getParentModelBody();
        chestModelPart.xRot = 1.5707964f;
        chestModelPart.yRot = 1.5707964f;
        chestModelPart.zRot = 1.5707964f;
        if (catRenderState.isBaby) {
            chestModelPart.x = catBody.x;
            chestModelPart.y = catBody.y;
            chestModelPart.z = catBody.z;
            chestModelPart.xScale = 0.3f;
            chestModelPart.yScale = 0.3f;
            chestModelPart.zScale = 0.3f;
        } else {
            chestModelPart.x = catBody.x;
            chestModelPart.y = catBody.y + 2.0f;
            chestModelPart.z = catBody.z;
            chestModelPart.xScale = 0.6f;
            chestModelPart.yScale = 0.6f;
            chestModelPart.zScale = 0.6f;
        }
        if (catBody.xRot == 0.7853982f) {
            chestModelPart.y = chestModelPart.y + (catRenderState.isBaby ? 4.0f : 6.0f);
            chestModelPart.z = chestModelPart.z - (catRenderState.isBaby ? 3.0f : 6.0f);
        }
        if (catBody.hasChild("EMF_body")) {
            chestModelPart.z -= 10.0f;
            chestModelPart.y -= 4.0f;
        }
    }

    @Override
    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int pPackedLight, @NotNull CatRenderState renderState, float v, float v1) {
        if (!((Boolean)CCConfig.hideCatChest.get()).booleanValue()) {
            super.render(poseStack, multiBufferSource, pPackedLight, renderState, v, v1);
        }
    }
}

