/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.chestedcompanions.common.util;

import me.khajiitos.chestedcompanions.common.ChestedCompanions;
import me.khajiitos.chestedcompanions.common.util.InventoryCapacity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IChestEntity
extends HasCustomInventoryScreen,
MenuProvider {
    public InventoryCapacity chestedCompanions$getInventoryCapacity();

    public PetChestContainer<?> chestedCompanions$getInventory();

    public void chestedCompanions$setChestItemStack(ItemStack var1);

    public ItemStack chestedCompanions$getChestItemStack();

    public void chestedCompanions$createInventory();

    public void chestedCompanions$removeInventory();

    public void chestedCompanions$removeChestContent(boolean var1);

    public boolean chestedCompanions$allowChest();

    public boolean chestedCompanions$allowChestOnBaby();

    default public boolean chestedCompanions$hasChest() {
        return !this.chestedCompanions$getChestItemStack().isEmpty();
    }

    default public boolean chestedCompanions$isValidChestItem(ItemStack itemStack) {
        return itemStack.is(ChestedCompanions.PET_CHEST_ITEM);
    }

    public static class PetChestContainer<T extends TamableAnimal>
    extends SimpleContainer {
        private final T pet;

        public PetChestContainer(T pet, int inventorySlots, @Nullable PetChestContainer<?> oldContainer) {
            super(inventorySlots);
            this.pet = pet;
            if (oldContainer != null) {
                this.clearContent();
                for (int i = 0; i < oldContainer.getContainerSize(); ++i) {
                    this.putOrDropItem(new ItemStackWithSlot(i, oldContainer.getItem(i)));
                }
            }
        }

        public void storeAsItemListWithSlot(ValueOutput.TypedOutputList<ItemStackWithSlot> list) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack itemStack = this.getItem(i);
                if (itemStack.isEmpty()) continue;
                list.add((Object)new ItemStackWithSlot(i, itemStack));
            }
        }

        public void loadFromItemListWithSlot(ValueInput.TypedInputList<ItemStackWithSlot> list) {
            this.clearContent();
            list.forEach(this::putOrDropItem);
        }

        public void putOrDropItem(ItemStackWithSlot itemStackWithSlot) {
            if (itemStackWithSlot.slot() >= this.getContainerSize()) {
                Level level = this.pet.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.pet.spawnAtLocation(serverLevel, itemStackWithSlot.stack());
                }
                return;
            }
            this.setItem(itemStackWithSlot.slot(), itemStackWithSlot.stack());
        }

        public boolean stillValid(@NotNull Player player) {
            return !this.pet.isRemoved() && ((IChestEntity)this.pet).chestedCompanions$getInventory() == this && player.canInteractWithEntity(this.pet, 4.0);
        }
    }
}

