/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.hook.impl.griefprevention;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.api.protection.ProtectionIntegration;
import xyz.xenondevs.nova.integration.Hook;
import xyz.xenondevs.nova.util.FakeOnlinePlayer;

@Hook(plugins={"GriefPrevention"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lxyz/xenondevs/nova/hook/impl/griefprevention/GriefPreventionHook;", "Lxyz/xenondevs/nova/api/protection/ProtectionIntegration;", "<init>", "()V", "GRIEF_PREVENTION", "Lme/ryanhamshire/GriefPrevention/GriefPrevention;", "canBreak", "", "player", "Lorg/bukkit/OfflinePlayer;", "item", "Lorg/bukkit/inventory/ItemStack;", "location", "Lorg/bukkit/Location;", "canPlace", "canUseBlock", "canUseItem", "canInteractWithEntity", "entity", "Lorg/bukkit/entity/Entity;", "canHurtEntity", "nova-hook-griefprevention"})
public final class GriefPreventionHook
implements ProtectionIntegration {
    @NotNull
    public static final GriefPreventionHook INSTANCE = new GriefPreventionHook();
    @NotNull
    private static final GriefPrevention GRIEF_PREVENTION;

    private GriefPreventionHook() {
    }

    @Override
    public boolean canBreak(@NotNull OfflinePlayer player, @Nullable ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return GRIEF_PREVENTION.allowBreak((Player)FakeOnlinePlayer.Companion.create(player, location), location.getBlock(), location) == null;
    }

    @Override
    public boolean canPlace(@NotNull OfflinePlayer player, @NotNull ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return GRIEF_PREVENTION.allowBuild((Player)FakeOnlinePlayer.Companion.create(player, location), location) == null;
    }

    @Override
    public boolean canUseBlock(@NotNull OfflinePlayer player, @Nullable ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.canBreak(player, item, location);
    }

    @Override
    public boolean canUseItem(@NotNull OfflinePlayer player, @NotNull ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.canBreak(player, item, location);
    }

    @Override
    public boolean canInteractWithEntity(@NotNull OfflinePlayer player, @NotNull Entity entity, @Nullable ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return this.canBreak(player, item, location);
    }

    @Override
    public boolean canHurtEntity(@NotNull OfflinePlayer player, @NotNull Entity entity, @Nullable ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return this.canBreak(player, item, location);
    }

    static {
        GriefPrevention griefPrevention = GriefPrevention.instance;
        Intrinsics.checkNotNullExpressionValue((Object)griefPrevention, (String)"instance");
        GRIEF_PREVENTION = griefPrevention;
    }
}

