/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.migration;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.bukkit.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.LevelChunkSectionFieldExtensionsKt;
import xyz.xenondevs.nova.world.block.migrator.BlockMigrator;

@Mixin(value={LevelChunk.class})
abstract class LevelChunkMixin {
    LevelChunkMixin() {
    }

    @Redirect(method={"setBlockState"}, at=@At(value="MIXINEXTRAS:EXPRESSION"))
    @Definition(id="addAndRegisterBlockEntity", method={"Lnet/minecraft/world/level/chunk/LevelChunk;addAndRegisterBlockEntity(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"})
    @Expression(value={"?.addAndRegisterBlockEntity(?)"})
    private void handleBlockEntityPlaced(LevelChunk chunk, BlockEntity blockEntity) {
        chunk.addAndRegisterBlockEntity(blockEntity);
        LevelChunkSection section = chunk.getSection(chunk.getSectionIndex(blockEntity.getBlockPos().getY()));
        if (LevelChunkSectionFieldExtensionsKt.isMigrationActive(section)) {
            xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(blockEntity.getBlockPos(), (World)chunk.getLevel().getWorld());
            BlockMigrator.handleBlockEntityPlaced(novaPos, blockEntity);
        }
    }

    @Redirect(method={"setBlockState"}, at=@At(value="MIXINEXTRAS:EXPRESSION"))
    @Definition(id="removeBlockEntity", method={"Lnet/minecraft/world/level/chunk/LevelChunk;removeBlockEntity(Lnet/minecraft/core/BlockPos;)V"})
    @Expression(value={"?.removeBlockEntity(?)"})
    private void handleBlockEntityRemoved(LevelChunk chunk, BlockPos pos) {
        chunk.removeBlockEntity(pos);
        LevelChunkSection section = chunk.getSection(chunk.getSectionIndex(pos.getY()));
        if (LevelChunkSectionFieldExtensionsKt.isMigrationActive(section)) {
            xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)chunk.getLevel().getWorld());
            BlockMigrator.handleBlockEntityPlaced(novaPos, null);
        }
    }
}

