/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.sound;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.world.block.logic.sound.SoundEngine;
import xyz.xenondevs.nova.world.block.sound.SoundGroup;

@Mixin(value={ServerLevel.class})
abstract class ServerLevelMixin {
    ServerLevelMixin() {
    }

    @Inject(method={"levelEvent"}, at={@At(value="HEAD")})
    private void playerWillDestroy(Entity entity, int type, BlockPos pos, int data2, CallbackInfo ci) {
        if (type != 2001) {
            return;
        }
        ServerLevel level = (ServerLevel)this;
        Block block = level.getWorld().getBlockAt(pos.getX(), pos.getY(), pos.getZ());
        SoundGroup soundGroup = BlockUtilsKt.getNovaSoundGroup(block);
        if (soundGroup == null) {
            return;
        }
        float volume = soundGroup.getBreakVolume();
        BlockState vanillaBlockState = (BlockState)net.minecraft.world.level.block.Block.BLOCK_STATE_REGISTRY.byId(data2);
        String oldSound = vanillaBlockState != null ? SoundGroup.Companion.from(vanillaBlockState.getSoundType()).getBreakSound() : "";
        SoundEngine.broadcastIfOverridden((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume > 1.0f ? (double)(16.0f * volume) : 16.0, oldSound, soundGroup.getBreakSound(), volume, soundGroup.getBreakPitch(), SoundSource.BLOCKS);
    }
}

