/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.item.repair;

import net.minecraft.world.item.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.behavior.Damageable;

@Mixin(value={ItemStack.class})
abstract class ItemStackMixin {
    ItemStackMixin() {
    }

    @Inject(method={"isValidRepairItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValidRepairItem(ItemStack ingredient, CallbackInfoReturnable<Boolean> cir) {
        ItemStack itemStack = (ItemStack)this;
        NovaItem novaItem = ItemUtilsKt.getNovaItem(itemStack);
        if (novaItem == null) {
            return;
        }
        Damageable damageable = novaItem.getBehaviorOrNull(Damageable.class);
        if (damageable == null) {
            return;
        }
        RecipeChoice repairIngredient = damageable.getRepairIngredient();
        if (repairIngredient == null) {
            return;
        }
        if (repairIngredient.test(ingredient.asBukkitMirror())) {
            cir.setReturnValue((Object)true);
        }
    }
}

