/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.initialize.Dispatcher;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.resources.CharOptions;
import xyz.xenondevs.nova.resources.CharSizeTable;
import xyz.xenondevs.nova.resources.CharSizes;
import xyz.xenondevs.nova.resources.CharSizesKt;
import xyz.xenondevs.nova.resources.ComponentSize;
import xyz.xenondevs.nova.resources.ResourceGeneration;
import xyz.xenondevs.nova.util.component.adventure.StylizedChar;
import xyz.xenondevs.nova.util.component.adventure.StylizedCharsIteratorKt;

@InternalInit(stage=InternalInitStage.POST_WORLD, dispatcher=Dispatcher.ASYNC, dependsOn={ResourceGeneration.PostWorld.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0017J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0010J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000f2\b\b\u0002\u0010\u001e\u001a\u00020\u0010J\u0016\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0010J\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\b\u0010#\u001a\u00020$H\u0003J\r\u0010%\u001a\u00020$H\u0000\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u001d\u0010*\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010+\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b,J\u0017\u0010-\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lxyz/xenondevs/nova/resources/CharSizes;", "", "<init>", "()V", "CHAR_SIZES_DIR", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "loadedTables", "Ljava/util/HashMap;", "Lnet/kyori/adventure/key/Key;", "Lxyz/xenondevs/nova/resources/CharSizeTable;", "Lkotlin/collections/HashMap;", "componentCache", "Lcom/google/common/cache/Cache;", "Lkotlin/Pair;", "Lnet/kyori/adventure/text/Component;", "", "Lxyz/xenondevs/nova/resources/ComponentSize;", "getCharWidth", "", "font", "char", "", "", "getCharYRange", "Lkotlin/ranges/ClosedRange;", "calculateStringWidth", "string", "calculateComponentWidth", "component", "lang", "calculateComponentSize", "chars", "Lkotlin/sequences/Sequence;", "Lxyz/xenondevs/nova/resources/CharOptions;", "init", "", "invalidateCache", "invalidateCache$nova", "getFontKey", "file", "loadTable", "storeTable", "table", "storeTable$nova", "getTable", "getTable$nova", "deleteTable", "deleteTable$nova", "getFile", "nova"})
@SourceDebugExtension(value={"SMAP\nCharSizes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharSizes.kt\nxyz/xenondevs/nova/resources/CharSizes\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,289:1\n1321#2,2:290\n1321#2,2:292\n*S KotlinDebug\n*F\n+ 1 CharSizes.kt\nxyz/xenondevs/nova/resources/CharSizes\n*L\n129#1:290,2\n154#1:292,2\n*E\n"})
public final class CharSizes {
    @NotNull
    public static final CharSizes INSTANCE = new CharSizes();
    private static final Path CHAR_SIZES_DIR = NovaBootstrapperKt.getDATA_FOLDER().resolve(".internal_data/char_sizes/");
    @NotNull
    private static final HashMap<Key, CharSizeTable> loadedTables = new HashMap();
    @NotNull
    private static final Cache<Pair<Component, String>, ComponentSize> componentCache;

    private CharSizes() {
    }

    public final float getCharWidth(@NotNull Key font, int n) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        CharSizeTable charSizeTable = this.getTable$nova(font);
        return charSizeTable != null ? charSizeTable.getWidth(n) : 0.0f;
    }

    public final float getCharWidth(@NotNull Key font, char c) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return this.getCharWidth(font, (int)c);
    }

    @NotNull
    public final ClosedRange<Float> getCharYRange(@NotNull Key font, int n) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        ClosedRange<Float> closedRange = this.getTable$nova(font);
        if (closedRange == null || (closedRange = closedRange.getYRange(n)) == null) {
            closedRange = CharSizesKt.access$getEMPTY_FLOAT_RANGE$p();
        }
        return closedRange;
    }

    @NotNull
    public final ClosedRange<Float> getCharYRange(@NotNull Key font, char c) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return this.getCharYRange(font, (int)c);
    }

    public final float calculateStringWidth(@NotNull Key font, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        CharSizeTable charSizeTable = this.getTable$nova(font);
        if (charSizeTable == null) {
            return 0.0f;
        }
        CharSizeTable table = charSizeTable;
        return (float)string.codePoints().mapToDouble(arg_0 -> CharSizes.calculateStringWidth$lambda$0(table, arg_0)).sum();
    }

    public final float calculateComponentWidth(@NotNull Component component2, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return this.calculateComponentSize(component2, lang).getWidth();
    }

    public static /* synthetic */ float calculateComponentWidth$default(CharSizes charSizes2, Component component2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "en_us";
        }
        return charSizes2.calculateComponentWidth(component2, string);
    }

    @NotNull
    public final ComponentSize calculateComponentSize(@NotNull Component component2, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Object object = componentCache.get((Object)TuplesKt.to((Object)component2, (Object)lang), () -> CharSizes.calculateComponentSize$lambda$0(component2, lang));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ComponentSize)object;
    }

    @NotNull
    public final ComponentSize calculateComponentSize(@NotNull Sequence<CharOptions> chars) {
        Intrinsics.checkNotNullParameter(chars, (String)"chars");
        float width = 0.0f;
        float yRangeMin = 0.0f;
        yRangeMin = Float.MAX_VALUE;
        float yRangeMax = 0.0f;
        yRangeMax = Float.MIN_VALUE;
        Sequence<CharOptions> $this$forEach$iv = chars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Key fontKey;
            CharOptions charOptions = (CharOptions)element$iv;
            boolean bl = false;
            char c = charOptions.component1();
            String font = charOptions.component2();
            boolean isBold = charOptions.component3();
            Intrinsics.checkNotNullExpressionValue((Object)Key.key((String)font), (String)"key(...)");
            float charWidth = INSTANCE.getCharWidth(fontKey, c);
            if (isBold) {
                charWidth += 1.0f;
            }
            width += charWidth;
            ClosedRange<Float> yRange = INSTANCE.getCharYRange(fontKey, c);
            float charMinY = ((Number)((Object)yRange.getStart())).floatValue();
            float charMaxY = ((Number)((Object)yRange.getEndInclusive())).floatValue();
            if (charMinY < yRangeMin) {
                yRangeMin = charMinY;
            }
            if (!(charMaxY > yRangeMax)) continue;
            yRangeMax = charMaxY;
        }
        return new ComponentSize(width, (ClosedRange<Float>)((ClosedRange)RangesKt.rangeTo((float)yRangeMin, (float)yRangeMax)));
    }

    @InitFun
    private final void init() {
        if (CharSizesKt.access$getLOAD_CHAR_SIZES_ON_STARTUP()) {
            ExecutorService service = Executors.newCachedThreadPool();
            Path path = CHAR_SIZES_DIR;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CHAR_SIZES_DIR");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]), (Function1)init.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                Key fontKey = INSTANCE.getFontKey(it);
                if (((Map)loadedTables).containsKey(fontKey)) continue;
                service.submit(() -> CharSizes.init$lambda$0$0(it));
            }
            service.shutdown();
            service.awaitTermination(5L, TimeUnit.MINUTES);
        }
    }

    public final void invalidateCache$nova() {
        componentCache.invalidateAll();
    }

    private final Key getFontKey(Path file) {
        Path path = CHAR_SIZES_DIR;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CHAR_SIZES_DIR");
        char[] cArray = new char[]{'/'};
        List fontNameParts = StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file, (Path)path)), (char)'.', null, (int)2, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        Key key = Key.key((String)((String)fontNameParts.get(0)), (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)fontNameParts, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key(...)");
        return key;
    }

    private final CharSizeTable loadTable(Key font) {
        Path file = this.getFile(font);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            CharSizeTable table = CharSizeTable.Companion.load(file);
            ((Map)loadedTables).put(font, table);
            return table;
        }
        return null;
    }

    public final void storeTable$nova(@NotNull Key font, @NotNull CharSizeTable table) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ((Map)loadedTables).put(font, table);
        table.write(this.getFile(font));
    }

    @Nullable
    public final CharSizeTable getTable$nova(@NotNull Key font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        CharSizeTable charSizeTable = loadedTables.get(font);
        if (charSizeTable == null) {
            charSizeTable = this.loadTable(font);
        }
        return charSizeTable;
    }

    public final void deleteTable$nova(@NotNull Key font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        ((Map)loadedTables).remove(font);
        Files.deleteIfExists(this.getFile(font));
    }

    private final Path getFile(Key font) {
        Path file = CHAR_SIZES_DIR.resolve(font.namespace() + "/" + font.value() + ".bin");
        Path path = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Intrinsics.checkNotNull((Object)file);
        return file;
    }

    private static final double calculateStringWidth$lambda$0(CharSizeTable $table, int it) {
        return $table.getWidth(it);
    }

    private static final ComponentSize calculateComponentSize$lambda$0(Component $component, String $lang) {
        return INSTANCE.calculateComponentSize((Sequence<CharOptions>)SequencesKt.map(StylizedCharsIteratorKt.chars($component, $lang), CharSizes::calculateComponentSize$lambda$0$0));
    }

    private static final CharOptions calculateComponentSize$lambda$0$0(StylizedChar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        char c = it.getChar();
        Object object = it.getStyle().font();
        if (object == null || (object = object.asString()) == null) {
            object = "minecraft:default";
        }
        return new CharOptions(c, (String)object, it.getStyle().hasDecoration(TextDecoration.BOLD));
    }

    private static final void init$lambda$0$0(Path $it) {
        CharSizeTable table = CharSizeTable.Companion.load($it);
        ((Map)loadedTables).put(INSTANCE.getFontKey($it), table);
    }

    static {
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        componentCache = cache;
    }
}

