/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.commons.collections.CollectionUtils;
import xyz.xenondevs.nova.resources.CharSizeTable;
import xyz.xenondevs.nova.resources.CharSizes;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.Font;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.ReferenceProvider;
import xyz.xenondevs.nova.resources.builder.task.CharSizeCalculatorKt;
import xyz.xenondevs.nova.resources.builder.task.FontContent;
import xyz.xenondevs.nova.resources.builder.task.GuiTextureTask;
import xyz.xenondevs.nova.resources.builder.task.MoveCharactersTask;
import xyz.xenondevs.nova.resources.builder.task.MovedFontContent;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.PackTask;
import xyz.xenondevs.nova.resources.builder.task.TextureIconContent;
import xyz.xenondevs.nova.resources.builder.task.WailaTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/CharSizeCalculator;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "runsAfter", "", "Lkotlin/reflect/KClass;", "getRunsAfter", "()Ljava/util/Set;", "fontContent", "Lxyz/xenondevs/nova/resources/builder/task/FontContent;", "getFontContent", "()Lxyz/xenondevs/nova/resources/builder/task/FontContent;", "fontContent$delegate", "Lkotlin/Lazy;", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nova"})
@SourceDebugExtension(value={"SMAP\nCharSizeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharSizeCalculator.kt\nxyz/xenondevs/nova/resources/builder/task/CharSizeCalculator\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,67:1\n380#2:68\n1285#3,2:69\n1299#3,4:71\n188#4,3:75\n*S KotlinDebug\n*F\n+ 1 CharSizeCalculator.kt\nxyz/xenondevs/nova/resources/builder/task/CharSizeCalculator\n*L\n32#1:68\n38#1:69,2\n38#1:71,4\n46#1:75,3\n*E\n"})
public final class CharSizeCalculator
implements PackTask {
    @NotNull
    private final ResourcePackBuilder builder;
    @NotNull
    private final Set<KClass<? extends PackTask>> runsAfter;
    @NotNull
    private final Lazy fontContent$delegate;

    public CharSizeCalculator(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(FontContent.LoadAll.class), Reflection.getOrCreateKotlinClass(GuiTextureTask.class), Reflection.getOrCreateKotlinClass(MoveCharactersTask.class), Reflection.getOrCreateKotlinClass(MovedFontContent.Write.class), Reflection.getOrCreateKotlinClass(TextureIconContent.Write.class), Reflection.getOrCreateKotlinClass(WailaTask.class)};
        this.runsAfter = SetsKt.setOf((Object[])objectArray);
        ResourcePackBuilder this_$iv = this.builder;
        boolean $i$f$getBuildDataLazily = false;
        this.fontContent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FontContent>(this_$iv){
            final /* synthetic */ ResourcePackBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public final FontContent invoke() {
                PackBuildData holder$iv;
                Object v0;
                block3: {
                    ResourcePackBuilder this_$iv = this.this$0;
                    boolean $i$f$getBuildData = false;
                    Iterable $this$firstOrNull$iv$iv = this_$iv.getData();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv$iv : $this$firstOrNull$iv$iv) {
                        PackBuildData it$iv = (PackBuildData)element$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof FontContent)) continue;
                        v0 = element$iv$iv;
                        break block3;
                    }
                    v0 = null;
                }
                PackBuildData packBuildData = v0;
                if (packBuildData == null) {
                    throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(FontContent.class).getSimpleName() + " is present");
                }
                PackBuildData packBuildData2 = holder$iv = packBuildData;
                if (packBuildData2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.FontContent");
                }
                return (FontContent)packBuildData2;
            }
        }));
    }

    @Override
    @NotNull
    public Set<KClass<? extends PackTask>> getRunsAfter() {
        return this.runsAfter;
    }

    private final FontContent getFontContent() {
        Lazy lazy = this.fontContent$delegate;
        return (FontContent)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object run(@NotNull Continuation<? super Unit> $completion) {
        void $this$associateWithTo$iv$iv;
        this.builder.getLogger().info("Calculating char sizes...");
        Map<ResourcePath<ResourceType.Font>, Font> fonts = this.getFontContent().getMergedFonts();
        Iterable $this$associateWith$iv = fonts.values();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Font font = (Font)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Set<Font> set = it.mapReferences((Iterable<Font>)fonts.values());
            map2.put(t, set);
        }
        Map references = destination$iv$iv;
        List sortedFonts = CollectionUtils.INSTANCE.sortDependencies(fonts.values(), arg_0 -> CharSizeCalculator.run$lambda$1(references, arg_0));
        for (Font font : sortedFonts) {
            try {
                ResourcePath<ResourceType.Font> id = font.getId();
                CharSizeTable table = new CharSizeTable(null, 1, null);
                for (FontProvider provider : CollectionsKt.reversed((Iterable)font.getProviders())) {
                    boolean bl;
                    block10: {
                        Map<String, Boolean> $this$any$iv = provider.getFilter();
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<Map.Entry<String, Boolean>> iterator = $this$any$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry<String, Boolean> element$iv;
                                Map.Entry<String, Boolean> entry = element$iv = iterator.next();
                                boolean bl2 = false;
                                String filterKey = entry.getKey();
                                boolean filterValue = entry.getValue();
                                if (!(filterValue != CharSizeCalculatorKt.access$getSETTINGS().contains(filterKey))) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    if (provider instanceof ReferenceProvider) {
                        CharSizeTable referencedTable;
                        if (CharSizes.INSTANCE.getTable$nova(((ReferenceProvider)provider).getId()) == null) {
                            throw new IllegalStateException("Referenced font " + ((ReferenceProvider)provider).getId() + " has no char size table");
                        }
                        table.merge(referencedTable);
                        continue;
                    }
                    table.merge(provider.getCharSizes$nova());
                }
                CharSizes.INSTANCE.storeTable$nova(id, table);
            }
            catch (Throwable t) {
                this.builder.getLogger().error("Failed to calculate char sizes for font " + font.getId(), t);
            }
        }
        CharSizes.INSTANCE.invalidateCache$nova();
        return Unit.INSTANCE;
    }

    private static final Set run$lambda$1(Map $references, Font it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object v = $references.get(it);
        Intrinsics.checkNotNull(v);
        return (Set)v;
    }
}

