/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.BitmapFontGenerator;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.Font;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.ReferenceProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.BitmapProvider;
import xyz.xenondevs.nova.resources.builder.task.FontContent;
import xyz.xenondevs.nova.resources.builder.task.MovedFontContentKt;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.PackTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J\u001e\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\tH\u0002R&\u0010\u0004\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/MovedFontContent;", "Lxyz/xenondevs/nova/resources/builder/task/PackBuildData;", "<init>", "()V", "requested", "Ljava/util/HashSet;", "Lkotlin/Pair;", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$Font;", "", "queue", "Ljava/util/LinkedList;", "requestMovedFonts", "", "font", "offsets", "", "requestMovedFont", "y", "Write", "nova"})
public final class MovedFontContent
implements PackBuildData {
    @NotNull
    private final HashSet<Pair<ResourcePath<ResourceType.Font>, Integer>> requested = new HashSet();
    @NotNull
    private final LinkedList<Pair<ResourcePath<ResourceType.Font>, Integer>> queue = new LinkedList();

    public final void requestMovedFonts(@NotNull ResourcePath<ResourceType.Font> font, @NotNull Iterable<Integer> offsets) {
        Intrinsics.checkNotNullParameter(font, (String)"font");
        Intrinsics.checkNotNullParameter(offsets, (String)"offsets");
        Iterator<Integer> iterator = offsets.iterator();
        while (iterator.hasNext()) {
            int y = ((Number)iterator.next()).intValue();
            this.requestMovedFont(font, y);
        }
    }

    private final void requestMovedFont(ResourcePath<ResourceType.Font> font, int y) {
        if (MovedFontContentKt.access$getMOVED_FONT_BLACKLIST().contains(font)) {
            return;
        }
        Pair pair = TuplesKt.to(font, (Object)y);
        if (this.requested.contains(pair)) {
            return;
        }
        ((Collection)this.requested).add(pair);
        ((Collection)this.queue).add(pair);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tR\u00020\n0\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u000eR\u00020\n0\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u001b\u0010\u0010\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/resources/builder/task/MovedFontContent$Write;", "Lxyz/xenondevs/nova/resources/builder/task/PackTask;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/task/MovedFontContent;Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "runsAfter", "", "Lkotlin/reflect/KClass;", "Lxyz/xenondevs/nova/resources/builder/task/FontContent$LoadAll;", "Lxyz/xenondevs/nova/resources/builder/task/FontContent;", "getRunsAfter", "()Ljava/util/Set;", "runsBefore", "Lxyz/xenondevs/nova/resources/builder/task/FontContent$Write;", "getRunsBefore", "fontContent", "getFontContent", "()Lxyz/xenondevs/nova/resources/builder/task/FontContent;", "fontContent$delegate", "Lkotlin/Lazy;", "run", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nova"})
    @SourceDebugExtension(value={"SMAP\nMovedFontContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovedFontContent.kt\nxyz/xenondevs/nova/resources/builder/task/MovedFontContent$Write\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,101:1\n380#2:102\n382#3,7:103\n*S KotlinDebug\n*F\n+ 1 MovedFontContent.kt\nxyz/xenondevs/nova/resources/builder/task/MovedFontContent$Write\n*L\n58#1:102\n65#1:103,7\n*E\n"})
    public final class Write
    implements PackTask {
        @NotNull
        private final ResourcePackBuilder builder;
        @NotNull
        private final Set<KClass<FontContent.LoadAll>> runsAfter;
        @NotNull
        private final Set<KClass<FontContent.Write>> runsBefore;
        @NotNull
        private final Lazy fontContent$delegate;

        public Write(ResourcePackBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
            this.runsAfter = SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(FontContent.LoadAll.class));
            this.runsBefore = SetsKt.setOf((Object)Reflection.getOrCreateKotlinClass(FontContent.Write.class));
            ResourcePackBuilder this_$iv = this.builder;
            boolean $i$f$getBuildDataLazily = false;
            this.fontContent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FontContent>(this_$iv){
                final /* synthetic */ ResourcePackBuilder this$0;
                {
                    this.this$0 = $receiver;
                }

                public final FontContent invoke() {
                    PackBuildData holder$iv;
                    Object v0;
                    block3: {
                        ResourcePackBuilder this_$iv = this.this$0;
                        boolean $i$f$getBuildData = false;
                        Iterable $this$firstOrNull$iv$iv = this_$iv.getData();
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv$iv : $this$firstOrNull$iv$iv) {
                            PackBuildData it$iv = (PackBuildData)element$iv$iv;
                            boolean bl = false;
                            if (!(it$iv instanceof FontContent)) continue;
                            v0 = element$iv$iv;
                            break block3;
                        }
                        v0 = null;
                    }
                    PackBuildData packBuildData = v0;
                    if (packBuildData == null) {
                        throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(FontContent.class).getSimpleName() + " is present");
                    }
                    PackBuildData packBuildData2 = holder$iv = packBuildData;
                    if (packBuildData2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.FontContent");
                    }
                    return (FontContent)packBuildData2;
                }
            }));
        }

        @NotNull
        public Set<KClass<FontContent.LoadAll>> getRunsAfter() {
            return this.runsAfter;
        }

        @NotNull
        public Set<KClass<FontContent.Write>> getRunsBefore() {
            return this.runsBefore;
        }

        private final FontContent getFontContent() {
            Lazy lazy = this.fontContent$delegate;
            return (FontContent)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Object run(@NotNull Continuation<? super Unit> $completion) {
            this.builder.getLogger().info("Creating moved fonts");
            HashMap<ResourcePath<ResourceType.Font>, Font> bitmapFonts = new HashMap<ResourcePath<ResourceType.Font>, Font>();
            while (!((Collection)MovedFontContent.this.queue).isEmpty()) {
                Pair pair = (Pair)MovedFontContent.this.queue.poll();
                ResourcePath font = (ResourcePath)pair.component1();
                int y = ((Number)pair.component2()).intValue();
                Font movedFont = new Font(new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, font.getNamespace(), font.getPath() + "/" + y), null, 2, null);
                Font bitmapFont = Write.run$getBitmapFont(bitmapFonts, this, font);
                for (FontProvider provider : bitmapFont.getProviders()) {
                    FontProvider fontProvider;
                    Font font2 = movedFont;
                    FontProvider fontProvider2 = provider;
                    if (fontProvider2 instanceof BitmapProvider) {
                        fontProvider = BitmapProvider.Companion.reference((BitmapProvider)provider, ((BitmapProvider)provider).getAscent() - y);
                    } else if (fontProvider2 instanceof ReferenceProvider) {
                        void $this$run_u24lambda_u241;
                        ReferenceProvider referenceProvider;
                        ResourcePath<ResourceType.Font> id = ((ReferenceProvider)provider).getId();
                        MovedFontContent.this.requestMovedFont(id, y);
                        ReferenceProvider referenceProvider2 = referenceProvider = new ReferenceProvider(new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, id.getNamespace(), id.getPath() + "/" + y));
                        Font font3 = font2;
                        boolean bl = false;
                        $this$run_u24lambda_u241.getFilter().putAll(provider.getFilter());
                        font2 = font3;
                        fontProvider = referenceProvider;
                    } else {
                        fontProvider = provider;
                    }
                    font2.plusAssign(fontProvider);
                }
                this.getFontContent().plusAssign(movedFont);
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Font run$getBitmapFont(HashMap<ResourcePath<ResourceType.Font>, Font> bitmapFonts, Write this$0, ResourcePath<ResourceType.Font> id) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = bitmapFonts;
            ResourcePath<ResourceType.Font> key$iv = id;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Font font = this$0.getFontContent().getMergedFonts().get(id);
                if (font == null) {
                    throw new IllegalStateException("Font " + id + " does not exist or is not loaded in FontContent");
                }
                Font font2 = font;
                Font answer$iv = new BitmapFontGenerator(this$0.builder, font2).generateBitmapFont();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (Font)object;
        }
    }
}

