/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.component.adventure;

import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.i18n.LocaleManager;
import xyz.xenondevs.nova.util.component.adventure.StylizedChar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\t\u0010\u001b\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000f\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lxyz/xenondevs/nova/util/component/adventure/ComponentCharsIterator;", "", "Lxyz/xenondevs/nova/util/component/adventure/StylizedChar;", "outerStyle", "Lnet/kyori/adventure/text/format/Style;", "component", "Lnet/kyori/adventure/text/Component;", "lang", "", "<init>", "(Lnet/kyori/adventure/text/format/Style;Lnet/kyori/adventure/text/Component;Ljava/lang/String;)V", "getLang", "()Ljava/lang/String;", "components", "Lit/unimi/dsi/fastutil/Stack;", "styles", "childIndices", "Lit/unimi/dsi/fastutil/ints/IntStack;", "argIndices", "contentStrings", "readHeads", "content", "style", "readHead", "", "hasNext", "", "next", "hasNextChar", "nextTextChar", "", "nextTranslatableChar", "()Ljava/lang/Character;", "nextComponent", "", "nextArg", "pushArg", "argIdx", "pushComponent", "nova"})
@SourceDebugExtension(value={"SMAP\nStylizedCharsIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StylizedCharsIterator.kt\nxyz/xenondevs/nova/util/component/adventure/ComponentCharsIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1563#2:200\n1634#2,3:201\n1563#2:204\n1634#2,3:205\n*S KotlinDebug\n*F\n+ 1 StylizedCharsIterator.kt\nxyz/xenondevs/nova/util/component/adventure/ComponentCharsIterator\n*L\n152#1:200\n152#1:201,3\n160#1:204\n160#1:205,3\n*E\n"})
final class ComponentCharsIterator
implements Iterator<StylizedChar>,
KMappedMarker {
    @NotNull
    private final String lang;
    @NotNull
    private final Stack<Component> components;
    @NotNull
    private final Stack<Style> styles;
    @NotNull
    private final IntStack childIndices;
    @NotNull
    private final IntStack argIndices;
    @NotNull
    private final Stack<String> contentStrings;
    @NotNull
    private final IntStack readHeads;
    private Component component;
    private String content;
    private Style style;
    private int readHead;

    public ComponentCharsIterator(@Nullable Style outerStyle, @NotNull Component component2, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.lang = lang;
        this.components = (Stack)new ObjectArrayList();
        this.styles = (Stack)new ObjectArrayList();
        this.childIndices = (IntStack)new IntArrayList();
        this.argIndices = (IntStack)new IntArrayList();
        this.contentStrings = (Stack)new ObjectArrayList();
        this.readHeads = (IntStack)new IntArrayList();
        this.readHead = -1;
        Style style = outerStyle;
        if (style == null) {
            Style style2 = Style.empty();
            style = style2;
            Intrinsics.checkNotNullExpressionValue((Object)style2, (String)"empty(...)");
        }
        this.styles.push((Object)style);
        this.pushComponent(component2);
    }

    @NotNull
    public final String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasNext() {
        return !this.components.isEmpty();
    }

    @Override
    @NotNull
    public StylizedChar next() {
        Style style;
        Character c;
        Character c2 = null;
        do {
            Component component2;
            if (this.components.isEmpty()) {
                throw new NoSuchElementException();
            }
            Component component3 = this.component;
            if (component3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                component3 = null;
            }
            if ((component2 = component3) instanceof TextComponent) {
                c = Character.valueOf(this.nextTextChar());
                continue;
            }
            if (component2 instanceof TranslatableComponent) {
                c = this.nextTranslatableChar();
                continue;
            }
            Component component4 = this.component;
            if (component4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
                component4 = null;
            }
            throw new UnsupportedOperationException("Unsupported component type: " + Reflection.getOrCreateKotlinClass(component4.getClass()).getQualifiedName());
        } while ((c2 = c) == null);
        Style style2 = this.style;
        if (style2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            style2 = style = null;
        }
        if (!this.hasNextChar()) {
            this.nextComponent();
        }
        return new StylizedChar(c2.charValue(), style);
    }

    private final boolean hasNextChar() {
        String string = this.content;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string = null;
        }
        return this.readHead < string.length();
    }

    private final char nextTextChar() {
        String string = this.content;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string = null;
        }
        int n = this.readHead;
        this.readHead = n + 1;
        return string.charAt(n);
    }

    private final Character nextTranslatableChar() {
        String fstr;
        char c;
        String string = this.content;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"content");
            string = null;
        }
        if ((c = (fstr = string).charAt(this.readHead)) == '%') {
            if (StringsKt.getLastIndex((CharSequence)fstr) > this.readHead && fstr.charAt(this.readHead + 1) == '%') {
                this.readHead += 2;
                return Character.valueOf('%');
            }
            if (StringsKt.getLastIndex((CharSequence)fstr) > this.readHead && fstr.charAt(this.readHead + 1) == 's') {
                this.readHead += 2;
                this.nextArg();
                return null;
            }
            if (StringsKt.getLastIndex((CharSequence)fstr) > this.readHead + 2 && Character.isDigit(fstr.charAt(this.readHead + 1)) && fstr.charAt(this.readHead + 2) == '$' && fstr.charAt(this.readHead + 3) == 's') {
                this.readHead += 4;
                this.pushArg(CharsKt.digitToInt((char)fstr.charAt(this.readHead + 1)));
                return null;
            }
            throw new IllegalArgumentException("Invalid format string: " + fstr);
        }
        int n = this.readHead;
        this.readHead = n + 1;
        return Character.valueOf(c);
    }

    private final void nextComponent() {
        do {
            List children;
            Intrinsics.checkNotNullExpressionValue((Object)((Component)this.components.top()).children(), (String)"children(...)");
            int childIdx = this.childIndices.popInt() + 1;
            if (childIdx <= CollectionsKt.getLastIndex((List)children)) {
                this.childIndices.push(childIdx);
                Component child = (Component)children.get(childIdx);
                Intrinsics.checkNotNull((Object)child);
                this.pushComponent(child);
                break;
            }
            this.components.pop();
            this.contentStrings.pop();
            this.styles.pop();
            this.argIndices.popInt();
            if (this.readHeads.isEmpty()) continue;
            this.readHead = this.readHeads.popInt();
            Object object = this.contentStrings.top();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"top(...)");
            this.content = (String)object;
            String string = this.content;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"content");
                string = null;
            }
            if (this.readHead >= string.length()) continue;
            Object object2 = this.components.top();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"top(...)");
            this.component = (Component)object2;
            Object object3 = this.styles.top();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"top(...)");
            this.style = (Style)object3;
            break;
        } while (!this.components.isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private final void nextArg() {
        void $this$mapTo$iv$iv;
        Object object = this.components.top();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.kyori.adventure.text.TranslatableComponent");
        List list = ((TranslatableComponent)object).arguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"arguments(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TranslationArgument translationArgument = (TranslationArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asComponent());
        }
        List args = (List)destination$iv$iv;
        int argIdx = this.argIndices.popInt() + 1;
        this.argIndices.push(argIdx);
        Component component2 = (Component)CollectionsKt.getOrNull((List)args, (int)argIdx);
        if (component2 == null) {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
            component2 = (Component)textComponent;
        }
        Component arg = component2;
        this.pushComponent(arg);
    }

    /*
     * WARNING - void declaration
     */
    private final void pushArg(int argIdx) {
        void $this$mapTo$iv$iv;
        Object object = this.components.top();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.kyori.adventure.text.TranslatableComponent");
        List list = ((TranslatableComponent)object).arguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"arguments(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TranslationArgument translationArgument = (TranslationArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asComponent());
        }
        List args = (List)destination$iv$iv;
        Component component2 = (Component)CollectionsKt.getOrNull((List)args, (int)argIdx);
        if (component2 == null) {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
            component2 = (Component)textComponent;
        }
        Component arg = component2;
        this.pushComponent(arg);
    }

    private final void pushComponent(Component component2) {
        String string;
        this.components.push((Object)component2);
        this.childIndices.push(-1);
        this.argIndices.push(-1);
        if (this.readHead != -1) {
            this.readHeads.push(this.readHead);
        }
        Style prevStyle = (Style)this.styles.top();
        Style style = component2.style().merge(prevStyle);
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"merge(...)");
        Style style2 = style;
        this.styles.push((Object)style2);
        Component component3 = component2;
        if (component3 instanceof TextComponent) {
            string = ((TextComponent)component2).content();
        } else if (component3 instanceof TranslatableComponent) {
            String string2 = ((TranslatableComponent)component2).key();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"key(...)");
            string = LocaleManager.INSTANCE.getFormatString(this.lang, string2);
        } else {
            throw new UnsupportedOperationException("Unsupported component type: " + Reflection.getOrCreateKotlinClass(component2.getClass()).getQualifiedName());
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String content = string3;
        this.contentStrings.push((Object)content);
        this.component = component2;
        this.style = style2;
        this.content = content;
        this.readHead = 0;
        if (((CharSequence)content).length() == 0) {
            this.nextComponent();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

