/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.data;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.Base64;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.data.BinaryUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0001H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a\u0016\u0010\t\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0005H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0005*\u00020\u000eH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\u0001\u00a8\u0006\u0015"}, d2={"writeByte", "Lio/netty/buffer/ByteBuf;", "byte", "", "toByteArray", "", "toByteBuf", "allocator", "Lkotlin/Function0;", "compress", "compressType", "", "decompress", "encodeBase64", "", "decodeBase64", "writeUUID", "", "uuid", "Ljava/util/UUID;", "readUUID", "nova"})
public final class BinaryUtilsKt {
    @NotNull
    public static final ByteBuf writeByte(@NotNull ByteBuf $this$writeByte, byte by) {
        Intrinsics.checkNotNullParameter((Object)$this$writeByte, (String)"<this>");
        ByteBuf byteBuf = $this$writeByte.writeByte((int)by);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuf $this$toByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        $this$toByteArray.markReaderIndex();
        $this$toByteArray.readerIndex(0);
        byte[] bytes = new byte[$this$toByteArray.readableBytes()];
        $this$toByteArray.readBytes(bytes);
        $this$toByteArray.resetReaderIndex();
        return bytes;
    }

    @NotNull
    public static final ByteBuf toByteBuf(@NotNull byte[] $this$toByteBuf, @NotNull Function0<? extends ByteBuf> allocator) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteBuf, (String)"<this>");
        Intrinsics.checkNotNullParameter(allocator, (String)"allocator");
        ByteBuf buf = (ByteBuf)allocator.invoke();
        buf.writeBytes($this$toByteBuf);
        return buf;
    }

    public static /* synthetic */ ByteBuf toByteBuf$default(byte[] byArray, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = toByteBuf.1.INSTANCE;
        }
        return BinaryUtilsKt.toByteBuf(byArray, (Function0<? extends ByteBuf>)function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] compress(@NotNull byte[] $this$compress, int compressType) {
        Intrinsics.checkNotNullParameter((Object)$this$compress, (String)"<this>");
        Deflater deflater = new Deflater(compressType);
        byte[] buffer = new byte[512];
        deflater.setInput($this$compress);
        deflater.finish();
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                out.write(buffer, 0, count);
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ byte[] compress$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return BinaryUtilsKt.compress(byArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] decompress(@NotNull byte[] $this$decompress) {
        Intrinsics.checkNotNullParameter((Object)$this$decompress, (String)"<this>");
        Inflater inflater = new Inflater();
        byte[] buffer = new byte[512];
        inflater.setInput($this$decompress);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream out = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                out.write(buffer, 0, count);
            }
            byte[] byArray = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final String encodeBase64(@NotNull byte[] $this$encodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        String string = Base64.getEncoder().encodeToString($this$encodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        byte[] byArray = Base64.getDecoder().decode($this$decodeBase64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }

    public static final void writeUUID(@NotNull ByteBuf $this$writeUUID, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        $this$writeUUID.writeLong(uuid.getMostSignificantBits());
        $this$writeUUID.writeLong(uuid.getLeastSignificantBits());
    }

    @NotNull
    public static final UUID readUUID(@NotNull ByteBuf $this$readUUID) {
        Intrinsics.checkNotNullParameter((Object)$this$readUUID, (String)"<this>");
        return new UUID($this$readUUID.readLong(), $this$readUUID.readLong());
    }
}

