/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.world;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.GlobalPalette;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.SingleValuePalette;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.LevelChunkSectionFieldExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jc\u0010\f\u001a4\u00120\u0012.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f\u0018\u00010\u000ej\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000f\u0018\u0001`\u00110\r2\u0006\u0010\u0012\u001a\u00020\u00132\u001c\u0010\u0014\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0015\u00a2\u0006\u0002\u0010\u0016J0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\b\u0012\u0004\u0012\u00020\u00070\u00182\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\b\u0012\u0004\u0012\u00020\u00070\u001b2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J0\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\n*\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002RV\u0010\u0004\u001aJ\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\u0005j$\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/util/world/BlockStateSearcher;", "", "<init>", "()V", "globalPaletteCache", "Ljava/util/HashMap;", "Lkotlin/Function1;", "Lnet/minecraft/world/level/block/state/BlockState;", "", "Lxyz/xenondevs/nova/util/world/ChunkSearchQuery;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkotlin/collections/HashMap;", "searchChunk", "", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lxyz/xenondevs/nova/world/BlockPos;", "Lkotlin/collections/ArrayList;", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "queries", "", "(Lxyz/xenondevs/nova/world/ChunkPos;Ljava/util/List;)[Ljava/util/ArrayList;", "findIds", "Lnet/minecraft/world/level/chunk/Palette;", "query", "findIdSingle", "Lnet/minecraft/world/level/chunk/SingleValuePalette;", "findIdsLinear", "Lnet/minecraft/world/level/chunk/LinearPalette;", "findIdsHashMap", "Lnet/minecraft/world/level/chunk/HashMapPalette;", "findIdsGlobal", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockStateSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockStateSearcher.kt\nxyz/xenondevs/nova/util/world/BlockStateSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Arrays.kt\nxyz/xenondevs/commons/collections/ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,141:1\n1#2:142\n6#3,9:143\n382#4,7:152\n*S KotlinDebug\n*F\n+ 1 BlockStateSearcher.kt\nxyz/xenondevs/nova/util/world/BlockStateSearcher\n*L\n58#1:143,9\n128#1:152,7\n*E\n"})
public final class BlockStateSearcher {
    @NotNull
    public static final BlockStateSearcher INSTANCE = new BlockStateSearcher();
    @NotNull
    private static final HashMap<Function1<BlockState, Boolean>, Int2ObjectMap<BlockState>> globalPaletteCache = new HashMap();

    private BlockStateSearcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Pair<BlockPos, BlockState>>[] searchChunk(@NotNull ChunkPos pos, @NotNull List<? extends Function1<? super BlockState, Boolean>> queries) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        World world = pos.getWorld();
        if (!(world != null)) {
            boolean bl = false;
            String string = "World does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        ArrayList[] result = new ArrayList[queries.size()];
        Intrinsics.checkNotNullExpressionValue((Object)NMSUtilsKt.getServerLevel((World)world).getChunk((int)pos.getX(), (int)pos.getZ()).sections, (String)"sections");
        block3: for (LevelChunkSection section : NMSUtilsKt.getServerLevel((World)world).getChunk((int)pos.getX(), (int)pos.getZ()).sections) {
            PalettedContainer container2 = section.states;
            container2.acquire();
            try {
                Intrinsics.checkNotNull((Object)section);
                int bottomY = LevelChunkSectionFieldExtensionsKt.getBottomBlockY(section);
                PalettedContainer.Data data2 = container2.data;
                Palette palette = data2.palette();
                BitStorage storage = null;
                Iterator iterator = ((Iterable)queries).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    ArrayList arrayList;
                    void $this$getOrSet$iv;
                    int queryIdx = n++;
                    Function1 query = (Function1)iterator.next();
                    Intrinsics.checkNotNull((Object)palette);
                    Int2ObjectMap<BlockState> ids = this.findIds((Palette<BlockState>)palette, (Function1<? super BlockState, Boolean>)query);
                    if (ids.isEmpty()) continue;
                    if (storage == null) {
                        storage = data2.storage();
                    }
                    if (storage instanceof ZeroBitStorage) {
                        continue block3;
                    }
                    ArrayList[] arrayListArray = result;
                    int index$iv = queryIdx;
                    boolean $i$f$getOrSet = false;
                    ArrayList value$iv = $this$getOrSet$iv[index$iv];
                    if (value$iv == null) {
                        boolean bl = false;
                        $this$getOrSet$iv[index$iv] = value$iv = new ArrayList();
                        arrayList = value$iv;
                    } else {
                        arrayList = value$iv;
                    }
                    void resultList = arrayList;
                    int n2 = storage.getSize();
                    for (int encodedPos = 0; encodedPos < n2; ++encodedPos) {
                        int id = storage.get(encodedPos);
                        if (!((IntSet)ids.keySet()).contains(id)) continue;
                        int x = encodedPos & 0xF;
                        int z = encodedPos >> 4 & 0xF;
                        int y = encodedPos >> 8;
                        ((Collection)resultList).add(TuplesKt.to((Object)new BlockPos(world, (pos.getX() << 4) + x, y + bottomY, (pos.getZ() << 4) + z), (Object)ids.get(id)));
                    }
                }
            }
            finally {
                container2.release();
            }
        }
        return result;
    }

    private final Int2ObjectMap<BlockState> findIds(Palette<BlockState> $this$findIds, Function1<? super BlockState, Boolean> query) {
        Int2ObjectMap<BlockState> int2ObjectMap;
        Palette<BlockState> palette = $this$findIds;
        if (palette instanceof SingleValuePalette) {
            int2ObjectMap = this.findIdSingle((SingleValuePalette<BlockState>)((SingleValuePalette)$this$findIds), query);
        } else if (palette instanceof LinearPalette) {
            int2ObjectMap = this.findIdsLinear((LinearPalette<BlockState>)((LinearPalette)$this$findIds), query);
        } else if (palette instanceof HashMapPalette) {
            int2ObjectMap = this.findIdsHashMap((HashMapPalette<BlockState>)((HashMapPalette)$this$findIds), query);
        } else if (palette instanceof GlobalPalette) {
            int2ObjectMap = this.findIdsGlobal(query);
        } else {
            throw new UnsupportedOperationException("Unsupported palette type " + KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass($this$findIds.getClass())));
        }
        return int2ObjectMap;
    }

    private final Int2ObjectMap<BlockState> findIdSingle(SingleValuePalette<BlockState> $this$findIdSingle, Function1<? super BlockState, Boolean> query) {
        if ($this$findIdSingle.maybeHas(arg_0 -> BlockStateSearcher.findIdSingle$lambda$0(query, arg_0))) {
            Object[] objectArray = new int[]{0};
            int[] nArray = objectArray;
            objectArray = new BlockState[1];
            objectArray[0] = (int)$this$findIdSingle.valueFor(0);
            return (Int2ObjectMap)new Int2ObjectArrayMap(nArray, objectArray);
        }
        return (Int2ObjectMap)new Int2ObjectArrayMap(new int[0], new Object[0]);
    }

    private final Int2ObjectMap<BlockState> findIdsLinear(LinearPalette<BlockState> $this$findIdsLinear, Function1<? super BlockState, Boolean> query) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)$this$findIdsLinear.values, (String)"values");
        Object[] values = $this$findIdsLinear.values;
        int n = values.length;
        for (int j = 0; j < n; ++j) {
            int idx = j;
            Object value = values[j];
            if (!(value instanceof BlockState) || !((Boolean)query.invoke(value)).booleanValue()) continue;
            result.put(idx, value);
        }
        return (Int2ObjectMap)result;
    }

    private final Int2ObjectMap<BlockState> findIdsHashMap(HashMapPalette<BlockState> $this$findIdsHashMap, Function1<? super BlockState, Boolean> query) {
        Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
        Iterator iterator = ((Iterable)$this$findIdsHashMap.values).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            BlockState value = (BlockState)iterator.next();
            Intrinsics.checkNotNull((Object)value);
            if (!((Boolean)query.invoke((Object)value)).booleanValue()) continue;
            result.put(idx, (Object)value);
        }
        return (Int2ObjectMap)result;
    }

    /*
     * WARNING - void declaration
     */
    private final Int2ObjectMap<BlockState> findIdsGlobal(Function1<? super BlockState, Boolean> query) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = globalPaletteCache;
        Function1<? super BlockState, Boolean> key$iv = query;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            Iterator iterator = ((Iterable)Block.BLOCK_STATE_REGISTRY).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int idx = n++;
                BlockState value = (BlockState)iterator.next();
                Intrinsics.checkNotNull((Object)value);
                if (!((Boolean)query.invoke((Object)value)).booleanValue()) continue;
                result.put(idx, (Object)value);
            }
            Int2ObjectMap answer$iv = (Int2ObjectMap)result;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Int2ObjectMap)object;
    }

    private static final boolean findIdSingle$lambda$0(Function1 $tmp0, BlockState p0) {
        return (Boolean)$tmp0.invoke((Object)p0);
    }
}

