/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.serialization.kotlinx.UUIDSerializer;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.ChunkPos$;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 82\u00020\u0001:\u000278B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB5\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u001d2\u0006\u0010\u001e\u001a\u00020\u0005J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\u0013\u0010&\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J'\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001J%\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0001\u00a2\u0006\u0002\b6R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00069"}, d2={"Lxyz/xenondevs/nova/world/ChunkPos;", "", "worldUUID", "Ljava/util/UUID;", "x", "", "z", "<init>", "(Ljava/util/UUID;II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/UUID;IILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getWorldUUID$annotations", "()V", "getWorldUUID", "()Ljava/util/UUID;", "getX", "()I", "getZ", "chunk", "Lorg/bukkit/Chunk;", "getChunk", "()Lorg/bukkit/Chunk;", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "getInRange", "", "range", "blockPos", "Lxyz/xenondevs/nova/world/BlockPos;", "y", "isLoaded", "", "toLong", "", "equals", "other", "hashCode", "component1", "component2", "component3", "copy", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$nova", "$serializer", "Companion", "nova"})
public final class ChunkPos {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID worldUUID;
    private final int x;
    private final int z;

    public ChunkPos(@NotNull UUID worldUUID, int x, int z) {
        Intrinsics.checkNotNullParameter((Object)worldUUID, (String)"worldUUID");
        this.worldUUID = worldUUID;
        this.x = x;
        this.z = z;
    }

    @NotNull
    public final UUID getWorldUUID() {
        return this.worldUUID;
    }

    @Serializable(with=UUIDSerializer.class)
    public static /* synthetic */ void getWorldUUID$annotations() {
    }

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    @Nullable
    public final Chunk getChunk() {
        World world = this.getWorld();
        return world != null ? world.getChunkAt(this.x, this.z) : null;
    }

    @Nullable
    public final World getWorld() {
        return Bukkit.getWorld((UUID)this.worldUUID);
    }

    @NotNull
    public final Set<ChunkPos> getInRange(int range) {
        int length = 2 * range + 1;
        HashSet<ChunkPos> chunks = new HashSet<ChunkPos>(length * length);
        int newX = this.x - range;
        int n = this.x + range;
        if (newX <= n) {
            while (true) {
                int n2;
                int newZ;
                if ((newZ = this.z - range) <= (n2 = this.z + range)) {
                    while (true) {
                        chunks.add(new ChunkPos(this.worldUUID, newX, newZ));
                        if (newZ == n2) break;
                        ++newZ;
                    }
                }
                if (newX == n) break;
                ++newX;
            }
        }
        return chunks;
    }

    @NotNull
    public final BlockPos blockPos(int x, int y, int z) {
        World world = this.getWorld();
        Intrinsics.checkNotNull((Object)world);
        return new BlockPos(world, (this.x << 4) + x, y, (this.z << 4) + z);
    }

    public final boolean isLoaded() {
        World world = this.getWorld();
        return world != null ? world.isChunkLoaded(this.x, this.z) : false;
    }

    public final long toLong() {
        return ((long)this.z & 0xFFFFFFFFL) << 32 | (long)this.x & 0xFFFFFFFFL;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ChunkPos && Intrinsics.areEqual((Object)((ChunkPos)other).worldUUID, (Object)this.worldUUID) && ((ChunkPos)other).x == this.x && ((ChunkPos)other).z == this.z;
    }

    public int hashCode() {
        int result = this.worldUUID.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    @NotNull
    public final UUID component1() {
        return this.worldUUID;
    }

    public final int component2() {
        return this.x;
    }

    public final int component3() {
        return this.z;
    }

    @NotNull
    public final ChunkPos copy(@NotNull UUID worldUUID, int x, int z) {
        Intrinsics.checkNotNullParameter((Object)worldUUID, (String)"worldUUID");
        return new ChunkPos(worldUUID, x, z);
    }

    public static /* synthetic */ ChunkPos copy$default(ChunkPos chunkPos, UUID uUID, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            uUID = chunkPos.worldUUID;
        }
        if ((n3 & 2) != 0) {
            n = chunkPos.x;
        }
        if ((n3 & 4) != 0) {
            n2 = chunkPos.z;
        }
        return chunkPos.copy(uUID, n, n2);
    }

    @NotNull
    public String toString() {
        return "ChunkPos(worldUUID=" + this.worldUUID + ", x=" + this.x + ", z=" + this.z + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$nova(ChunkPos self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)UUIDSerializer.INSTANCE, (Object)self.worldUUID);
        output.encodeIntElement(serialDesc, 1, self.x);
        output.encodeIntElement(serialDesc, 2, self.z);
    }

    public /* synthetic */ ChunkPos(int seen0, UUID worldUUID, int x, int z, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.worldUUID = worldUUID;
        this.x = x;
        this.z = z;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lxyz/xenondevs/nova/world/ChunkPos$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lxyz/xenondevs/nova/world/ChunkPos;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ChunkPos> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

