/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.behavior;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.bukkit.Instrument;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.behavior.BlockBehavior;
import xyz.xenondevs.nova.world.block.behavior.NoteBlockBehaviorKt;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.property.BlockStateProperty;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.fakeentity.FakeEntityManager;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010!\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lxyz/xenondevs/nova/world/block/behavior/NoteBlockBehavior;", "Lxyz/xenondevs/nova/world/block/behavior/BlockBehavior;", "<init>", "()V", "handleInteract", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "state", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockInteract;", "handleAttack", "", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockBreak;", "handleNeighborChanged", "cycleNote", "playNote", "playSound", "instrument", "Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "note", "", "spawnParticle", "getDrops", "", "Lorg/bukkit/inventory/ItemStack;", "determineInstrument", "bukkitInstrument", "Lorg/bukkit/Instrument;", "getBukkitInstrument", "(Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;)Lorg/bukkit/Instrument;", "pickBlockCreative", "nova"})
@SourceDebugExtension(value={"SMAP\nNoteBlockBehavior.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoteBlockBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/NoteBlockBehavior\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1869#2,2:180\n*S KotlinDebug\n*F\n+ 1 NoteBlockBehavior.kt\nxyz/xenondevs/nova/world/block/behavior/NoteBlockBehavior\n*L\n128#1:180,2\n*E\n"})
public final class NoteBlockBehavior
implements BlockBehavior {
    @NotNull
    public static final NoteBlockBehavior INSTANCE = new NoteBlockBehavior();

    private NoteBlockBehavior() {
    }

    @Override
    public boolean handleInteract(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockInteract> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Player player = ctx.get(DefaultContextParamTypes.INSTANCE.getSOURCE_PLAYER());
        boolean bl = player != null ? player.isSneaking() : false;
        if (bl) {
            return false;
        }
        BlockFace clickedFace = ctx.get(DefaultContextParamTypes.INSTANCE.getCLICKED_BLOCK_FACE());
        ItemStack item = ctx.get(DefaultContextParamTypes.INSTANCE.getINTERACTION_ITEM_STACK());
        if (item != null && ItemUtilsKt.getNovaItem(item) == null && Tag.ITEMS_NOTEBLOCK_TOP_INSTRUMENTS.isTagged((Keyed)item.getType()) && clickedFace == BlockFace.UP) {
            return false;
        }
        this.cycleNote(pos, state);
        this.playNote(pos, state);
        return true;
    }

    @Override
    public void handleAttack(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.playNote(pos, state);
    }

    @Override
    public void handleNeighborChanged(@NotNull BlockPos pos, @NotNull NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean poweredPreviously = (Boolean)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getPOWERED());
        boolean poweredNow = pos.getBlock().isBlockIndirectlyPowered();
        NovaBlockState newState = state.with(DefaultBlockStateProperties.INSTANCE.getPOWERED(), poweredNow).with((BlockStateProperty)DefaultBlockStateProperties.INSTANCE.getNOTE_BLOCK_INSTRUMENT$nova(), this.determineInstrument(pos));
        if (!poweredPreviously && poweredNow) {
            this.playNote(pos, newState);
        }
        if (!Intrinsics.areEqual((Object)newState, (Object)state)) {
            WorldDataManager.INSTANCE.setBlockState(pos, newState);
            BlockUtils.INSTANCE.broadcastBlockUpdate$nova(pos);
        }
    }

    private final void cycleNote(BlockPos pos, NovaBlockState state) {
        WorldDataManager.INSTANCE.setBlockState(pos, state.cycle(DefaultBlockStateProperties.INSTANCE.getNOTE_BLOCK_NOTE$nova()));
    }

    private final void playNote(BlockPos pos, NovaBlockState state) {
        NoteBlockInstrument instrument = (NoteBlockInstrument)state.getOrThrow((BlockStateProperty)DefaultBlockStateProperties.INSTANCE.getNOTE_BLOCK_INSTRUMENT$nova());
        int note = ((Number)state.getOrThrow(DefaultBlockStateProperties.INSTANCE.getNOTE_BLOCK_NOTE$nova())).intValue();
        if (!instrument.worksAboveNoteBlock() && !pos.add(0, 1, 0).getNmsBlockState().isAir()) {
            return;
        }
        NotePlayEvent event = new NotePlayEvent(pos.getBlock(), this.getBukkitInstrument(instrument), new Note(note));
        EventUtilsKt.callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.playSound(pos, instrument, note) && instrument.isTunable()) {
            this.spawnParticle(pos, note);
        }
    }

    private final boolean playSound(BlockPos pos, NoteBlockInstrument instrument, int note) {
        Holder holder2;
        if (instrument == NoteBlockInstrument.CUSTOM_HEAD) {
            BlockEntity blockEntity = NMSUtilsKt.getServerLevel(pos.getWorld()).getBlockEntity(pos.add(0, 1, 0).getNmsPos());
            SkullBlockEntity skullBlockEntity = blockEntity instanceof SkullBlockEntity ? (SkullBlockEntity)blockEntity : null;
            if (skullBlockEntity == null || (skullBlockEntity = skullBlockEntity.noteBlockSound) == null) {
                return false;
            }
            SkullBlockEntity sound = skullBlockEntity;
            Holder holder3 = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)sound));
            Intrinsics.checkNotNull((Object)holder3);
            holder2 = holder3;
        } else {
            Holder holder4 = instrument.getSoundEvent();
            holder2 = holder4;
            Intrinsics.checkNotNullExpressionValue((Object)holder4, (String)"getSoundEvent(...)");
        }
        Holder soundEvent = holder2;
        NMSUtilsKt.getServerLevel(pos.getWorld()).playSeededSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.RECORDS, 3.0f, instrument.isTunable() ? NoteBlockBehaviorKt.access$getPITCH_TABLE$p()[note] : 1.0f, Random.Default.nextLong());
        return true;
    }

    private final void spawnParticle(BlockPos pos, int note) {
        SimpleParticleType simpleParticleType = ParticleTypes.NOTE;
        Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType, (String)"NOTE");
        ParticleType particleType = (ParticleType)simpleParticleType;
        Location location = pos.getBlock().getLocation().add(0.5, 1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        ClientboundLevelParticlesPacket packet = ParticleBuilderKt.particle(particleType, location, arg_0 -> NoteBlockBehavior.spawnParticle$lambda$0(note, arg_0));
        Iterable $this$forEach$iv = FakeEntityManager.INSTANCE.getChunkViewers(pos.getChunkPos());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Packet[] packetArray = new Packet[]{packet};
            NMSUtilsKt.send(it, packetArray);
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockBreak> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (!ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new ItemStack(Material.NOTE_BLOCK));
    }

    @NotNull
    public final NoteBlockInstrument determineInstrument(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NoteBlockInstrument instrument = pos.add(0, 1, 0).getNmsBlockState().instrument();
        if (!instrument.worksAboveNoteBlock() && (instrument = pos.add(0, -1, 0).getNmsBlockState().instrument()).worksAboveNoteBlock()) {
            instrument = NoteBlockInstrument.HARP;
        }
        NoteBlockInstrument noteBlockInstrument = instrument;
        Intrinsics.checkNotNull((Object)noteBlockInstrument);
        return noteBlockInstrument;
    }

    private final Instrument getBukkitInstrument(NoteBlockInstrument $this$bukkitInstrument) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$bukkitInstrument.ordinal()]) {
            case 1 -> Instrument.PIANO;
            case 2 -> Instrument.BASS_DRUM;
            case 3 -> Instrument.SNARE_DRUM;
            case 4 -> Instrument.STICKS;
            case 5 -> Instrument.BASS_GUITAR;
            case 6 -> Instrument.FLUTE;
            case 7 -> Instrument.BELL;
            case 8 -> Instrument.GUITAR;
            case 9 -> Instrument.CHIME;
            case 10 -> Instrument.XYLOPHONE;
            case 11 -> Instrument.IRON_XYLOPHONE;
            case 12 -> Instrument.COW_BELL;
            case 13 -> Instrument.DIDGERIDOO;
            case 14 -> Instrument.BIT;
            case 15 -> Instrument.BANJO;
            case 16 -> Instrument.PLING;
            case 17 -> Instrument.ZOMBIE;
            case 18 -> Instrument.SKELETON;
            case 19 -> Instrument.CREEPER;
            case 20 -> Instrument.DRAGON;
            case 21 -> Instrument.WITHER_SKELETON;
            case 22 -> Instrument.PIGLIN;
            case 23 -> Instrument.CUSTOM_HEAD;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @Nullable
    public ItemStack pickBlockCreative(@NotNull BlockPos pos, @NotNull NovaBlockState state, @NotNull Context<DefaultContextIntentions.BlockInteract> ctx) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return ItemStack.of((Material)Material.NOTE_BLOCK);
    }

    private static final Unit spawnParticle$lambda$0(int $note, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        ParticleBuilderKt.noteColor($this$particle, $note);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NoteBlockInstrument.values().length];
            try {
                nArray[NoteBlockInstrument.HARP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.BASEDRUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.SNARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.HAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.BASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.FLUTE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.BELL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.GUITAR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.CHIME.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.XYLOPHONE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.IRON_XYLOPHONE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.COW_BELL.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.DIDGERIDOO.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.BIT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.BANJO.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.PLING.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.ZOMBIE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.SKELETON.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.CREEPER.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.DRAGON.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.WITHER_SKELETON.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.PIGLIN.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NoteBlockInstrument.CUSTOM_HEAD.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

