/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.limits;

import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.limits.BlockLimiter;
import xyz.xenondevs.nova.world.block.limits.TileEntityLimits;
import xyz.xenondevs.nova.world.block.limits.TileEntityTracker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/world/block/limits/AmountLimiter;", "Lxyz/xenondevs/nova/world/block/limits/BlockLimiter;", "type", "Lxyz/xenondevs/nova/world/block/limits/AmountLimiter$Type;", "limits", "", "Lnet/kyori/adventure/key/Key;", "", "<init>", "(Lxyz/xenondevs/nova/world/block/limits/AmountLimiter$Type;Ljava/util/Map;)V", "deniedSpecific", "Lxyz/xenondevs/nova/world/block/limits/TileEntityLimits$PlaceResult;", "deniedTotal", "canPlace", "material", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "ctx", "Lxyz/xenondevs/nova/context/Context;", "Lxyz/xenondevs/nova/context/intention/DefaultContextIntentions$BlockPlace;", "Type", "nova"})
public final class AmountLimiter
implements BlockLimiter {
    @NotNull
    private final Type type;
    @NotNull
    private final Map<Key, Integer> limits;
    @NotNull
    private final TileEntityLimits.PlaceResult deniedSpecific;
    @NotNull
    private final TileEntityLimits.PlaceResult deniedTotal;

    public AmountLimiter(@NotNull Type type, @NotNull Map<Key, Integer> limits) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(limits, (String)"limits");
        this.type = type;
        this.limits = limits;
        String string = this.type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.deniedSpecific = new TileEntityLimits.PlaceResult(false, "nova.tile_entity_limits.amount_" + string + ".deny");
        String string2 = this.type.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        this.deniedTotal = new TileEntityLimits.PlaceResult(false, "nova.tile_entity_limits.amount_" + string2 + "_total.deny");
    }

    @Override
    @NotNull
    public TileEntityLimits.PlaceResult canPlace(@NotNull NovaBlock material, @NotNull Context<DefaultContextIntentions.BlockPlace> ctx) {
        int amount;
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        Key id = material.getId();
        UUID uUID = ctx.get(DefaultContextParamTypes.INSTANCE.getSOURCE_UUID());
        if (uUID == null) {
            return BlockLimiter.Companion.getALLOWED();
        }
        UUID owner = uUID;
        BlockPos blockPos = ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_POS());
        Intrinsics.checkNotNull((Object)blockPos);
        BlockPos pos = blockPos;
        Integer specificLimit = this.limits.get(id);
        Integer totalLimit = this.limits.get(null);
        if (specificLimit != null) {
            amount = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner, id);
                case 2 -> {
                    UUID v3 = pos.getWorld().getUID();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getUID(...)");
                    yield TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner, v3, id);
                }
                case 3 -> TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner, pos.getChunkPos(), id);
                default -> throw new NoWhenBranchMatchedException();
            };
            if (amount >= specificLimit) {
                return this.deniedSpecific;
            }
        }
        if (totalLimit != null) {
            amount = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner);
                case 2 -> {
                    UUID v5 = pos.getWorld().getUID();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getUID(...)");
                    yield TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner, v5);
                }
                case 3 -> TileEntityTracker.INSTANCE.getBlocksPlacedAmount(owner, pos.getChunkPos());
                default -> throw new NoWhenBranchMatchedException();
            };
            if (amount >= totalLimit) {
                return this.deniedTotal;
            }
        }
        return BlockLimiter.Companion.getALLOWED();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/xenondevs/nova/world/block/limits/AmountLimiter$Type;", "", "<init>", "(Ljava/lang/String;I)V", "GLOBAL", "PER_WORLD", "PER_CHUNK", "nova"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type GLOBAL = new Type();
        public static final /* enum */ Type PER_WORLD = new Type();
        public static final /* enum */ Type PER_CHUNK = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.GLOBAL, Type.PER_WORLD, Type.PER_CHUNK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.PER_WORLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.PER_CHUNK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

