/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.break;

import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.util.BlockFaceUtils;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.EntityUtils;
import xyz.xenondevs.nova.util.EntityUtilsKt;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.util.item.ToolUtils;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.event.BlockBreakActionEvent;
import xyz.xenondevs.nova.world.block.logic.break.BlockBreaking;
import xyz.xenondevs.nova.world.block.logic.break.BreakMethod;
import xyz.xenondevs.nova.world.block.logic.break.NovaBlockBreaker;
import xyz.xenondevs.nova.world.block.logic.break.VanillaBlockBreaker;
import xyz.xenondevs.nova.world.block.logic.sound.SoundEngine;
import xyz.xenondevs.nova.world.block.sound.SoundGroup;
import xyz.xenondevs.nova.world.item.tool.ToolCategory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u0007J\u001f\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020+2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u00020\u001fH\u0002J\b\u00107\u001a\u00020\u001fH\u0002J\b\u00108\u001a\u00020\u0013H$J\b\u00109\u001a\u00020/H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u001e\u0010-\u001a\u00020+2\u0006\u0010&\u001a\u00020+@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010,\u0082\u0001\u0002:;\u00a8\u0006<"}, d2={"Lxyz/xenondevs/nova/world/block/logic/break/BlockBreaker;", "", "player", "Lorg/bukkit/entity/Player;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "startSequence", "", "blockedUntil", "<init>", "(Lorg/bukkit/entity/Player;Lxyz/xenondevs/nova/world/BlockPos;II)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getPos", "()Lxyz/xenondevs/nova/world/BlockPos;", "getStartSequence", "()I", "getBlockedUntil", "breakMethod", "Lxyz/xenondevs/nova/world/block/logic/break/BreakMethod;", "getBreakMethod", "()Lxyz/xenondevs/nova/world/block/logic/break/BreakMethod;", "breakMethod$delegate", "Lkotlin/Lazy;", "block", "Lorg/bukkit/block/Block;", "getBlock", "()Lorg/bukkit/block/Block;", "soundGroup", "Lxyz/xenondevs/nova/world/block/sound/SoundGroup;", "hardness", "", "tool", "Lorg/bukkit/inventory/ItemStack;", "itemToolCategories", "", "Lxyz/xenondevs/nova/world/item/tool/ToolCategory;", "destroyTicks", "value", "progress", "getProgress", "()D", "isDone", "", "()Z", "isStopped", "handleTick", "", "breakBlock", "brokenClientside", "sequence", "stop", "blockBroken", "(ZLjava/lang/Integer;)V", "calculateClientsideDamage", "calculateDamage", "createBreakMethod", "handleBreakTick", "Lxyz/xenondevs/nova/world/block/logic/break/NovaBlockBreaker;", "Lxyz/xenondevs/nova/world/block/logic/break/VanillaBlockBreaker;", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockBreaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBreaker.kt\nxyz/xenondevs/nova/world/block/logic/break/BlockBreaker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public abstract sealed class BlockBreaker
permits NovaBlockBreaker, VanillaBlockBreaker {
    @NotNull
    private final Player player;
    @NotNull
    private final BlockPos pos;
    private final int startSequence;
    private final int blockedUntil;
    @NotNull
    private final Lazy breakMethod$delegate;
    @NotNull
    private final Block block;
    @Nullable
    private final SoundGroup soundGroup;
    private final double hardness;
    @Nullable
    private final ItemStack tool;
    @NotNull
    private final Set<ToolCategory> itemToolCategories;
    private int destroyTicks;
    private double progress;
    private boolean isStopped;

    private BlockBreaker(Player player, BlockPos pos, int startSequence, int blockedUntil) {
        this.player = player;
        this.pos = pos;
        this.startSequence = startSequence;
        this.blockedUntil = blockedUntil;
        this.breakMethod$delegate = LazyKt.lazy(() -> BlockBreaker.breakMethod_delegate$lambda$0(this));
        this.block = this.pos.getBlock();
        Sound sound = this.block.getBlockSoundGroup().getHitSound();
        Intrinsics.checkNotNullExpressionValue((Object)sound, (String)"getHitSound(...)");
        this.soundGroup = SoundEngine.INSTANCE.overridesSound(sound) ? BlockUtilsKt.getNovaSoundGroup(this.block) : null;
        this.hardness = BlockUtilsKt.getHardness(this.block);
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        this.tool = ItemUtilsKt.takeUnlessEmpty(itemStack);
        this.itemToolCategories = ToolCategory.Companion.ofItem(this.tool);
        EventUtilsKt.callEvent((Event)new BlockBreakActionEvent(this.player, this.block, BlockBreakActionEvent.Action.START));
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    public final int getStartSequence() {
        return this.startSequence;
    }

    public final int getBlockedUntil() {
        return this.blockedUntil;
    }

    private final BreakMethod getBreakMethod() {
        Lazy lazy = this.breakMethod$delegate;
        return (BreakMethod)lazy.getValue();
    }

    @NotNull
    protected final Block getBlock() {
        return this.block;
    }

    public final double getProgress() {
        return this.progress;
    }

    private final boolean isDone() {
        return this.progress >= 1.0;
    }

    public final boolean isStopped() {
        return this.isStopped;
    }

    public final void handleTick() {
        ItemStack itemStack;
        if (this.isDone()) {
            return;
        }
        double damage = this.calculateDamage();
        double clientsideDamage = this.calculateClientsideDamage();
        if (clientsideDamage >= 1.0 && damage < 1.0) {
            this.stop(false, this.startSequence);
            return;
        }
        Location location = this.player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        BlockFace blockFace = BlockFaceUtils.determineBlockFaceLookingAt$default(BlockFaceUtils.INSTANCE, location, 0.0, 2, null);
        if (blockFace == null) {
            blockFace = BlockFace.NORTH;
        }
        if ((itemStack = this.tool) == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        BlockDamageEvent damageEvent = new BlockDamageEvent(this.player, this.block, blockFace, itemStack, damage > 1.0);
        EventUtilsKt.callEvent((Event)damageEvent);
        if (damageEvent.isCancelled()) {
            return;
        }
        if (damageEvent.getInstaBreak() && damage < 1.0) {
            damage = 1.0;
        }
        if (damage >= 1.0 || NMSUtilsKt.getServerTick() >= this.blockedUntil) {
            this.progress += damage;
            if (this.progress < 1.0 && this.destroyTicks % 4 == 0 && this.soundGroup != null) {
                this.pos.playSound(this.soundGroup.getHitSound(), SoundCategory.BLOCKS, this.soundGroup.getHitVolume(), this.soundGroup.getHitPitch());
            }
            int n = this.destroyTicks;
            this.destroyTicks = n + 1;
        }
        if (this.isDone() && !this.getBreakMethod().getHasClientsidePrediction()) {
            this.breakBlock(clientsideDamage >= 1.0, this.startSequence);
            if (this.isDone()) {
                BlockBreaker.stop$default(this, true, null, 2, null);
            }
        } else {
            this.handleBreakTick();
            this.getBreakMethod().setBreakStage(this.progress <= 0.0 ? -1 : (int)(RangesKt.coerceAtMost((double)this.progress, (double)1.0) * (double)10));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void breakBlock(boolean brokenClientside, int sequence) {
        ctxBuilder = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), this.pos).param(DefaultContextParamTypes.INSTANCE.getSOURCE_ENTITY(), this.player).param(DefaultContextParamTypes.INSTANCE.getTOOL_ITEM_STACK(), this.tool);
        ctx = ctxBuilder.build();
        v0 = this.block.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getWorld(...)");
        level = NMSUtilsKt.getServerLevel(v0);
        blockPos = this.pos.getNmsPos();
        event = new BlockBreakEvent(this.block, this.player);
        var8_8 = this;
        if (var8_8 instanceof NovaBlockBreaker) {
            v1 = ((NovaBlockBreaker)this).getBlockType().getExp(this.pos, ((NovaBlockBreaker)this).getBlockState(), ctxBuilder.build());
        } else if (var8_8 instanceof VanillaBlockBreaker) {
            if (ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_EXP_DROPS()).booleanValue()) {
                v2 = NMSUtilsKt.unwrap(this.tool).copy();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"copy(...)");
                v1 = BlockUtils.INSTANCE.getVanillaBlockExp$nova(level, blockPos, v2);
            } else {
                v1 = 0;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        event.setExpToDrop(v1);
        EventUtilsKt.callEvent((Event)event);
        ctxBuilder.param(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS(), ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS()) != false && event.isDropItems() != false);
        ctxBuilder.param(DefaultContextParamTypes.INSTANCE.getBLOCK_STORAGE_DROPS(), ctx.get(DefaultContextParamTypes.INSTANCE.getBLOCK_STORAGE_DROPS()) != false && event.isDropItems() != false);
        if (event.isCancelled()) ** GOTO lbl-1000
        v3 = (OfflinePlayer)this.player;
        v4 = this.block.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getLocation(...)");
        if (!ProtectionManager.INSTANCE.isVanillaProtected$nova(v3, v4)) {
            if (level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && (exp = event.getExpToDrop()) > 0) {
                ExperienceOrb.award((ServerLevel)level, (Vec3)Vec3.atCenterOf((Vec3i)((Vec3i)blockPos)), (int)event.getExpToDrop());
            }
            v5 = furnace = (var9_10 = level.getBlockEntity(blockPos)) instanceof AbstractFurnaceBlockEntity != false ? (AbstractFurnaceBlockEntity)var9_10 : null;
            if (furnace != null) {
                var10_12 = new BlockExpEvent(this.block, BlockUtils.INSTANCE.getVanillaFurnaceExp$nova(furnace));
                p0 = (Event)var10_12;
                $i$a$-also-BlockBreaker$breakBlock$exp$1 = false;
                EventUtilsKt.callEvent(p0);
                exp = var10_12.getExpToDrop();
                if (exp > 0) {
                    ExperienceOrb.award((ServerLevel)level, (Vec3)Vec3.atCenterOf((Vec3i)((Vec3i)blockPos)), (int)exp);
                }
            }
            if (this.player.getGameMode() != GameMode.CREATIVE && ((Collection)this.itemToolCategories).isEmpty() == false && this.hardness > 0.0) {
                EntityUtilsKt.damageToolBreakBlock((LivingEntity)this.player);
            }
            v6 = this.block.getState();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getState(...)");
            state = v6;
            items = BlockUtils.INSTANCE.breakBlockInternal$nova(ctxBuilder.build(), brokenClientside == false);
            itemEntities = EntityUtils.INSTANCE.createBlockDropItemEntities(this.pos, (Iterable<? extends ItemStack>)items);
            if (event.isDropItems()) {
                CraftEventFactory.handleBlockDropItemEvent((Block)this.block, (BlockState)state, (ServerPlayer)NMSUtilsKt.getServerPlayer(this.player), itemEntities);
            }
        } else if (!brokenClientside) {
            this.progress = 0.0;
        }
        var8_8 = new Packet[]{new ClientboundBlockChangedAckPacket(sequence)};
        NMSUtilsKt.send(this.player, var8_8);
        BlockBreaking.INSTANCE.setBreakCooldown(this.player);
    }

    public final void stop(boolean blockBroken, @Nullable Integer sequence) {
        this.isStopped = true;
        this.getBreakMethod().stop();
        if (sequence != null) {
            Packet[] packetArray = new Packet[]{new ClientboundBlockChangedAckPacket(sequence.intValue())};
            NMSUtilsKt.send(this.player, packetArray);
        }
        EventUtilsKt.callEvent((Event)new BlockBreakActionEvent(this.player, this.block, blockBroken ? BlockBreakActionEvent.Action.FINISH : BlockBreakActionEvent.Action.CANCEL));
    }

    public static /* synthetic */ void stop$default(BlockBreaker blockBreaker, boolean bl, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        blockBreaker.stop(bl, n);
    }

    private final double calculateClientsideDamage() {
        return this.player.getGameMode() == GameMode.CREATIVE ? 1.0 : 0.0;
    }

    private final double calculateDamage() {
        return ToolUtils.INSTANCE.calculateDamage$nova(this.player, this.block, this.tool);
    }

    @NotNull
    protected abstract BreakMethod createBreakMethod();

    protected abstract void handleBreakTick();

    private static final BreakMethod breakMethod_delegate$lambda$0(BlockBreaker this$0) {
        return this$0.createBreakMethod();
    }

    public /* synthetic */ BlockBreaker(Player player, BlockPos pos, int startSequence, int blockedUntil, DefaultConstructorMarker $constructor_marker) {
        this(player, pos, startSequence, blockedUntil);
    }
}

