/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.break;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.integration.customitems.CustomItemServiceManager;
import xyz.xenondevs.nova.network.PacketHandler;
import xyz.xenondevs.nova.network.PacketManagerKt;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.network.event.clientbound.ClientboundUpdateAttributesPacketEvent;
import xyz.xenondevs.nova.network.event.serverbound.ServerboundPlayerActionPacketEvent;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Breakable;
import xyz.xenondevs.nova.world.block.logic.break.BlockBreaker;
import xyz.xenondevs.nova.world.block.logic.break.BlockBreakingKt;
import xyz.xenondevs.nova.world.block.logic.break.BreakMethod;
import xyz.xenondevs.nova.world.block.logic.break.NovaBlockBreaker;
import xyz.xenondevs.nova.world.block.logic.break.VanillaBlockBreaker;
import xyz.xenondevs.nova.world.block.logic.break.VisibleBreakMethod;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@InternalInit(stage=InternalInitStage.POST_WORLD, dependsOn={WorldDataManager.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0003J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0007J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0010H\u0002J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0003J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010$\u001a\u00020'H\u0003J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010$\u001a\u00020)H\u0003J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010$\u001a\u00020+H\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lxyz/xenondevs/nova/world/block/logic/break/BlockBreaking;", "Lorg/bukkit/event/Listener;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "<init>", "()V", "breakCooldowns", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "", "playerBreakers", "Lxyz/xenondevs/nova/world/block/logic/break/BlockBreaker;", "internalBreakers", "Ljava/util/HashMap;", "Lxyz/xenondevs/nova/world/block/logic/break/VisibleBreakMethod;", "Lkotlin/collections/HashMap;", "init", "", "setBreakStage", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "entityId", "stage", "setBreakCooldown", "player", "getBlockedUntil", "getBreaker", "handleTick", "handleDestroyStart", "packet", "Lnet/minecraft/network/protocol/game/ServerboundPlayerActionPacket;", "direction", "Lnet/minecraft/core/Direction;", "sequence", "handleDestroyAbort", "handleDestroyStop", "handlePlayerAction", "event", "Lxyz/xenondevs/nova/network/event/serverbound/ServerboundPlayerActionPacketEvent;", "handleAttributes", "Lxyz/xenondevs/nova/network/event/clientbound/ClientboundUpdateAttributesPacketEvent;", "handleJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "handleQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockBreaking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBreaking.kt\nxyz/xenondevs/nova/world/block/logic/break/BlockBreaking\n+ 2 Maps.kt\nxyz/xenondevs/commons/collections/MapsKt\n+ 3 NovaBlock.kt\nxyz/xenondevs/nova/world/block/NovaBlock\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n148#2,7:283\n89#3:290\n1563#4:291\n1634#4,3:292\n*S KotlinDebug\n*F\n+ 1 BlockBreaking.kt\nxyz/xenondevs/nova/world/block/logic/break/BlockBreaking\n*L\n126#1:283,7\n186#1:290\n257#1:291\n257#1:292,3\n*E\n"})
public final class BlockBreaking
implements Listener,
PacketListener {
    @NotNull
    public static final BlockBreaking INSTANCE = new BlockBreaking();
    @NotNull
    private static final ConcurrentHashMap<org.bukkit.entity.Player, Integer> breakCooldowns = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<org.bukkit.entity.Player, BlockBreaker> playerBreakers = new ConcurrentHashMap();
    @NotNull
    private static final HashMap<Integer, VisibleBreakMethod> internalBreakers = new HashMap();

    private BlockBreaking() {
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
        PacketListenerKt.registerPacketListener(this);
        SchedulerUtilsKt.runTaskTimer(0L, 1L, (Function0<Unit>)((Function0)new Function0<Unit>((Object)INSTANCE){

            public final void invoke() {
                BlockBreaking.access$handleTick((BlockBreaking)this.receiver);
            }
        }));
    }

    public final void setBreakStage(@NotNull BlockPos pos, int entityId, int stage) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(pos);
        if (novaBlockState == null) {
            return;
        }
        NovaBlockState blockState = novaBlockState;
        Block block = pos.getBlock();
        VisibleBreakMethod method = internalBreakers.get(entityId);
        if (!(0 <= stage ? stage < 10 : false)) {
            VisibleBreakMethod visibleBreakMethod = method;
            if (visibleBreakMethod != null) {
                visibleBreakMethod.stop();
            }
            ((Map)internalBreakers).remove(entityId);
            return;
        }
        if (method != null && !Intrinsics.areEqual((Object)method.getPos(), (Object)pos)) {
            method.stop();
            method = null;
            ((Map)internalBreakers).remove(entityId);
        }
        if (method == null) {
            BreakMethod breakMethod = BreakMethod.Companion.of(block, blockState.getBlock(), entityId);
            VisibleBreakMethod visibleBreakMethod = breakMethod instanceof VisibleBreakMethod ? (VisibleBreakMethod)breakMethod : null;
            if (visibleBreakMethod == null) {
                return;
            }
            method = visibleBreakMethod;
            ((Map)internalBreakers).put(entityId, method);
        }
        method.setBreakStage(stage);
    }

    public final void setBreakCooldown(@NotNull org.bukkit.entity.Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ((Map)breakCooldowns).put(player, NMSUtilsKt.getServerTick() + BlockBreakingKt.access$getBREAK_COOLDOWN() + 1);
    }

    public final int getBlockedUntil(@NotNull org.bukkit.entity.Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int n = NMSUtilsKt.getServerTick() + 1;
        Integer n2 = breakCooldowns.get(player);
        int n3 = (n2 != null ? n2 : 0) + 1;
        return Math.max(n, n3);
    }

    @Nullable
    public final BlockBreaker getBreaker(@NotNull org.bukkit.entity.Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return playerBreakers.get(player);
    }

    private final void handleTick() {
        Map $this$removeIf$iv = playerBreakers;
        boolean $i$f$removeIf = false;
        Iterator iterator$iv = $this$removeIf$iv.entrySet().iterator();
        while (iterator$iv.hasNext()) {
            Map.Entry entry$iv;
            Map.Entry entry = entry$iv = iterator$iv.next();
            boolean bl = false;
            BlockBreaker breaker = (BlockBreaker)entry.getValue();
            try {
                if (!breaker.isStopped()) {
                    breaker.handleTick();
                }
            }
            catch (Exception e) {
                NovaBootstrapperKt.getLOGGER().error("An exception occurred in BlockBreaker tick", (Throwable)e);
            }
            if (!breaker.isStopped()) continue;
            iterator$iv.remove();
        }
    }

    private final void handleDestroyStart(org.bukkit.entity.Player player, ServerboundPlayerActionPacket packet, BlockPos pos, Direction direction, int sequence) {
        if (CustomItemServiceManager.INSTANCE.getBlockType(pos.getBlock()) != null || player.getGameMode() == GameMode.CREATIVE && player.getInventory().getItemInMainHand().getType() == Material.DEBUG_STICK) {
            PacketHandler packetHandler = PacketManagerKt.getPacketHandler(player);
            if (packetHandler != null) {
                packetHandler.injectIncoming(packet);
            }
            return;
        }
        ServerPlayer serverPlayer = NMSUtilsKt.getServerPlayer(player);
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent((Player)((Player)serverPlayer), (Action)Action.LEFT_CLICK_BLOCK, (net.minecraft.core.BlockPos)pos.getNmsPos(), (Direction)direction, (ItemStack)serverPlayer.getInventory().getSelectedItem(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (event.useInteractedBlock() == Event.Result.DENY) {
            Packet[] packetArray = new Packet[]{new ClientboundBlockChangedAckPacket(sequence)};
            NMSUtilsKt.send(player, packetArray);
            return;
        }
        NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(pos);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (novaBlockState != null) {
                Context<ContextIntention> ctx = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), pos).param(DefaultContextParamTypes.INSTANCE.getBLOCK_STATE_NOVA(), novaBlockState).param(DefaultContextParamTypes.INSTANCE.getSOURCE_PLAYER(), player).build();
                novaBlockState.getBlock().handleAttack(pos, novaBlockState, ctx);
            } else {
                ServerLevel serverLevel = NMSUtilsKt.getServerLevel(pos.getWorld());
                net.minecraft.core.BlockPos nmsPos = pos.getNmsPos();
                serverLevel.getBlockState(nmsPos).attack((Level)serverLevel, nmsPos, (Player)NMSUtilsKt.getServerPlayer(player));
            }
        }
        BlockBreaker breaker = null;
        if (novaBlockState != null) {
            NovaBlock this_$iv = novaBlockState.getBlock();
            boolean $i$f$hasBehavior = false;
            if (!this_$iv.hasBehavior(Reflection.getOrCreateKotlinClass(Breakable.class))) {
                Packet[] packetArray = new Packet[]{new ClientboundBlockChangedAckPacket(sequence)};
                NMSUtilsKt.send(player, packetArray);
                return;
            }
            breaker = new NovaBlockBreaker(player, pos, novaBlockState, sequence, this.getBlockedUntil(player));
        } else {
            breaker = new VanillaBlockBreaker(player, pos, sequence, this.getBlockedUntil(player));
        }
        if (player.getGameMode() != GameMode.CREATIVE) {
            ((Map)playerBreakers).put(player, breaker);
        }
        breaker.handleTick();
    }

    private final void handleDestroyAbort(org.bukkit.entity.Player player, ServerboundPlayerActionPacket packet) {
        block1: {
            block0: {
                BlockBreaker breaker = playerBreakers.remove(player);
                if (breaker == null) break block0;
                breaker.stop(false, packet.getSequence());
                break block1;
            }
            PacketHandler packetHandler = PacketManagerKt.getPacketHandler(player);
            if (packetHandler == null) break block1;
            packetHandler.injectIncoming(packet);
        }
    }

    private final void handleDestroyStop(org.bukkit.entity.Player player, ServerboundPlayerActionPacket packet) {
        block1: {
            block0: {
                BlockBreaker breaker = playerBreakers.remove(player);
                if (breaker == null) break block0;
                breaker.breakBlock(true, packet.getSequence());
                BlockBreaker.stop$default(breaker, true, null, 2, null);
                break block1;
            }
            PacketHandler packetHandler = PacketManagerKt.getPacketHandler(player);
            if (packetHandler == null) break block1;
            packetHandler.injectIncoming(packet);
        }
    }

    @xyz.xenondevs.nova.network.event.PacketHandler
    private final void handlePlayerAction(ServerboundPlayerActionPacketEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        net.minecraft.core.BlockPos blockPos = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"<get-pos>(...)");
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        BlockPos pos = NMSUtilsKt.toNovaPos(blockPos, world);
        ServerboundPlayerActionPacket.Action action = event.getAction();
        event.setCancelled(switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1 -> {
                SchedulerUtilsKt.runTask((Function0<Unit>)((Function0)() -> BlockBreaking.handlePlayerAction$lambda$0(player, event, pos)));
                yield true;
            }
            case 2 -> {
                SchedulerUtilsKt.runTask((Function0<Unit>)((Function0)() -> BlockBreaking.handlePlayerAction$lambda$1(player, event)));
                yield true;
            }
            case 3 -> {
                SchedulerUtilsKt.runTask((Function0<Unit>)((Function0)() -> BlockBreaking.handlePlayerAction$lambda$2(player, event)));
                yield true;
            }
            default -> false;
        });
    }

    /*
     * WARNING - void declaration
     */
    @xyz.xenondevs.nova.network.event.PacketHandler
    private final void handleAttributes(ClientboundUpdateAttributesPacketEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (event.getPlayer().getEntityId() != event.getEntityId()) {
            return;
        }
        Iterable iterable = event.getValues();
        ClientboundUpdateAttributesPacketEvent clientboundUpdateAttributesPacketEvent = event;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClientboundUpdateAttributesPacket.AttributeSnapshot attributeSnapshot = (ClientboundUpdateAttributesPacket.AttributeSnapshot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.areEqual((Object)it.attribute().value(), (Object)Attributes.BLOCK_BREAK_SPEED.value()) ? new ClientboundUpdateAttributesPacket.AttributeSnapshot(it.attribute(), 0.0, (Collection)CollectionsKt.emptyList()) : it);
        }
        clientboundUpdateAttributesPacketEvent.setValues((List)destination$iv$iv);
    }

    @EventHandler
    private final void handleJoin(PlayerJoinEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        org.bukkit.entity.Player player2 = player;
        List attributes = CollectionsKt.listOf((Object)new ClientboundUpdateAttributesPacket.AttributeSnapshot(Attributes.BLOCK_BREAK_SPEED, 0.0, (Collection)CollectionsKt.emptyList()));
        ClientboundUpdateAttributesPacket packet = new ClientboundUpdateAttributesPacket(player2.getEntityId(), attributes);
        Packet[] packetArray = new Packet[]{packet};
        NMSUtilsKt.send(player2, packetArray);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private final void handleQuit(PlayerQuitEvent event) {
        block0: {
            org.bukkit.entity.Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            org.bukkit.entity.Player player2 = player;
            ((Map)breakCooldowns).remove(player2);
            BlockBreaker blockBreaker = playerBreakers.remove(player2);
            if (blockBreaker == null) break block0;
            BlockBreaker.stop$default(blockBreaker, false, null, 2, null);
        }
    }

    private static final Unit handlePlayerAction$lambda$0(org.bukkit.entity.Player $player, ServerboundPlayerActionPacketEvent $event, BlockPos $pos) {
        ServerboundPlayerActionPacket serverboundPlayerActionPacket = (ServerboundPlayerActionPacket)$event.getPacket();
        Direction direction = $event.getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"<get-direction>(...)");
        INSTANCE.handleDestroyStart($player, serverboundPlayerActionPacket, $pos, direction, $event.getSequence());
        return Unit.INSTANCE;
    }

    private static final Unit handlePlayerAction$lambda$1(org.bukkit.entity.Player $player, ServerboundPlayerActionPacketEvent $event) {
        INSTANCE.handleDestroyAbort($player, (ServerboundPlayerActionPacket)$event.getPacket());
        return Unit.INSTANCE;
    }

    private static final Unit handlePlayerAction$lambda$2(org.bukkit.entity.Player $player, ServerboundPlayerActionPacketEvent $event) {
        INSTANCE.handleDestroyStop($player, (ServerboundPlayerActionPacket)$event.getPacket());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleTick(BlockBreaking $this) {
        $this.handleTick();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerboundPlayerActionPacket.Action.values().length];
            try {
                nArray[ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

