/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.break;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.BlockFaceUtils;
import xyz.xenondevs.nova.util.BlockFaceUtilsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Breakable;
import xyz.xenondevs.nova.world.block.logic.break.BlockBreaker;
import xyz.xenondevs.nova.world.block.logic.break.BreakMethod;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxyz/xenondevs/nova/world/block/logic/break/NovaBlockBreaker;", "Lxyz/xenondevs/nova/world/block/logic/break/BlockBreaker;", "player", "Lorg/bukkit/entity/Player;", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "blockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "sequence", "", "blockedUntil", "<init>", "(Lorg/bukkit/entity/Player;Lxyz/xenondevs/nova/world/BlockPos;Lxyz/xenondevs/nova/world/block/state/NovaBlockState;II)V", "getBlockState", "()Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "blockType", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "getBlockType", "()Lxyz/xenondevs/nova/world/block/NovaBlock;", "breakable", "Lxyz/xenondevs/nova/world/block/behavior/Breakable;", "createBreakMethod", "Lxyz/xenondevs/nova/world/block/logic/break/BreakMethod;", "handleBreakTick", "", "spawnHitParticles", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockBreaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBreaker.kt\nxyz/xenondevs/nova/world/block/logic/break/NovaBlockBreaker\n+ 2 NovaBlock.kt\nxyz/xenondevs/nova/world/block/NovaBlock\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n127#2:280\n1869#3,2:281\n*S KotlinDebug\n*F\n+ 1 BlockBreaker.kt\nxyz/xenondevs/nova/world/block/logic/break/NovaBlockBreaker\n*L\n59#1:280\n75#1:281,2\n*E\n"})
public final class NovaBlockBreaker
extends BlockBreaker {
    @NotNull
    private final NovaBlockState blockState;
    @NotNull
    private final NovaBlock blockType;
    @NotNull
    private final Breakable breakable;

    public NovaBlockBreaker(@NotNull Player player, @NotNull BlockPos pos, @NotNull NovaBlockState blockState, int sequence, int blockedUntil) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(player, pos, sequence, blockedUntil, null);
        this.blockState = blockState;
        NovaBlock this_$iv = this.blockType = this.blockState.getBlock();
        boolean $i$f$getBehavior = false;
        this.breakable = (Breakable)this_$iv.getBehavior(Reflection.getOrCreateKotlinClass(Breakable.class));
    }

    @NotNull
    public final NovaBlockState getBlockState() {
        return this.blockState;
    }

    @NotNull
    public final NovaBlock getBlockType() {
        return this.blockType;
    }

    @Override
    @NotNull
    protected BreakMethod createBreakMethod() {
        return BreakMethod.Companion.of$default(BreakMethod.Companion, this.getBlock(), this.blockType, null, 0, 8, null);
    }

    @Override
    protected void handleBreakTick() {
        if (this.getBlock().getType() == Material.BARRIER) {
            this.spawnHitParticles();
        }
    }

    private final void spawnHitParticles() {
        Material material = this.breakable.getBreakParticles();
        if (material == null) {
            return;
        }
        Material texture = material;
        Location location = this.getPlayer().getEyeLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getEyeLocation(...)");
        BlockFace blockFace = BlockFaceUtils.determineBlockFaceLookingAt$default(BlockFaceUtils.INSTANCE, location, 0.0, 2, null);
        if (blockFace == null) {
            blockFace = BlockFace.UP;
        }
        BlockFace side = blockFace;
        ParticleType particleType = ParticleTypes.ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"ITEM");
        Location location2 = this.getBlock().getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
        ClientboundLevelParticlesPacket particlePacket = ParticleBuilderKt.particle(particleType, LocationUtilsKt.advance(location2, side, 0.6), arg_0 -> NovaBlockBreaker.spawnHitParticles$lambda$0(texture, side, arg_0));
        Packet[] packetArray = new Packet[]{particlePacket};
        NMSUtilsKt.send(this.getPlayer(), packetArray);
    }

    private static final Unit spawnHitParticles$lambda$0(Material $texture, BlockFace $side, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Axis it = (Axis)element$iv;
            boolean bl = false;
            if (it == BlockFaceUtilsKt.getAxis($side)) continue;
            $this$particle.offset(it, 0.2);
        }
        $this$particle.amount(1);
        $this$particle.speed(0.0f);
        ParticleBuilderKt.item((ParticleBuilder<ItemParticleOption>)$this$particle, $texture);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Axis> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Axis.values()));
        }
    }
}

