/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.sound;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.level.block.SoundType;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.BlockUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u0010*\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00100\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00101\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u00102\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00102\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\u000e\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00103\u001a\u00020+2\u0006\u0010.\u001a\u00020/J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\u0006H\u00c6\u0003J\t\u00108\u001a\u00020\u0006H\u00c6\u0003J\t\u00109\u001a\u00020\u0006H\u00c6\u0003J\t\u0010:\u001a\u00020\u0006H\u00c6\u0003JO\u0010;\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\t\u0010A\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u0011\u0010\u001e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000eR\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0011\u0010&\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0011\u0010(\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000e\u00a8\u0006C"}, d2={"Lxyz/xenondevs/nova/world/block/sound/SoundGroup;", "", "volume", "", "pitch", "breakSound", "", "stepSound", "placeSound", "hitSound", "fallSound", "<init>", "(FFLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getVolume", "()F", "getPitch", "getBreakSound", "()Ljava/lang/String;", "getStepSound", "getPlaceSound", "getHitSound", "getFallSound", "breakVolume", "getBreakVolume", "breakPitch", "getBreakPitch", "stepVolume", "getStepVolume", "stepPitch", "getStepPitch", "placeVolume", "getPlaceVolume", "placePitch", "getPlacePitch", "hitVolume", "getHitVolume", "hitPitch", "getHitPitch", "fallVolume", "getFallVolume", "fallPitch", "getFallPitch", "playBreakSound", "", "block", "Lorg/bukkit/block/Block;", "location", "Lorg/bukkit/Location;", "playStepSound", "playPlaceSound", "playHitSound", "playFallSound", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "nova"})
public final class SoundGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float volume;
    private final float pitch;
    @NotNull
    private final String breakSound;
    @NotNull
    private final String stepSound;
    @NotNull
    private final String placeSound;
    @NotNull
    private final String hitSound;
    @NotNull
    private final String fallSound;
    @NotNull
    private static final SoundGroup WOOD;
    @NotNull
    private static final SoundGroup GRAVEL;
    @NotNull
    private static final SoundGroup GRASS;
    @NotNull
    private static final SoundGroup LILY_PAD;
    @NotNull
    private static final SoundGroup STONE;
    @NotNull
    private static final SoundGroup METAL;
    @NotNull
    private static final SoundGroup GLASS;
    @NotNull
    private static final SoundGroup WOOL;
    @NotNull
    private static final SoundGroup SAND;
    @NotNull
    private static final SoundGroup SNOW;
    @NotNull
    private static final SoundGroup POWDER_SNOW;
    @NotNull
    private static final SoundGroup LADDER;
    @NotNull
    private static final SoundGroup ANVIL;
    @NotNull
    private static final SoundGroup SLIME_BLOCK;
    @NotNull
    private static final SoundGroup HONEY_BLOCK;
    @NotNull
    private static final SoundGroup WET_GRASS;
    @NotNull
    private static final SoundGroup CORAL_BLOCK;
    @NotNull
    private static final SoundGroup BAMBOO;
    @NotNull
    private static final SoundGroup BAMBOO_SAPLING;
    @NotNull
    private static final SoundGroup SCAFFOLDING;
    @NotNull
    private static final SoundGroup SWEET_BERRY_BUSH;
    @NotNull
    private static final SoundGroup CROP;
    @NotNull
    private static final SoundGroup HARD_CROP;
    @NotNull
    private static final SoundGroup VINE;
    @NotNull
    private static final SoundGroup NETHER_WART;
    @NotNull
    private static final SoundGroup LANTERN;
    @NotNull
    private static final SoundGroup STEM;
    @NotNull
    private static final SoundGroup NYLIUM;
    @NotNull
    private static final SoundGroup FUNGUS;
    @NotNull
    private static final SoundGroup ROOTS;
    @NotNull
    private static final SoundGroup SHROOMLIGHT;
    @NotNull
    private static final SoundGroup WEEPING_VINES;
    @NotNull
    private static final SoundGroup TWISTING_VINES;
    @NotNull
    private static final SoundGroup SOUL_SAND;
    @NotNull
    private static final SoundGroup SOUL_SOIL;
    @NotNull
    private static final SoundGroup BASALT;
    @NotNull
    private static final SoundGroup WART_BLOCK;
    @NotNull
    private static final SoundGroup NETHERRACK;
    @NotNull
    private static final SoundGroup NETHER_BRICKS;
    @NotNull
    private static final SoundGroup NETHER_SPROUTS;
    @NotNull
    private static final SoundGroup NETHER_ORE;
    @NotNull
    private static final SoundGroup BONE_BLOCK;
    @NotNull
    private static final SoundGroup NETHERITE_BLOCK;
    @NotNull
    private static final SoundGroup ANCIENT_DEBRIS;
    @NotNull
    private static final SoundGroup LODESTONE;
    @NotNull
    private static final SoundGroup CHAIN;
    @NotNull
    private static final SoundGroup NETHER_GOLD_ORE;
    @NotNull
    private static final SoundGroup GILDED_BLACKSTONE;
    @NotNull
    private static final SoundGroup CANDLE;
    @NotNull
    private static final SoundGroup AMETHYST;
    @NotNull
    private static final SoundGroup AMETHYST_CLUSTER;
    @NotNull
    private static final SoundGroup SMALL_AMETHYST_BUD;
    @NotNull
    private static final SoundGroup MEDIUM_AMETHYST_BUD;
    @NotNull
    private static final SoundGroup LARGE_AMETHYST_BUD;
    @NotNull
    private static final SoundGroup TUFF;
    @NotNull
    private static final SoundGroup CALCITE;
    @NotNull
    private static final SoundGroup DRIPSTONE_BLOCK;
    @NotNull
    private static final SoundGroup POINTED_DRIPSTONE;
    @NotNull
    private static final SoundGroup COPPER;
    @NotNull
    private static final SoundGroup CAVE_VINES;
    @NotNull
    private static final SoundGroup SPORE_BLOSSOM;
    @NotNull
    private static final SoundGroup AZALEA;
    @NotNull
    private static final SoundGroup FLOWERING_AZALEA;
    @NotNull
    private static final SoundGroup MOSS_CARPET;
    @NotNull
    private static final SoundGroup MOSS;
    @NotNull
    private static final SoundGroup BIG_DRIPLEAF;
    @NotNull
    private static final SoundGroup SMALL_DRIPLEAF;
    @NotNull
    private static final SoundGroup ROOTED_DIRT;
    @NotNull
    private static final SoundGroup HANGING_ROOTS;
    @NotNull
    private static final SoundGroup AZALEA_LEAVES;
    @NotNull
    private static final SoundGroup SCULK_SENSOR;
    @NotNull
    private static final SoundGroup SCULK_CATALYST;
    @NotNull
    private static final SoundGroup SCULK;
    @NotNull
    private static final SoundGroup SCULK_VEIN;
    @NotNull
    private static final SoundGroup SCULK_SHRIEKER;
    @NotNull
    private static final SoundGroup GLOW_LICHEN;
    @NotNull
    private static final SoundGroup DEEPSLATE;
    @NotNull
    private static final SoundGroup DEEPSLATE_BRICKS;
    @NotNull
    private static final SoundGroup DEEPSLATE_TILES;
    @NotNull
    private static final SoundGroup POLISHED_DEEPSLATE;
    @NotNull
    private static final SoundGroup FROGLIGHT;
    @NotNull
    private static final SoundGroup FROGSPAWN;
    @NotNull
    private static final SoundGroup MANGROVE_ROOTS;
    @NotNull
    private static final SoundGroup MUDDY_MANGROVE_ROOTS;
    @NotNull
    private static final SoundGroup MUD;
    @NotNull
    private static final SoundGroup MUD_BRICKS;
    @NotNull
    private static final SoundGroup PACKED_MUD;
    @NotNull
    private static final SoundGroup BAMBOO_WOOD;
    @NotNull
    private static final SoundGroup BAMBOO_WOOD_HANGING_SIGN;
    @NotNull
    private static final SoundGroup CHERRY_LEAVES;
    @NotNull
    private static final SoundGroup CHERRY_SAPLING;
    @NotNull
    private static final SoundGroup CHERRY_WOOD;
    @NotNull
    private static final SoundGroup CHERRY_WOOD_HANGING_SIGN;
    @NotNull
    private static final SoundGroup CHISELED_BOOKSHELF;
    @NotNull
    private static final SoundGroup COBWEB;
    @NotNull
    private static final SoundGroup COPPER_BULB;
    @NotNull
    private static final SoundGroup COPPER_GRATE;
    @NotNull
    private static final SoundGroup DECORATED_POT;
    @NotNull
    private static final SoundGroup DECORATED_POT_CRACKED;
    @NotNull
    private static final SoundGroup HANGING_SIGN;
    @NotNull
    private static final SoundGroup HEAVY_CORE;
    @NotNull
    private static final SoundGroup NETHER_WOOD;
    @NotNull
    private static final SoundGroup NETHER_WOOD_HANGING_SIGN;
    @NotNull
    private static final SoundGroup PINK_PETALS;
    @NotNull
    private static final SoundGroup POLISHED_TUFF;
    @NotNull
    private static final SoundGroup SPONGE;
    @NotNull
    private static final SoundGroup SUSPICIOUS_GRAVEL;
    @NotNull
    private static final SoundGroup SUSPICIOUS_SAND;
    @NotNull
    private static final SoundGroup TRIAL_SPAWNER;
    @NotNull
    private static final SoundGroup TUFF_BRICKS;
    @NotNull
    private static final SoundGroup VAULT;
    @NotNull
    private static final SoundGroup WET_SPONGE;

    public SoundGroup(float volume, float pitch, @NotNull String breakSound, @NotNull String stepSound, @NotNull String placeSound, @NotNull String hitSound, @NotNull String fallSound) {
        Intrinsics.checkNotNullParameter((Object)breakSound, (String)"breakSound");
        Intrinsics.checkNotNullParameter((Object)stepSound, (String)"stepSound");
        Intrinsics.checkNotNullParameter((Object)placeSound, (String)"placeSound");
        Intrinsics.checkNotNullParameter((Object)hitSound, (String)"hitSound");
        Intrinsics.checkNotNullParameter((Object)fallSound, (String)"fallSound");
        this.volume = volume;
        this.pitch = pitch;
        this.breakSound = breakSound;
        this.stepSound = stepSound;
        this.placeSound = placeSound;
        this.hitSound = hitSound;
        this.fallSound = fallSound;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final float getPitch() {
        return this.pitch;
    }

    @NotNull
    public final String getBreakSound() {
        return this.breakSound;
    }

    @NotNull
    public final String getStepSound() {
        return this.stepSound;
    }

    @NotNull
    public final String getPlaceSound() {
        return this.placeSound;
    }

    @NotNull
    public final String getHitSound() {
        return this.hitSound;
    }

    @NotNull
    public final String getFallSound() {
        return this.fallSound;
    }

    public final float getBreakVolume() {
        return (this.volume + 1.0f) / 2.0f;
    }

    public final float getBreakPitch() {
        return this.pitch * 0.8f;
    }

    public final float getStepVolume() {
        return this.volume * 0.15f;
    }

    public final float getStepPitch() {
        return this.pitch;
    }

    public final float getPlaceVolume() {
        return (this.volume + 1.0f) / 2.0f;
    }

    public final float getPlacePitch() {
        return this.pitch * 0.8f;
    }

    public final float getHitVolume() {
        return (this.volume + 1.0f) / 8.0f;
    }

    public final float getHitPitch() {
        return this.pitch * 0.5f;
    }

    public final float getFallVolume() {
        return this.volume * 0.5f;
    }

    public final float getFallPitch() {
        return this.pitch * 0.75f;
    }

    public final void playBreakSound(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playBreakSound(BlockUtilsKt.getCenter(block));
    }

    public final void playBreakSound(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playSound(location, this.breakSound, SoundCategory.BLOCKS, this.getBreakVolume(), this.getBreakPitch());
    }

    public final void playStepSound(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playStepSound(BlockUtilsKt.getCenter(block));
    }

    public final void playStepSound(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playSound(location, this.stepSound, SoundCategory.BLOCKS, this.getStepVolume(), this.getStepPitch());
    }

    public final void playPlaceSound(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playPlaceSound(BlockUtilsKt.getCenter(block));
    }

    public final void playPlaceSound(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playSound(location, this.placeSound, SoundCategory.BLOCKS, this.getPlaceVolume(), this.getPlacePitch());
    }

    public final void playHitSound(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playHitSound(BlockUtilsKt.getCenter(block));
    }

    public final void playHitSound(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playSound(location, this.hitSound, SoundCategory.BLOCKS, this.getHitVolume(), this.getHitPitch());
    }

    public final void playFallSound(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playFallSound(BlockUtilsKt.getCenter(block));
    }

    public final void playFallSound(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        world.playSound(location, this.fallSound, SoundCategory.BLOCKS, this.getFallVolume(), this.getFallPitch());
    }

    public final float component1() {
        return this.volume;
    }

    public final float component2() {
        return this.pitch;
    }

    @NotNull
    public final String component3() {
        return this.breakSound;
    }

    @NotNull
    public final String component4() {
        return this.stepSound;
    }

    @NotNull
    public final String component5() {
        return this.placeSound;
    }

    @NotNull
    public final String component6() {
        return this.hitSound;
    }

    @NotNull
    public final String component7() {
        return this.fallSound;
    }

    @NotNull
    public final SoundGroup copy(float volume, float pitch, @NotNull String breakSound, @NotNull String stepSound, @NotNull String placeSound, @NotNull String hitSound, @NotNull String fallSound) {
        Intrinsics.checkNotNullParameter((Object)breakSound, (String)"breakSound");
        Intrinsics.checkNotNullParameter((Object)stepSound, (String)"stepSound");
        Intrinsics.checkNotNullParameter((Object)placeSound, (String)"placeSound");
        Intrinsics.checkNotNullParameter((Object)hitSound, (String)"hitSound");
        Intrinsics.checkNotNullParameter((Object)fallSound, (String)"fallSound");
        return new SoundGroup(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
    }

    public static /* synthetic */ SoundGroup copy$default(SoundGroup soundGroup, float f, float f2, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            f = soundGroup.volume;
        }
        if ((n & 2) != 0) {
            f2 = soundGroup.pitch;
        }
        if ((n & 4) != 0) {
            string = soundGroup.breakSound;
        }
        if ((n & 8) != 0) {
            string2 = soundGroup.stepSound;
        }
        if ((n & 0x10) != 0) {
            string3 = soundGroup.placeSound;
        }
        if ((n & 0x20) != 0) {
            string4 = soundGroup.hitSound;
        }
        if ((n & 0x40) != 0) {
            string5 = soundGroup.fallSound;
        }
        return soundGroup.copy(f, f2, string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "SoundGroup(volume=" + this.volume + ", pitch=" + this.pitch + ", breakSound=" + this.breakSound + ", stepSound=" + this.stepSound + ", placeSound=" + this.placeSound + ", hitSound=" + this.hitSound + ", fallSound=" + this.fallSound + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.volume);
        result = result * 31 + Float.hashCode(this.pitch);
        result = result * 31 + this.breakSound.hashCode();
        result = result * 31 + this.stepSound.hashCode();
        result = result * 31 + this.placeSound.hashCode();
        result = result * 31 + this.hitSound.hashCode();
        result = result * 31 + this.fallSound.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoundGroup)) {
            return false;
        }
        SoundGroup soundGroup = (SoundGroup)other;
        if (Float.compare(this.volume, soundGroup.volume) != 0) {
            return false;
        }
        if (Float.compare(this.pitch, soundGroup.pitch) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.breakSound, (Object)soundGroup.breakSound)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stepSound, (Object)soundGroup.stepSound)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.placeSound, (Object)soundGroup.placeSound)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hitSound, (Object)soundGroup.hitSound)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fallSound, (Object)soundGroup.fallSound);
    }

    static {
        SoundType soundType = SoundType.WOOD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"WOOD");
        WOOD = Companion.from(soundType);
        SoundType soundType2 = SoundType.GRAVEL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType2, (String)"GRAVEL");
        GRAVEL = Companion.from(soundType2);
        SoundType soundType3 = SoundType.GRASS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType3, (String)"GRASS");
        GRASS = Companion.from(soundType3);
        SoundType soundType4 = SoundType.LILY_PAD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType4, (String)"LILY_PAD");
        LILY_PAD = Companion.from(soundType4);
        SoundType soundType5 = SoundType.STONE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType5, (String)"STONE");
        STONE = Companion.from(soundType5);
        SoundType soundType6 = SoundType.METAL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType6, (String)"METAL");
        METAL = Companion.from(soundType6);
        SoundType soundType7 = SoundType.GLASS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType7, (String)"GLASS");
        GLASS = Companion.from(soundType7);
        SoundType soundType8 = SoundType.WOOL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType8, (String)"WOOL");
        WOOL = Companion.from(soundType8);
        SoundType soundType9 = SoundType.SAND;
        Intrinsics.checkNotNullExpressionValue((Object)soundType9, (String)"SAND");
        SAND = Companion.from(soundType9);
        SoundType soundType10 = SoundType.SNOW;
        Intrinsics.checkNotNullExpressionValue((Object)soundType10, (String)"SNOW");
        SNOW = Companion.from(soundType10);
        SoundType soundType11 = SoundType.POWDER_SNOW;
        Intrinsics.checkNotNullExpressionValue((Object)soundType11, (String)"POWDER_SNOW");
        POWDER_SNOW = Companion.from(soundType11);
        SoundType soundType12 = SoundType.LADDER;
        Intrinsics.checkNotNullExpressionValue((Object)soundType12, (String)"LADDER");
        LADDER = Companion.from(soundType12);
        SoundType soundType13 = SoundType.ANVIL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType13, (String)"ANVIL");
        ANVIL = Companion.from(soundType13);
        SoundType soundType14 = SoundType.SLIME_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType14, (String)"SLIME_BLOCK");
        SLIME_BLOCK = Companion.from(soundType14);
        SoundType soundType15 = SoundType.HONEY_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType15, (String)"HONEY_BLOCK");
        HONEY_BLOCK = Companion.from(soundType15);
        SoundType soundType16 = SoundType.WET_GRASS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType16, (String)"WET_GRASS");
        WET_GRASS = Companion.from(soundType16);
        SoundType soundType17 = SoundType.CORAL_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType17, (String)"CORAL_BLOCK");
        CORAL_BLOCK = Companion.from(soundType17);
        SoundType soundType18 = SoundType.BAMBOO;
        Intrinsics.checkNotNullExpressionValue((Object)soundType18, (String)"BAMBOO");
        BAMBOO = Companion.from(soundType18);
        SoundType soundType19 = SoundType.BAMBOO_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)soundType19, (String)"BAMBOO_SAPLING");
        BAMBOO_SAPLING = Companion.from(soundType19);
        SoundType soundType20 = SoundType.SCAFFOLDING;
        Intrinsics.checkNotNullExpressionValue((Object)soundType20, (String)"SCAFFOLDING");
        SCAFFOLDING = Companion.from(soundType20);
        SoundType soundType21 = SoundType.SWEET_BERRY_BUSH;
        Intrinsics.checkNotNullExpressionValue((Object)soundType21, (String)"SWEET_BERRY_BUSH");
        SWEET_BERRY_BUSH = Companion.from(soundType21);
        SoundType soundType22 = SoundType.CROP;
        Intrinsics.checkNotNullExpressionValue((Object)soundType22, (String)"CROP");
        CROP = Companion.from(soundType22);
        SoundType soundType23 = SoundType.HARD_CROP;
        Intrinsics.checkNotNullExpressionValue((Object)soundType23, (String)"HARD_CROP");
        HARD_CROP = Companion.from(soundType23);
        SoundType soundType24 = SoundType.VINE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType24, (String)"VINE");
        VINE = Companion.from(soundType24);
        SoundType soundType25 = SoundType.NETHER_WART;
        Intrinsics.checkNotNullExpressionValue((Object)soundType25, (String)"NETHER_WART");
        NETHER_WART = Companion.from(soundType25);
        SoundType soundType26 = SoundType.LANTERN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType26, (String)"LANTERN");
        LANTERN = Companion.from(soundType26);
        SoundType soundType27 = SoundType.STEM;
        Intrinsics.checkNotNullExpressionValue((Object)soundType27, (String)"STEM");
        STEM = Companion.from(soundType27);
        SoundType soundType28 = SoundType.NYLIUM;
        Intrinsics.checkNotNullExpressionValue((Object)soundType28, (String)"NYLIUM");
        NYLIUM = Companion.from(soundType28);
        SoundType soundType29 = SoundType.FUNGUS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType29, (String)"FUNGUS");
        FUNGUS = Companion.from(soundType29);
        SoundType soundType30 = SoundType.ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType30, (String)"ROOTS");
        ROOTS = Companion.from(soundType30);
        SoundType soundType31 = SoundType.SHROOMLIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType31, (String)"SHROOMLIGHT");
        SHROOMLIGHT = Companion.from(soundType31);
        SoundType soundType32 = SoundType.WEEPING_VINES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType32, (String)"WEEPING_VINES");
        WEEPING_VINES = Companion.from(soundType32);
        SoundType soundType33 = SoundType.TWISTING_VINES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType33, (String)"TWISTING_VINES");
        TWISTING_VINES = Companion.from(soundType33);
        SoundType soundType34 = SoundType.SOUL_SAND;
        Intrinsics.checkNotNullExpressionValue((Object)soundType34, (String)"SOUL_SAND");
        SOUL_SAND = Companion.from(soundType34);
        SoundType soundType35 = SoundType.SOUL_SOIL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType35, (String)"SOUL_SOIL");
        SOUL_SOIL = Companion.from(soundType35);
        SoundType soundType36 = SoundType.BASALT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType36, (String)"BASALT");
        BASALT = Companion.from(soundType36);
        SoundType soundType37 = SoundType.WART_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType37, (String)"WART_BLOCK");
        WART_BLOCK = Companion.from(soundType37);
        SoundType soundType38 = SoundType.NETHERRACK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType38, (String)"NETHERRACK");
        NETHERRACK = Companion.from(soundType38);
        SoundType soundType39 = SoundType.NETHER_BRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType39, (String)"NETHER_BRICKS");
        NETHER_BRICKS = Companion.from(soundType39);
        SoundType soundType40 = SoundType.NETHER_SPROUTS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType40, (String)"NETHER_SPROUTS");
        NETHER_SPROUTS = Companion.from(soundType40);
        SoundType soundType41 = SoundType.NETHER_ORE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType41, (String)"NETHER_ORE");
        NETHER_ORE = Companion.from(soundType41);
        SoundType soundType42 = SoundType.BONE_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType42, (String)"BONE_BLOCK");
        BONE_BLOCK = Companion.from(soundType42);
        SoundType soundType43 = SoundType.NETHERITE_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType43, (String)"NETHERITE_BLOCK");
        NETHERITE_BLOCK = Companion.from(soundType43);
        SoundType soundType44 = SoundType.ANCIENT_DEBRIS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType44, (String)"ANCIENT_DEBRIS");
        ANCIENT_DEBRIS = Companion.from(soundType44);
        SoundType soundType45 = SoundType.LODESTONE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType45, (String)"LODESTONE");
        LODESTONE = Companion.from(soundType45);
        SoundType soundType46 = SoundType.CHAIN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType46, (String)"CHAIN");
        CHAIN = Companion.from(soundType46);
        SoundType soundType47 = SoundType.NETHER_GOLD_ORE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType47, (String)"NETHER_GOLD_ORE");
        NETHER_GOLD_ORE = Companion.from(soundType47);
        SoundType soundType48 = SoundType.GILDED_BLACKSTONE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType48, (String)"GILDED_BLACKSTONE");
        GILDED_BLACKSTONE = Companion.from(soundType48);
        SoundType soundType49 = SoundType.CANDLE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType49, (String)"CANDLE");
        CANDLE = Companion.from(soundType49);
        SoundType soundType50 = SoundType.AMETHYST;
        Intrinsics.checkNotNullExpressionValue((Object)soundType50, (String)"AMETHYST");
        AMETHYST = Companion.from(soundType50);
        SoundType soundType51 = SoundType.AMETHYST_CLUSTER;
        Intrinsics.checkNotNullExpressionValue((Object)soundType51, (String)"AMETHYST_CLUSTER");
        AMETHYST_CLUSTER = Companion.from(soundType51);
        SoundType soundType52 = SoundType.SMALL_AMETHYST_BUD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType52, (String)"SMALL_AMETHYST_BUD");
        SMALL_AMETHYST_BUD = Companion.from(soundType52);
        SoundType soundType53 = SoundType.MEDIUM_AMETHYST_BUD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType53, (String)"MEDIUM_AMETHYST_BUD");
        MEDIUM_AMETHYST_BUD = Companion.from(soundType53);
        SoundType soundType54 = SoundType.LARGE_AMETHYST_BUD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType54, (String)"LARGE_AMETHYST_BUD");
        LARGE_AMETHYST_BUD = Companion.from(soundType54);
        SoundType soundType55 = SoundType.TUFF;
        Intrinsics.checkNotNullExpressionValue((Object)soundType55, (String)"TUFF");
        TUFF = Companion.from(soundType55);
        SoundType soundType56 = SoundType.CALCITE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType56, (String)"CALCITE");
        CALCITE = Companion.from(soundType56);
        SoundType soundType57 = SoundType.DRIPSTONE_BLOCK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType57, (String)"DRIPSTONE_BLOCK");
        DRIPSTONE_BLOCK = Companion.from(soundType57);
        SoundType soundType58 = SoundType.POINTED_DRIPSTONE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType58, (String)"POINTED_DRIPSTONE");
        POINTED_DRIPSTONE = Companion.from(soundType58);
        SoundType soundType59 = SoundType.COPPER;
        Intrinsics.checkNotNullExpressionValue((Object)soundType59, (String)"COPPER");
        COPPER = Companion.from(soundType59);
        SoundType soundType60 = SoundType.CAVE_VINES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType60, (String)"CAVE_VINES");
        CAVE_VINES = Companion.from(soundType60);
        SoundType soundType61 = SoundType.SPORE_BLOSSOM;
        Intrinsics.checkNotNullExpressionValue((Object)soundType61, (String)"SPORE_BLOSSOM");
        SPORE_BLOSSOM = Companion.from(soundType61);
        SoundType soundType62 = SoundType.AZALEA;
        Intrinsics.checkNotNullExpressionValue((Object)soundType62, (String)"AZALEA");
        AZALEA = Companion.from(soundType62);
        SoundType soundType63 = SoundType.FLOWERING_AZALEA;
        Intrinsics.checkNotNullExpressionValue((Object)soundType63, (String)"FLOWERING_AZALEA");
        FLOWERING_AZALEA = Companion.from(soundType63);
        SoundType soundType64 = SoundType.MOSS_CARPET;
        Intrinsics.checkNotNullExpressionValue((Object)soundType64, (String)"MOSS_CARPET");
        MOSS_CARPET = Companion.from(soundType64);
        SoundType soundType65 = SoundType.MOSS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType65, (String)"MOSS");
        MOSS = Companion.from(soundType65);
        SoundType soundType66 = SoundType.BIG_DRIPLEAF;
        Intrinsics.checkNotNullExpressionValue((Object)soundType66, (String)"BIG_DRIPLEAF");
        BIG_DRIPLEAF = Companion.from(soundType66);
        SoundType soundType67 = SoundType.SMALL_DRIPLEAF;
        Intrinsics.checkNotNullExpressionValue((Object)soundType67, (String)"SMALL_DRIPLEAF");
        SMALL_DRIPLEAF = Companion.from(soundType67);
        SoundType soundType68 = SoundType.ROOTED_DIRT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType68, (String)"ROOTED_DIRT");
        ROOTED_DIRT = Companion.from(soundType68);
        SoundType soundType69 = SoundType.HANGING_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType69, (String)"HANGING_ROOTS");
        HANGING_ROOTS = Companion.from(soundType69);
        SoundType soundType70 = SoundType.AZALEA_LEAVES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType70, (String)"AZALEA_LEAVES");
        AZALEA_LEAVES = Companion.from(soundType70);
        SoundType soundType71 = SoundType.SCULK_SENSOR;
        Intrinsics.checkNotNullExpressionValue((Object)soundType71, (String)"SCULK_SENSOR");
        SCULK_SENSOR = Companion.from(soundType71);
        SoundType soundType72 = SoundType.SCULK_CATALYST;
        Intrinsics.checkNotNullExpressionValue((Object)soundType72, (String)"SCULK_CATALYST");
        SCULK_CATALYST = Companion.from(soundType72);
        SoundType soundType73 = SoundType.SCULK;
        Intrinsics.checkNotNullExpressionValue((Object)soundType73, (String)"SCULK");
        SCULK = Companion.from(soundType73);
        SoundType soundType74 = SoundType.SCULK_VEIN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType74, (String)"SCULK_VEIN");
        SCULK_VEIN = Companion.from(soundType74);
        SoundType soundType75 = SoundType.SCULK_SHRIEKER;
        Intrinsics.checkNotNullExpressionValue((Object)soundType75, (String)"SCULK_SHRIEKER");
        SCULK_SHRIEKER = Companion.from(soundType75);
        SoundType soundType76 = SoundType.GLOW_LICHEN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType76, (String)"GLOW_LICHEN");
        GLOW_LICHEN = Companion.from(soundType76);
        SoundType soundType77 = SoundType.DEEPSLATE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType77, (String)"DEEPSLATE");
        DEEPSLATE = Companion.from(soundType77);
        SoundType soundType78 = SoundType.DEEPSLATE_BRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType78, (String)"DEEPSLATE_BRICKS");
        DEEPSLATE_BRICKS = Companion.from(soundType78);
        SoundType soundType79 = SoundType.DEEPSLATE_TILES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType79, (String)"DEEPSLATE_TILES");
        DEEPSLATE_TILES = Companion.from(soundType79);
        SoundType soundType80 = SoundType.POLISHED_DEEPSLATE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType80, (String)"POLISHED_DEEPSLATE");
        POLISHED_DEEPSLATE = Companion.from(soundType80);
        SoundType soundType81 = SoundType.FROGLIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType81, (String)"FROGLIGHT");
        FROGLIGHT = Companion.from(soundType81);
        SoundType soundType82 = SoundType.FROGSPAWN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType82, (String)"FROGSPAWN");
        FROGSPAWN = Companion.from(soundType82);
        SoundType soundType83 = SoundType.MANGROVE_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType83, (String)"MANGROVE_ROOTS");
        MANGROVE_ROOTS = Companion.from(soundType83);
        SoundType soundType84 = SoundType.MUDDY_MANGROVE_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType84, (String)"MUDDY_MANGROVE_ROOTS");
        MUDDY_MANGROVE_ROOTS = Companion.from(soundType84);
        SoundType soundType85 = SoundType.MUD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType85, (String)"MUD");
        MUD = Companion.from(soundType85);
        SoundType soundType86 = SoundType.MUD_BRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType86, (String)"MUD_BRICKS");
        MUD_BRICKS = Companion.from(soundType86);
        SoundType soundType87 = SoundType.PACKED_MUD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType87, (String)"PACKED_MUD");
        PACKED_MUD = Companion.from(soundType87);
        SoundType soundType88 = SoundType.BAMBOO_WOOD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType88, (String)"BAMBOO_WOOD");
        BAMBOO_WOOD = Companion.from(soundType88);
        SoundType soundType89 = SoundType.BAMBOO_WOOD_HANGING_SIGN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType89, (String)"BAMBOO_WOOD_HANGING_SIGN");
        BAMBOO_WOOD_HANGING_SIGN = Companion.from(soundType89);
        SoundType soundType90 = SoundType.CHERRY_LEAVES;
        Intrinsics.checkNotNullExpressionValue((Object)soundType90, (String)"CHERRY_LEAVES");
        CHERRY_LEAVES = Companion.from(soundType90);
        SoundType soundType91 = SoundType.CHERRY_SAPLING;
        Intrinsics.checkNotNullExpressionValue((Object)soundType91, (String)"CHERRY_SAPLING");
        CHERRY_SAPLING = Companion.from(soundType91);
        SoundType soundType92 = SoundType.CHERRY_WOOD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType92, (String)"CHERRY_WOOD");
        CHERRY_WOOD = Companion.from(soundType92);
        SoundType soundType93 = SoundType.CHERRY_WOOD_HANGING_SIGN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType93, (String)"CHERRY_WOOD_HANGING_SIGN");
        CHERRY_WOOD_HANGING_SIGN = Companion.from(soundType93);
        SoundType soundType94 = SoundType.CHISELED_BOOKSHELF;
        Intrinsics.checkNotNullExpressionValue((Object)soundType94, (String)"CHISELED_BOOKSHELF");
        CHISELED_BOOKSHELF = Companion.from(soundType94);
        SoundType soundType95 = SoundType.COBWEB;
        Intrinsics.checkNotNullExpressionValue((Object)soundType95, (String)"COBWEB");
        COBWEB = Companion.from(soundType95);
        SoundType soundType96 = SoundType.COPPER_BULB;
        Intrinsics.checkNotNullExpressionValue((Object)soundType96, (String)"COPPER_BULB");
        COPPER_BULB = Companion.from(soundType96);
        SoundType soundType97 = SoundType.COPPER_GRATE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType97, (String)"COPPER_GRATE");
        COPPER_GRATE = Companion.from(soundType97);
        SoundType soundType98 = SoundType.DECORATED_POT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType98, (String)"DECORATED_POT");
        DECORATED_POT = Companion.from(soundType98);
        SoundType soundType99 = SoundType.DECORATED_POT_CRACKED;
        Intrinsics.checkNotNullExpressionValue((Object)soundType99, (String)"DECORATED_POT_CRACKED");
        DECORATED_POT_CRACKED = Companion.from(soundType99);
        SoundType soundType100 = SoundType.HANGING_SIGN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType100, (String)"HANGING_SIGN");
        HANGING_SIGN = Companion.from(soundType100);
        SoundType soundType101 = SoundType.HEAVY_CORE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType101, (String)"HEAVY_CORE");
        HEAVY_CORE = Companion.from(soundType101);
        SoundType soundType102 = SoundType.NETHER_WOOD;
        Intrinsics.checkNotNullExpressionValue((Object)soundType102, (String)"NETHER_WOOD");
        NETHER_WOOD = Companion.from(soundType102);
        SoundType soundType103 = SoundType.NETHER_WOOD_HANGING_SIGN;
        Intrinsics.checkNotNullExpressionValue((Object)soundType103, (String)"NETHER_WOOD_HANGING_SIGN");
        NETHER_WOOD_HANGING_SIGN = Companion.from(soundType103);
        SoundType soundType104 = SoundType.PINK_PETALS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType104, (String)"PINK_PETALS");
        PINK_PETALS = Companion.from(soundType104);
        SoundType soundType105 = SoundType.POLISHED_TUFF;
        Intrinsics.checkNotNullExpressionValue((Object)soundType105, (String)"POLISHED_TUFF");
        POLISHED_TUFF = Companion.from(soundType105);
        SoundType soundType106 = SoundType.SPONGE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType106, (String)"SPONGE");
        SPONGE = Companion.from(soundType106);
        SoundType soundType107 = SoundType.SUSPICIOUS_GRAVEL;
        Intrinsics.checkNotNullExpressionValue((Object)soundType107, (String)"SUSPICIOUS_GRAVEL");
        SUSPICIOUS_GRAVEL = Companion.from(soundType107);
        SoundType soundType108 = SoundType.SUSPICIOUS_SAND;
        Intrinsics.checkNotNullExpressionValue((Object)soundType108, (String)"SUSPICIOUS_SAND");
        SUSPICIOUS_SAND = Companion.from(soundType108);
        SoundType soundType109 = SoundType.TRIAL_SPAWNER;
        Intrinsics.checkNotNullExpressionValue((Object)soundType109, (String)"TRIAL_SPAWNER");
        TRIAL_SPAWNER = Companion.from(soundType109);
        SoundType soundType110 = SoundType.TUFF_BRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)soundType110, (String)"TUFF_BRICKS");
        TUFF_BRICKS = Companion.from(soundType110);
        SoundType soundType111 = SoundType.VAULT;
        Intrinsics.checkNotNullExpressionValue((Object)soundType111, (String)"VAULT");
        VAULT = Companion.from(soundType111);
        SoundType soundType112 = SoundType.WET_SPONGE;
        Intrinsics.checkNotNullExpressionValue((Object)soundType112, (String)"WET_SPONGE");
        WET_SPONGE = Companion.from(soundType112);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0003\b\u00e2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u00e6\u0001\u001a\u00020\u00052\b\u0010\u00e7\u0001\u001a\u00030\u00e8\u0001J\u0011\u0010\u00e6\u0001\u001a\u00020\u00052\b\u0010\u00e9\u0001\u001a\u00030\u00ea\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0007R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0007R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0007R\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0007R\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0007R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0007R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u0007R\u0011\u00108\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u0007R\u0011\u0010:\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0007R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0007R\u0011\u0010>\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0007R\u0011\u0010@\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0007R\u0011\u0010B\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0007R\u0011\u0010D\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0007R\u0011\u0010F\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0007R\u0011\u0010H\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0007R\u0011\u0010J\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0007R\u0011\u0010L\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010\u0007R\u0011\u0010N\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u0007R\u0011\u0010P\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\u0007R\u0011\u0010R\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\u0007R\u0011\u0010T\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0007R\u0011\u0010V\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\u0007R\u0011\u0010X\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0007R\u0011\u0010Z\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0007R\u0011\u0010\\\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\u0007R\u0011\u0010^\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0007R\u0011\u0010`\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\u0007R\u0011\u0010b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\u0007R\u0011\u0010d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\u0007R\u0011\u0010f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\u0007R\u0011\u0010h\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\u0007R\u0011\u0010j\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010\u0007R\u0011\u0010l\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010\u0007R\u0011\u0010n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\u0007R\u0011\u0010p\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010\u0007R\u0011\u0010r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010\u0007R\u0011\u0010t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\u0007R\u0011\u0010v\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bw\u0010\u0007R\u0011\u0010x\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\by\u0010\u0007R\u0011\u0010z\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b{\u0010\u0007R\u0011\u0010|\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b}\u0010\u0007R\u0011\u0010~\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u007f\u0010\u0007R\u0013\u0010\u0080\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0081\u0001\u0010\u0007R\u0013\u0010\u0082\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0007R\u0013\u0010\u0084\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0085\u0001\u0010\u0007R\u0013\u0010\u0086\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0087\u0001\u0010\u0007R\u0013\u0010\u0088\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0089\u0001\u0010\u0007R\u0013\u0010\u008a\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008b\u0001\u0010\u0007R\u0013\u0010\u008c\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008d\u0001\u0010\u0007R\u0013\u0010\u008e\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008f\u0001\u0010\u0007R\u0013\u0010\u0090\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0091\u0001\u0010\u0007R\u0013\u0010\u0092\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0093\u0001\u0010\u0007R\u0013\u0010\u0094\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0095\u0001\u0010\u0007R\u0013\u0010\u0096\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0097\u0001\u0010\u0007R\u0013\u0010\u0098\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0099\u0001\u0010\u0007R\u0013\u0010\u009a\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009b\u0001\u0010\u0007R\u0013\u0010\u009c\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009d\u0001\u0010\u0007R\u0013\u0010\u009e\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009f\u0001\u0010\u0007R\u0013\u0010\u00a0\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a1\u0001\u0010\u0007R\u0013\u0010\u00a2\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a3\u0001\u0010\u0007R\u0013\u0010\u00a4\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a5\u0001\u0010\u0007R\u0013\u0010\u00a6\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a7\u0001\u0010\u0007R\u0013\u0010\u00a8\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a9\u0001\u0010\u0007R\u0013\u0010\u00aa\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ab\u0001\u0010\u0007R\u0013\u0010\u00ac\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00ad\u0001\u0010\u0007R\u0013\u0010\u00ae\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00af\u0001\u0010\u0007R\u0013\u0010\u00b0\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b1\u0001\u0010\u0007R\u0013\u0010\u00b2\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b3\u0001\u0010\u0007R\u0013\u0010\u00b4\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b5\u0001\u0010\u0007R\u0013\u0010\u00b6\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b7\u0001\u0010\u0007R\u0013\u0010\u00b8\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b9\u0001\u0010\u0007R\u0013\u0010\u00ba\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bb\u0001\u0010\u0007R\u0013\u0010\u00bc\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bd\u0001\u0010\u0007R\u0013\u0010\u00be\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bf\u0001\u0010\u0007R\u0013\u0010\u00c0\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c1\u0001\u0010\u0007R\u0013\u0010\u00c2\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c3\u0001\u0010\u0007R\u0013\u0010\u00c4\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c5\u0001\u0010\u0007R\u0013\u0010\u00c6\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c7\u0001\u0010\u0007R\u0013\u0010\u00c8\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c9\u0001\u0010\u0007R\u0013\u0010\u00ca\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cb\u0001\u0010\u0007R\u0013\u0010\u00cc\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cd\u0001\u0010\u0007R\u0013\u0010\u00ce\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cf\u0001\u0010\u0007R\u0013\u0010\u00d0\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d1\u0001\u0010\u0007R\u0013\u0010\u00d2\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d3\u0001\u0010\u0007R\u0013\u0010\u00d4\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d5\u0001\u0010\u0007R\u0013\u0010\u00d6\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d7\u0001\u0010\u0007R\u0013\u0010\u00d8\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00d9\u0001\u0010\u0007R\u0013\u0010\u00da\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00db\u0001\u0010\u0007R\u0013\u0010\u00dc\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00dd\u0001\u0010\u0007R\u0013\u0010\u00de\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00df\u0001\u0010\u0007R\u0013\u0010\u00e0\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e1\u0001\u0010\u0007R\u0013\u0010\u00e2\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e3\u0001\u0010\u0007R\u0013\u0010\u00e4\u0001\u001a\u00020\u0005\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00e5\u0001\u0010\u0007\u00a8\u0006\u00eb\u0001"}, d2={"Lxyz/xenondevs/nova/world/block/sound/SoundGroup$Companion;", "", "<init>", "()V", "WOOD", "Lxyz/xenondevs/nova/world/block/sound/SoundGroup;", "getWOOD", "()Lxyz/xenondevs/nova/world/block/sound/SoundGroup;", "GRAVEL", "getGRAVEL", "GRASS", "getGRASS", "LILY_PAD", "getLILY_PAD", "STONE", "getSTONE", "METAL", "getMETAL", "GLASS", "getGLASS", "WOOL", "getWOOL", "SAND", "getSAND", "SNOW", "getSNOW", "POWDER_SNOW", "getPOWDER_SNOW", "LADDER", "getLADDER", "ANVIL", "getANVIL", "SLIME_BLOCK", "getSLIME_BLOCK", "HONEY_BLOCK", "getHONEY_BLOCK", "WET_GRASS", "getWET_GRASS", "CORAL_BLOCK", "getCORAL_BLOCK", "BAMBOO", "getBAMBOO", "BAMBOO_SAPLING", "getBAMBOO_SAPLING", "SCAFFOLDING", "getSCAFFOLDING", "SWEET_BERRY_BUSH", "getSWEET_BERRY_BUSH", "CROP", "getCROP", "HARD_CROP", "getHARD_CROP", "VINE", "getVINE", "NETHER_WART", "getNETHER_WART", "LANTERN", "getLANTERN", "STEM", "getSTEM", "NYLIUM", "getNYLIUM", "FUNGUS", "getFUNGUS", "ROOTS", "getROOTS", "SHROOMLIGHT", "getSHROOMLIGHT", "WEEPING_VINES", "getWEEPING_VINES", "TWISTING_VINES", "getTWISTING_VINES", "SOUL_SAND", "getSOUL_SAND", "SOUL_SOIL", "getSOUL_SOIL", "BASALT", "getBASALT", "WART_BLOCK", "getWART_BLOCK", "NETHERRACK", "getNETHERRACK", "NETHER_BRICKS", "getNETHER_BRICKS", "NETHER_SPROUTS", "getNETHER_SPROUTS", "NETHER_ORE", "getNETHER_ORE", "BONE_BLOCK", "getBONE_BLOCK", "NETHERITE_BLOCK", "getNETHERITE_BLOCK", "ANCIENT_DEBRIS", "getANCIENT_DEBRIS", "LODESTONE", "getLODESTONE", "CHAIN", "getCHAIN", "NETHER_GOLD_ORE", "getNETHER_GOLD_ORE", "GILDED_BLACKSTONE", "getGILDED_BLACKSTONE", "CANDLE", "getCANDLE", "AMETHYST", "getAMETHYST", "AMETHYST_CLUSTER", "getAMETHYST_CLUSTER", "SMALL_AMETHYST_BUD", "getSMALL_AMETHYST_BUD", "MEDIUM_AMETHYST_BUD", "getMEDIUM_AMETHYST_BUD", "LARGE_AMETHYST_BUD", "getLARGE_AMETHYST_BUD", "TUFF", "getTUFF", "CALCITE", "getCALCITE", "DRIPSTONE_BLOCK", "getDRIPSTONE_BLOCK", "POINTED_DRIPSTONE", "getPOINTED_DRIPSTONE", "COPPER", "getCOPPER", "CAVE_VINES", "getCAVE_VINES", "SPORE_BLOSSOM", "getSPORE_BLOSSOM", "AZALEA", "getAZALEA", "FLOWERING_AZALEA", "getFLOWERING_AZALEA", "MOSS_CARPET", "getMOSS_CARPET", "MOSS", "getMOSS", "BIG_DRIPLEAF", "getBIG_DRIPLEAF", "SMALL_DRIPLEAF", "getSMALL_DRIPLEAF", "ROOTED_DIRT", "getROOTED_DIRT", "HANGING_ROOTS", "getHANGING_ROOTS", "AZALEA_LEAVES", "getAZALEA_LEAVES", "SCULK_SENSOR", "getSCULK_SENSOR", "SCULK_CATALYST", "getSCULK_CATALYST", "SCULK", "getSCULK", "SCULK_VEIN", "getSCULK_VEIN", "SCULK_SHRIEKER", "getSCULK_SHRIEKER", "GLOW_LICHEN", "getGLOW_LICHEN", "DEEPSLATE", "getDEEPSLATE", "DEEPSLATE_BRICKS", "getDEEPSLATE_BRICKS", "DEEPSLATE_TILES", "getDEEPSLATE_TILES", "POLISHED_DEEPSLATE", "getPOLISHED_DEEPSLATE", "FROGLIGHT", "getFROGLIGHT", "FROGSPAWN", "getFROGSPAWN", "MANGROVE_ROOTS", "getMANGROVE_ROOTS", "MUDDY_MANGROVE_ROOTS", "getMUDDY_MANGROVE_ROOTS", "MUD", "getMUD", "MUD_BRICKS", "getMUD_BRICKS", "PACKED_MUD", "getPACKED_MUD", "BAMBOO_WOOD", "getBAMBOO_WOOD", "BAMBOO_WOOD_HANGING_SIGN", "getBAMBOO_WOOD_HANGING_SIGN", "CHERRY_LEAVES", "getCHERRY_LEAVES", "CHERRY_SAPLING", "getCHERRY_SAPLING", "CHERRY_WOOD", "getCHERRY_WOOD", "CHERRY_WOOD_HANGING_SIGN", "getCHERRY_WOOD_HANGING_SIGN", "CHISELED_BOOKSHELF", "getCHISELED_BOOKSHELF", "COBWEB", "getCOBWEB", "COPPER_BULB", "getCOPPER_BULB", "COPPER_GRATE", "getCOPPER_GRATE", "DECORATED_POT", "getDECORATED_POT", "DECORATED_POT_CRACKED", "getDECORATED_POT_CRACKED", "HANGING_SIGN", "getHANGING_SIGN", "HEAVY_CORE", "getHEAVY_CORE", "NETHER_WOOD", "getNETHER_WOOD", "NETHER_WOOD_HANGING_SIGN", "getNETHER_WOOD_HANGING_SIGN", "PINK_PETALS", "getPINK_PETALS", "POLISHED_TUFF", "getPOLISHED_TUFF", "SPONGE", "getSPONGE", "SUSPICIOUS_GRAVEL", "getSUSPICIOUS_GRAVEL", "SUSPICIOUS_SAND", "getSUSPICIOUS_SAND", "TRIAL_SPAWNER", "getTRIAL_SPAWNER", "TUFF_BRICKS", "getTUFF_BRICKS", "VAULT", "getVAULT", "WET_SPONGE", "getWET_SPONGE", "from", "soundGroup", "Lorg/bukkit/SoundGroup;", "soundType", "Lnet/minecraft/world/level/block/SoundType;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SoundGroup getWOOD() {
            return WOOD;
        }

        @NotNull
        public final SoundGroup getGRAVEL() {
            return GRAVEL;
        }

        @NotNull
        public final SoundGroup getGRASS() {
            return GRASS;
        }

        @NotNull
        public final SoundGroup getLILY_PAD() {
            return LILY_PAD;
        }

        @NotNull
        public final SoundGroup getSTONE() {
            return STONE;
        }

        @NotNull
        public final SoundGroup getMETAL() {
            return METAL;
        }

        @NotNull
        public final SoundGroup getGLASS() {
            return GLASS;
        }

        @NotNull
        public final SoundGroup getWOOL() {
            return WOOL;
        }

        @NotNull
        public final SoundGroup getSAND() {
            return SAND;
        }

        @NotNull
        public final SoundGroup getSNOW() {
            return SNOW;
        }

        @NotNull
        public final SoundGroup getPOWDER_SNOW() {
            return POWDER_SNOW;
        }

        @NotNull
        public final SoundGroup getLADDER() {
            return LADDER;
        }

        @NotNull
        public final SoundGroup getANVIL() {
            return ANVIL;
        }

        @NotNull
        public final SoundGroup getSLIME_BLOCK() {
            return SLIME_BLOCK;
        }

        @NotNull
        public final SoundGroup getHONEY_BLOCK() {
            return HONEY_BLOCK;
        }

        @NotNull
        public final SoundGroup getWET_GRASS() {
            return WET_GRASS;
        }

        @NotNull
        public final SoundGroup getCORAL_BLOCK() {
            return CORAL_BLOCK;
        }

        @NotNull
        public final SoundGroup getBAMBOO() {
            return BAMBOO;
        }

        @NotNull
        public final SoundGroup getBAMBOO_SAPLING() {
            return BAMBOO_SAPLING;
        }

        @NotNull
        public final SoundGroup getSCAFFOLDING() {
            return SCAFFOLDING;
        }

        @NotNull
        public final SoundGroup getSWEET_BERRY_BUSH() {
            return SWEET_BERRY_BUSH;
        }

        @NotNull
        public final SoundGroup getCROP() {
            return CROP;
        }

        @NotNull
        public final SoundGroup getHARD_CROP() {
            return HARD_CROP;
        }

        @NotNull
        public final SoundGroup getVINE() {
            return VINE;
        }

        @NotNull
        public final SoundGroup getNETHER_WART() {
            return NETHER_WART;
        }

        @NotNull
        public final SoundGroup getLANTERN() {
            return LANTERN;
        }

        @NotNull
        public final SoundGroup getSTEM() {
            return STEM;
        }

        @NotNull
        public final SoundGroup getNYLIUM() {
            return NYLIUM;
        }

        @NotNull
        public final SoundGroup getFUNGUS() {
            return FUNGUS;
        }

        @NotNull
        public final SoundGroup getROOTS() {
            return ROOTS;
        }

        @NotNull
        public final SoundGroup getSHROOMLIGHT() {
            return SHROOMLIGHT;
        }

        @NotNull
        public final SoundGroup getWEEPING_VINES() {
            return WEEPING_VINES;
        }

        @NotNull
        public final SoundGroup getTWISTING_VINES() {
            return TWISTING_VINES;
        }

        @NotNull
        public final SoundGroup getSOUL_SAND() {
            return SOUL_SAND;
        }

        @NotNull
        public final SoundGroup getSOUL_SOIL() {
            return SOUL_SOIL;
        }

        @NotNull
        public final SoundGroup getBASALT() {
            return BASALT;
        }

        @NotNull
        public final SoundGroup getWART_BLOCK() {
            return WART_BLOCK;
        }

        @NotNull
        public final SoundGroup getNETHERRACK() {
            return NETHERRACK;
        }

        @NotNull
        public final SoundGroup getNETHER_BRICKS() {
            return NETHER_BRICKS;
        }

        @NotNull
        public final SoundGroup getNETHER_SPROUTS() {
            return NETHER_SPROUTS;
        }

        @NotNull
        public final SoundGroup getNETHER_ORE() {
            return NETHER_ORE;
        }

        @NotNull
        public final SoundGroup getBONE_BLOCK() {
            return BONE_BLOCK;
        }

        @NotNull
        public final SoundGroup getNETHERITE_BLOCK() {
            return NETHERITE_BLOCK;
        }

        @NotNull
        public final SoundGroup getANCIENT_DEBRIS() {
            return ANCIENT_DEBRIS;
        }

        @NotNull
        public final SoundGroup getLODESTONE() {
            return LODESTONE;
        }

        @NotNull
        public final SoundGroup getCHAIN() {
            return CHAIN;
        }

        @NotNull
        public final SoundGroup getNETHER_GOLD_ORE() {
            return NETHER_GOLD_ORE;
        }

        @NotNull
        public final SoundGroup getGILDED_BLACKSTONE() {
            return GILDED_BLACKSTONE;
        }

        @NotNull
        public final SoundGroup getCANDLE() {
            return CANDLE;
        }

        @NotNull
        public final SoundGroup getAMETHYST() {
            return AMETHYST;
        }

        @NotNull
        public final SoundGroup getAMETHYST_CLUSTER() {
            return AMETHYST_CLUSTER;
        }

        @NotNull
        public final SoundGroup getSMALL_AMETHYST_BUD() {
            return SMALL_AMETHYST_BUD;
        }

        @NotNull
        public final SoundGroup getMEDIUM_AMETHYST_BUD() {
            return MEDIUM_AMETHYST_BUD;
        }

        @NotNull
        public final SoundGroup getLARGE_AMETHYST_BUD() {
            return LARGE_AMETHYST_BUD;
        }

        @NotNull
        public final SoundGroup getTUFF() {
            return TUFF;
        }

        @NotNull
        public final SoundGroup getCALCITE() {
            return CALCITE;
        }

        @NotNull
        public final SoundGroup getDRIPSTONE_BLOCK() {
            return DRIPSTONE_BLOCK;
        }

        @NotNull
        public final SoundGroup getPOINTED_DRIPSTONE() {
            return POINTED_DRIPSTONE;
        }

        @NotNull
        public final SoundGroup getCOPPER() {
            return COPPER;
        }

        @NotNull
        public final SoundGroup getCAVE_VINES() {
            return CAVE_VINES;
        }

        @NotNull
        public final SoundGroup getSPORE_BLOSSOM() {
            return SPORE_BLOSSOM;
        }

        @NotNull
        public final SoundGroup getAZALEA() {
            return AZALEA;
        }

        @NotNull
        public final SoundGroup getFLOWERING_AZALEA() {
            return FLOWERING_AZALEA;
        }

        @NotNull
        public final SoundGroup getMOSS_CARPET() {
            return MOSS_CARPET;
        }

        @NotNull
        public final SoundGroup getMOSS() {
            return MOSS;
        }

        @NotNull
        public final SoundGroup getBIG_DRIPLEAF() {
            return BIG_DRIPLEAF;
        }

        @NotNull
        public final SoundGroup getSMALL_DRIPLEAF() {
            return SMALL_DRIPLEAF;
        }

        @NotNull
        public final SoundGroup getROOTED_DIRT() {
            return ROOTED_DIRT;
        }

        @NotNull
        public final SoundGroup getHANGING_ROOTS() {
            return HANGING_ROOTS;
        }

        @NotNull
        public final SoundGroup getAZALEA_LEAVES() {
            return AZALEA_LEAVES;
        }

        @NotNull
        public final SoundGroup getSCULK_SENSOR() {
            return SCULK_SENSOR;
        }

        @NotNull
        public final SoundGroup getSCULK_CATALYST() {
            return SCULK_CATALYST;
        }

        @NotNull
        public final SoundGroup getSCULK() {
            return SCULK;
        }

        @NotNull
        public final SoundGroup getSCULK_VEIN() {
            return SCULK_VEIN;
        }

        @NotNull
        public final SoundGroup getSCULK_SHRIEKER() {
            return SCULK_SHRIEKER;
        }

        @NotNull
        public final SoundGroup getGLOW_LICHEN() {
            return GLOW_LICHEN;
        }

        @NotNull
        public final SoundGroup getDEEPSLATE() {
            return DEEPSLATE;
        }

        @NotNull
        public final SoundGroup getDEEPSLATE_BRICKS() {
            return DEEPSLATE_BRICKS;
        }

        @NotNull
        public final SoundGroup getDEEPSLATE_TILES() {
            return DEEPSLATE_TILES;
        }

        @NotNull
        public final SoundGroup getPOLISHED_DEEPSLATE() {
            return POLISHED_DEEPSLATE;
        }

        @NotNull
        public final SoundGroup getFROGLIGHT() {
            return FROGLIGHT;
        }

        @NotNull
        public final SoundGroup getFROGSPAWN() {
            return FROGSPAWN;
        }

        @NotNull
        public final SoundGroup getMANGROVE_ROOTS() {
            return MANGROVE_ROOTS;
        }

        @NotNull
        public final SoundGroup getMUDDY_MANGROVE_ROOTS() {
            return MUDDY_MANGROVE_ROOTS;
        }

        @NotNull
        public final SoundGroup getMUD() {
            return MUD;
        }

        @NotNull
        public final SoundGroup getMUD_BRICKS() {
            return MUD_BRICKS;
        }

        @NotNull
        public final SoundGroup getPACKED_MUD() {
            return PACKED_MUD;
        }

        @NotNull
        public final SoundGroup getBAMBOO_WOOD() {
            return BAMBOO_WOOD;
        }

        @NotNull
        public final SoundGroup getBAMBOO_WOOD_HANGING_SIGN() {
            return BAMBOO_WOOD_HANGING_SIGN;
        }

        @NotNull
        public final SoundGroup getCHERRY_LEAVES() {
            return CHERRY_LEAVES;
        }

        @NotNull
        public final SoundGroup getCHERRY_SAPLING() {
            return CHERRY_SAPLING;
        }

        @NotNull
        public final SoundGroup getCHERRY_WOOD() {
            return CHERRY_WOOD;
        }

        @NotNull
        public final SoundGroup getCHERRY_WOOD_HANGING_SIGN() {
            return CHERRY_WOOD_HANGING_SIGN;
        }

        @NotNull
        public final SoundGroup getCHISELED_BOOKSHELF() {
            return CHISELED_BOOKSHELF;
        }

        @NotNull
        public final SoundGroup getCOBWEB() {
            return COBWEB;
        }

        @NotNull
        public final SoundGroup getCOPPER_BULB() {
            return COPPER_BULB;
        }

        @NotNull
        public final SoundGroup getCOPPER_GRATE() {
            return COPPER_GRATE;
        }

        @NotNull
        public final SoundGroup getDECORATED_POT() {
            return DECORATED_POT;
        }

        @NotNull
        public final SoundGroup getDECORATED_POT_CRACKED() {
            return DECORATED_POT_CRACKED;
        }

        @NotNull
        public final SoundGroup getHANGING_SIGN() {
            return HANGING_SIGN;
        }

        @NotNull
        public final SoundGroup getHEAVY_CORE() {
            return HEAVY_CORE;
        }

        @NotNull
        public final SoundGroup getNETHER_WOOD() {
            return NETHER_WOOD;
        }

        @NotNull
        public final SoundGroup getNETHER_WOOD_HANGING_SIGN() {
            return NETHER_WOOD_HANGING_SIGN;
        }

        @NotNull
        public final SoundGroup getPINK_PETALS() {
            return PINK_PETALS;
        }

        @NotNull
        public final SoundGroup getPOLISHED_TUFF() {
            return POLISHED_TUFF;
        }

        @NotNull
        public final SoundGroup getSPONGE() {
            return SPONGE;
        }

        @NotNull
        public final SoundGroup getSUSPICIOUS_GRAVEL() {
            return SUSPICIOUS_GRAVEL;
        }

        @NotNull
        public final SoundGroup getSUSPICIOUS_SAND() {
            return SUSPICIOUS_SAND;
        }

        @NotNull
        public final SoundGroup getTRIAL_SPAWNER() {
            return TRIAL_SPAWNER;
        }

        @NotNull
        public final SoundGroup getTUFF_BRICKS() {
            return TUFF_BRICKS;
        }

        @NotNull
        public final SoundGroup getVAULT() {
            return VAULT;
        }

        @NotNull
        public final SoundGroup getWET_SPONGE() {
            return WET_SPONGE;
        }

        @NotNull
        public final SoundGroup from(@NotNull org.bukkit.SoundGroup soundGroup) {
            Intrinsics.checkNotNullParameter((Object)soundGroup, (String)"soundGroup");
            return new SoundGroup(soundGroup.getVolume(), soundGroup.getPitch(), soundGroup.getBreakSound().key().toString(), soundGroup.getStepSound().key().toString(), soundGroup.getPlaceSound().key().toString(), soundGroup.getHitSound().key().toString(), soundGroup.getFallSound().key().toString());
        }

        @NotNull
        public final SoundGroup from(@NotNull SoundType soundType) {
            Intrinsics.checkNotNullParameter((Object)soundType, (String)"soundType");
            float f = soundType.volume;
            float f2 = soundType.pitch;
            String string = soundType.breakSound.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = soundType.getStepSound().location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = soundType.getPlaceSound().location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = soundType.hitSound.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String string5 = soundType.getFallSound().location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
            return new SoundGroup(f, f2, string, string2, string3, string4, string5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

