/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.state.model;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.world.block.state.model.BackingStateConfig;
import xyz.xenondevs.nova.world.block.state.model.DynamicDefaultingBackingStateConfigType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J'\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig;", "Lxyz/xenondevs/nova/world/block/state/model/BackingStateConfig;", "instrument", "Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "note", "", "powered", "", "<init>", "(Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;IZ)V", "getInstrument", "()Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "getNote", "()I", "getPowered", "()Z", "type", "Lxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig$Companion;", "getType", "()Lxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig$Companion;", "id", "getId", "waterlogged", "getWaterlogged", "variantMap", "", "", "getVariantMap", "()Ljava/util/Map;", "vanillaBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getVanillaBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "Companion", "nova"})
public final class NoteBackingStateConfig
extends BackingStateConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NoteBlockInstrument instrument;
    private final int note;
    private final boolean powered;
    @NotNull
    private final Companion type;
    private final int id;
    private final boolean waterlogged;
    @NotNull
    private final Map<String, String> variantMap;
    @NotNull
    private final BlockState vanillaBlockState;
    @NotNull
    private static final HashSet<String> properties;
    private static final boolean isWaterloggable;

    public NoteBackingStateConfig(@NotNull NoteBlockInstrument instrument, int note, boolean powered) {
        Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
        this.instrument = instrument;
        this.note = note;
        this.powered = powered;
        this.type = Companion;
        this.id = Companion.getIdOf(this.instrument, this.note, this.powered);
        Pair[] pairArray = new Pair[3];
        String string = this.instrument.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        pairArray[0] = TuplesKt.to((Object)"instrument", (Object)string);
        pairArray[1] = TuplesKt.to((Object)"note", (Object)String.valueOf(this.note));
        pairArray[2] = TuplesKt.to((Object)"powered", (Object)String.valueOf(this.powered));
        this.variantMap = MapsKt.mapOf((Pair[])pairArray);
        Object object = ((BlockState)((BlockState)Blocks.NOTE_BLOCK.defaultBlockState().setValue((Property)NoteBlock.INSTRUMENT, (Comparable)this.instrument)).setValue((Property)NoteBlock.NOTE, (Comparable)Integer.valueOf(this.note))).setValue((Property)NoteBlock.POWERED, (Comparable)Boolean.valueOf(this.powered));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        this.vanillaBlockState = (BlockState)object;
        int n = this.note;
        if (!(0 <= n ? n < 25 : false)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final NoteBlockInstrument getInstrument() {
        return this.instrument;
    }

    public final int getNote() {
        return this.note;
    }

    public final boolean getPowered() {
        return this.powered;
    }

    @NotNull
    public Companion getType() {
        return this.type;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getWaterlogged() {
        return this.waterlogged;
    }

    @Override
    @NotNull
    public Map<String, String> getVariantMap() {
        return this.variantMap;
    }

    @Override
    @NotNull
    public BlockState getVanillaBlockState() {
        return this.vanillaBlockState;
    }

    @NotNull
    public final NoteBlockInstrument component1() {
        return this.instrument;
    }

    public final int component2() {
        return this.note;
    }

    public final boolean component3() {
        return this.powered;
    }

    @NotNull
    public final NoteBackingStateConfig copy(@NotNull NoteBlockInstrument instrument, int note, boolean powered) {
        Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
        return new NoteBackingStateConfig(instrument, note, powered);
    }

    public static /* synthetic */ NoteBackingStateConfig copy$default(NoteBackingStateConfig noteBackingStateConfig, NoteBlockInstrument noteBlockInstrument, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            noteBlockInstrument = noteBackingStateConfig.instrument;
        }
        if ((n2 & 2) != 0) {
            n = noteBackingStateConfig.note;
        }
        if ((n2 & 4) != 0) {
            bl = noteBackingStateConfig.powered;
        }
        return noteBackingStateConfig.copy(noteBlockInstrument, n, bl);
    }

    @NotNull
    public String toString() {
        return "NoteBackingStateConfig(instrument=" + this.instrument + ", note=" + this.note + ", powered=" + this.powered + ")";
    }

    @Override
    public int hashCode() {
        int result = this.instrument.hashCode();
        result = result * 31 + Integer.hashCode(this.note);
        result = result * 31 + Boolean.hashCode(this.powered);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NoteBackingStateConfig)) {
            return false;
        }
        NoteBackingStateConfig noteBackingStateConfig = (NoteBackingStateConfig)other;
        if (this.instrument != noteBackingStateConfig.instrument) {
            return false;
        }
        if (this.note != noteBackingStateConfig.note) {
            return false;
        }
        return this.powered == noteBackingStateConfig.powered;
    }

    static {
        Object[] objectArray = new String[]{"instrument", "note", "powered"};
        properties = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u001c\u0010\u0014\u001a\u00020\u00022\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0016R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0018"}, d2={"Lxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig$Companion;", "Lxyz/xenondevs/nova/world/block/state/model/DynamicDefaultingBackingStateConfigType;", "Lxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig;", "<init>", "()V", "properties", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getProperties", "()Ljava/util/HashSet;", "isWaterloggable", "", "()Z", "getIdOf", "", "instrument", "Lnet/minecraft/world/level/block/state/properties/NoteBlockInstrument;", "note", "powered", "of", "id", "waterlogged", "", "nova"})
    @SourceDebugExtension(value={"SMAP\nNoteBackingStateConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoteBackingStateConfig.kt\nxyz/xenondevs/nova/world/block/state/model/NoteBackingStateConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
    public static final class Companion
    extends DynamicDefaultingBackingStateConfigType<NoteBackingStateConfig> {
        private Companion() {
            super(1149, "note_block");
        }

        @NotNull
        public HashSet<String> getProperties() {
            return properties;
        }

        @Override
        public boolean isWaterloggable() {
            return isWaterloggable;
        }

        public final int getIdOf(@NotNull NoteBlockInstrument instrument, int note, boolean powered) {
            Intrinsics.checkNotNullParameter((Object)instrument, (String)"instrument");
            return instrument.ordinal() * 25 * 2 + note * 2 + MathUtilsKt.getIntValue(powered);
        }

        @Override
        @NotNull
        public NoteBackingStateConfig of(int id, boolean waterlogged) {
            if (waterlogged) {
                throw new UnsupportedOperationException("Note block cannot be waterlogged");
            }
            return new NoteBackingStateConfig((NoteBlockInstrument)EntriesMappings.entries$0.get(id / 2 / 25 % 23), id / 2 % 25, id % 2 == 1);
        }

        @Override
        @NotNull
        public NoteBackingStateConfig of(@NotNull Map<String, String> properties) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(properties, (String)"properties");
                    string = properties.get("instrument");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    String string2 = it.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    NoteBlockInstrument noteBlockInstrument = NoteBlockInstrument.valueOf((String)string2);
                    string = noteBlockInstrument;
                    if (noteBlockInstrument != null) break block3;
                }
                string = NoteBlockInstrument.HARP;
            }
            String string3 = properties.get("note");
            String string4 = properties.get("powered");
            boolean bl = string4 != null ? Boolean.parseBoolean(string4) : false;
            int n = string3 != null ? Integer.parseInt(string3) : 0;
            String string5 = string;
            return new NoteBackingStateConfig((NoteBlockInstrument)string5, n, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<NoteBlockInstrument> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])NoteBlockInstrument.values()));
            }
        }
    }
}

