/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network.type.energy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import xyz.xenondevs.commons.provider.Provider;
import xyz.xenondevs.commons.provider.Providers;
import xyz.xenondevs.commons.tuple.Tuple2;
import xyz.xenondevs.nova.config.ConfigProviderKt;
import xyz.xenondevs.nova.config.ConfigsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.tileentity.network.Network;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkData;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNode;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNodeConnection;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkConnectionType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.EnergyBridge;
import xyz.xenondevs.nova.world.block.tileentity.network.type.energy.holder.EnergyHolder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u00017B\u0017\b\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JU\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00110\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150!H\u0082\bJ\u001e\u0010\"\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002J\b\u0010'\u001a\u00020(H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0007j\b\u0012\u0004\u0012\u00020\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\u00020$*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001e\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u000204X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00068"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork;", "Lxyz/xenondevs/nova/world/block/tileentity/network/Network;", "Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkData;", "networkData", "<init>", "(Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkData;)V", "endPoints", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkEndPoint;", "Lkotlin/collections/ArrayList;", "providers", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/EnergyHolder;", "consumers", "buffers", "complexity", "", "transferRate", "", "isValid", "", "tick", "", "distributeEqually", "energy", "", "ignored", "Ljava/util/BitSet;", "takeEqually", "modifyEqually", "holders", "value", "Lkotlin/Function1;", "apply", "Lkotlin/Function2;", "balance", "fillFrac", "", "getFillFrac", "(Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/holder/EnergyHolder;)D", "toString", "", "nodes", "", "Lxyz/xenondevs/nova/world/BlockPos;", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkNodeConnection;", "getNodes", "()Ljava/util/Map;", "type", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "getType", "()Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nEnergyNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork\n+ 2 Iterables.kt\nxyz/xenondevs/commons/collections/IterablesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MathUtils.kt\nxyz/xenondevs/nova/util/MathUtilsKt\n+ 5 ConfigProvider.kt\nxyz/xenondevs/nova/config/ConfigProviderKt\n*L\n1#1,256:1\n145#1,41:308\n145#1,41:349\n82#2,9:257\n1740#3,3:266\n1011#3,2:416\n35#4,13:269\n35#4,13:282\n35#4,13:295\n35#4,13:390\n35#4,13:403\n75#5:418\n75#5:419\n75#5:420\n*S KotlinDebug\n*F\n+ 1 EnergyNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork\n*L\n133#1:308,41\n136#1:349,41\n39#1:257,9\n73#1:266,3\n197#1:416,2\n98#1:269,13\n108#1:282,13\n118#1:295,13\n191#1:390,13\n192#1:403,13\n239#1:418\n240#1:419\n243#1:420\n*E\n"})
public final class EnergyNetwork
implements Network<EnergyNetwork>,
NetworkData<EnergyNetwork> {
    @NotNull
    public static final Companion Companion;
    private final /* synthetic */ NetworkData<EnergyNetwork> $$delegate_0;
    @NotNull
    private final ArrayList<NetworkEndPoint> endPoints;
    @NotNull
    private final ArrayList<EnergyHolder> providers;
    @NotNull
    private final ArrayList<EnergyHolder> consumers;
    @NotNull
    private final ArrayList<EnergyHolder> buffers;
    private final int complexity;
    private final long transferRate;
    @NotNull
    private static final Provider<CommentedConfigurationNode> ENERGY_NETWORK;
    @NotNull
    private static final Provider<Integer> TICK_DELAY_PROVIDER;
    @NotNull
    private static final Provider<Long> DEFAULT_TRANSFER_RATE$delegate;
    @NotNull
    private static final Provider<Integer> MAX_COMPLEXITY$delegate;

    public EnergyNetwork(@NotNull NetworkData<EnergyNetwork> networkData) {
        Intrinsics.checkNotNullParameter(networkData, (String)"networkData");
        this.$$delegate_0 = networkData;
        this.endPoints = new ArrayList();
        this.providers = new ArrayList();
        this.consumers = new ArrayList();
        this.buffers = new ArrayList();
        long transferRate = Companion.getDEFAULT_TRANSFER_RATE();
        int complexity = 0;
        for (Map.Entry<BlockPos, NetworkNodeConnection> entry : networkData.getNodes().entrySet()) {
            BlockPos pos = entry.getKey();
            NetworkNodeConnection con = entry.getValue();
            NetworkNode node2 = con.component1();
            Set<BlockFace> faces = con.component2();
            try {
                if (node2 instanceof NetworkEndPoint) {
                    EnergyHolder energyHolder;
                    Object v0;
                    block12: {
                        Iterable $this$firstInstanceOfOrNull$iv = ((NetworkEndPoint)node2).getHolders();
                        boolean $i$f$firstInstanceOfOrNull = false;
                        for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                            if (!(element$iv instanceof EnergyHolder)) continue;
                            v0 = element$iv;
                            break block12;
                        }
                        v0 = null;
                    }
                    if ((EnergyHolder)v0 == null) continue;
                    boolean insert = false;
                    boolean extract = false;
                    for (BlockFace face : faces) {
                        NetworkConnectionType connectionType;
                        if (energyHolder.getConnectionConfig().get(face) == null) {
                            throw new IllegalArgumentException("Missing connection config for " + face);
                        }
                        insert = insert || connectionType.getInsert();
                        extract = extract || connectionType.getExtract();
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[NetworkConnectionType.Companion.of(insert, extract).ordinal()]) {
                        case 1: {
                            ((Collection)this.buffers).add(energyHolder);
                            break;
                        }
                        case 2: {
                            ((Collection)this.consumers).add(energyHolder);
                            break;
                        }
                        case 3: {
                            ((Collection)this.providers).add(energyHolder);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid connection config for " + energyHolder);
                        }
                    }
                    ((Collection)this.endPoints).add(node2);
                    ++complexity;
                    continue;
                }
                if (!(node2 instanceof EnergyBridge)) continue;
                transferRate = Math.min(transferRate, ((EnergyBridge)node2).getEnergyTransferRate());
            }
            catch (Exception e) {
                throw new Exception("Failed to add to energy network: " + pos + " " + con, e);
            }
        }
        this.transferRate = transferRate;
        this.complexity = complexity;
    }

    @Override
    public boolean isValid() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.endPoints;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    NetworkEndPoint it = (NetworkEndPoint)element$iv;
                    boolean bl2 = false;
                    if (it.isValid()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void tick() {
        long distributed;
        long energy;
        long $this$sumOfNoOverflow$iv2;
        long result$iv;
        long element$iv;
        EnergyHolder it;
        long sum$iv;
        boolean $i$f$sumOfNoOverflow;
        if (Companion.getMAX_COMPLEXITY() != -1 && this.complexity > Companion.getMAX_COMPLEXITY()) {
            return;
        }
        long transferCapacity = this.transferRate;
        BitSet ignoredProviders = new BitSet(this.providers.size());
        BitSet ignoredConsumers = new BitSet(this.consumers.size());
        if (!((Collection)this.providers).isEmpty() && !((Collection)this.consumers).isEmpty()) {
            long l;
            block14: {
                Iterable $this$sumOfNoOverflow$iv2 = this.providers;
                $i$f$sumOfNoOverflow = false;
                sum$iv = 0L;
                for (Object element$iv2 : $this$sumOfNoOverflow$iv2) {
                    it = (EnergyHolder)element$iv2;
                    boolean bl = false;
                    element$iv = it.getEnergy();
                    result$iv = sum$iv + element$iv;
                    if (((sum$iv ^ result$iv) & (element$iv ^ result$iv)) < 0L) {
                        l = Long.MAX_VALUE;
                        break block14;
                    }
                    sum$iv = result$iv;
                }
                l = sum$iv;
            }
            $this$sumOfNoOverflow$iv2 = l;
            energy = Math.min(transferCapacity, $this$sumOfNoOverflow$iv2);
            distributed = this.distributeEqually(energy, (List<? extends EnergyHolder>)this.consumers, ignoredConsumers);
            this.takeEqually(distributed, (List<? extends EnergyHolder>)this.providers, ignoredProviders);
            if ((transferCapacity -= distributed) <= 0L) {
                return;
            }
        }
        if (!((Collection)this.buffers).isEmpty() && !((Collection)this.consumers).isEmpty()) {
            long l;
            block15: {
                Iterable $this$sumOfNoOverflow$iv3 = this.buffers;
                $i$f$sumOfNoOverflow = false;
                sum$iv = 0L;
                for (Object element$iv2 : $this$sumOfNoOverflow$iv3) {
                    it = (EnergyHolder)element$iv2;
                    boolean bl = false;
                    element$iv = it.getEnergy();
                    result$iv = sum$iv + element$iv;
                    if (((sum$iv ^ result$iv) & (element$iv ^ result$iv)) < 0L) {
                        l = Long.MAX_VALUE;
                        break block15;
                    }
                    sum$iv = result$iv;
                }
                l = sum$iv;
            }
            $this$sumOfNoOverflow$iv2 = l;
            energy = Math.min(transferCapacity, $this$sumOfNoOverflow$iv2);
            distributed = this.distributeEqually(energy, (List<? extends EnergyHolder>)this.consumers, ignoredConsumers);
            this.takeEqually(distributed, (List<? extends EnergyHolder>)this.buffers, new BitSet(this.buffers.size()));
            if ((transferCapacity -= distributed) <= 0L) {
                return;
            }
        }
        if (!((Collection)this.providers).isEmpty() && !((Collection)this.buffers).isEmpty()) {
            long l;
            block16: {
                Iterable $this$sumOfNoOverflow$iv4 = this.providers;
                $i$f$sumOfNoOverflow = false;
                sum$iv = 0L;
                for (Object element$iv2 : $this$sumOfNoOverflow$iv4) {
                    it = (EnergyHolder)element$iv2;
                    boolean bl = false;
                    element$iv = it.getEnergy();
                    result$iv = sum$iv + element$iv;
                    if (((sum$iv ^ result$iv) & (element$iv ^ result$iv)) < 0L) {
                        l = Long.MAX_VALUE;
                        break block16;
                    }
                    sum$iv = result$iv;
                }
                l = sum$iv;
            }
            long $this$sumOfNoOverflow$iv4 = l;
            energy = Math.min(transferCapacity, $this$sumOfNoOverflow$iv4);
            long distributed2 = this.distributeEqually(energy, (List<? extends EnergyHolder>)this.buffers, new BitSet(this.buffers.size()));
            this.takeEqually(distributed2, (List<? extends EnergyHolder>)this.providers, ignoredProviders);
            if ((transferCapacity -= distributed2) <= 0L) {
                return;
            }
        }
        if (this.buffers.size() >= 2) {
            this.balance(transferCapacity, (List<? extends EnergyHolder>)this.buffers);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long distributeEqually(long energy, List<? extends EnergyHolder> consumers, BitSet ignored) {
        EnergyHolder it;
        long energy2;
        boolean bl;
        EnergyHolder holder2;
        long l;
        void var33_24;
        void energyPerHolder$iv;
        void holders$iv;
        int ignoredHolderCount$iv;
        void energy$iv;
        EnergyNetwork energyNetwork = this;
        long l2 = energy;
        List<? extends EnergyHolder> list = consumers;
        BitSet ignored$iv = ignored;
        boolean $i$f$modifyEqually = false;
        void remaining$iv = energy$iv;
        while (remaining$iv > 0L && (ignoredHolderCount$iv = ignored$iv.cardinality()) != holders$iv.size() && (energyPerHolder$iv = remaining$iv / (long)(holders$iv.size() - ignoredHolderCount$iv)) > 0L) {
            Iterator iterator = ((Iterable)holders$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long energyForHolder$iv;
                void it2;
                int idx$iv = n++;
                EnergyHolder holder$iv = (EnergyHolder)iterator.next();
                if (ignored$iv.get(idx$iv)) continue;
                EnergyHolder energyHolder = holder$iv;
                var33_24 = energyPerHolder$iv;
                boolean bl2 = false;
                l = it2.getMaxEnergy() - it2.getEnergy();
                long l3 = energyForHolder$iv = Math.min((long)var33_24, l);
                holder2 = holder$iv;
                bl = false;
                holder2.setEnergy(holder2.getEnergy() + energy2);
                remaining$iv -= energyForHolder$iv;
                it = holder$iv;
                bl3 = false;
                if (it.getMaxEnergy() - it.getEnergy() > 0L) continue;
                ignored$iv.set(idx$iv);
            }
        }
        if (remaining$iv > 0L) {
            Iterator iterator = ((Iterable)holders$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long energyForHolder$iv;
                int idx$iv = n++;
                EnergyHolder holder$iv = (EnergyHolder)iterator.next();
                if (ignored$iv.get(idx$iv)) continue;
                it = holder$iv;
                var33_24 = remaining$iv;
                boolean bl3 = false;
                l = it.getMaxEnergy() - it.getEnergy();
                energy2 = energyForHolder$iv = Math.min((long)var33_24, l);
                holder2 = holder$iv;
                bl = false;
                holder2.setEnergy(holder2.getEnergy() + energy2);
                if ((remaining$iv -= energyForHolder$iv) > 0L) continue;
                break;
            }
        }
        return (long)(energy$iv - remaining$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final long takeEqually(long energy, List<? extends EnergyHolder> providers, BitSet ignored) {
        EnergyHolder p0;
        long energy2;
        boolean bl;
        EnergyHolder holder2;
        long l;
        void var33_24;
        void energyPerHolder$iv;
        void holders$iv;
        int ignoredHolderCount$iv;
        void energy$iv;
        EnergyNetwork energyNetwork = this;
        long l2 = energy;
        List<? extends EnergyHolder> list = providers;
        BitSet ignored$iv = ignored;
        boolean $i$f$modifyEqually = false;
        void remaining$iv = energy$iv;
        while (remaining$iv > 0L && (ignoredHolderCount$iv = ignored$iv.cardinality()) != holders$iv.size() && (energyPerHolder$iv = remaining$iv / (long)(holders$iv.size() - ignoredHolderCount$iv)) > 0L) {
            Iterator iterator = ((Iterable)holders$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long energyForHolder$iv;
                void p02;
                int idx$iv = n++;
                EnergyHolder holder$iv = (EnergyHolder)iterator.next();
                if (ignored$iv.get(idx$iv)) continue;
                EnergyHolder energyHolder = holder$iv;
                var33_24 = energyPerHolder$iv;
                boolean bl2 = false;
                l = p02.getEnergy();
                long l3 = energyForHolder$iv = Math.min((long)var33_24, l);
                holder2 = holder$iv;
                bl = false;
                holder2.setEnergy(holder2.getEnergy() - energy2);
                remaining$iv -= energyForHolder$iv;
                p0 = holder$iv;
                bl3 = false;
                if (p0.getEnergy() > 0L) continue;
                ignored$iv.set(idx$iv);
            }
        }
        if (remaining$iv > 0L) {
            Iterator iterator = ((Iterable)holders$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                long energyForHolder$iv;
                int idx$iv = n++;
                EnergyHolder holder$iv = (EnergyHolder)iterator.next();
                if (ignored$iv.get(idx$iv)) continue;
                p0 = holder$iv;
                var33_24 = remaining$iv;
                boolean bl3 = false;
                l = p0.getEnergy();
                energy2 = energyForHolder$iv = Math.min((long)var33_24, l);
                holder2 = holder$iv;
                bl = false;
                holder2.setEnergy(holder2.getEnergy() - energy2);
                if ((remaining$iv -= energyForHolder$iv) > 0L) continue;
                break;
            }
        }
        return (long)(energy$iv - remaining$iv);
    }

    private final long modifyEqually(long energy, List<? extends EnergyHolder> holders, BitSet ignored, Function1<? super EnergyHolder, Long> value, Function2<? super EnergyHolder, ? super Long, Unit> apply) {
        long energyPerHolder;
        int ignoredHolderCount;
        boolean $i$f$modifyEqually = false;
        long remaining = energy;
        while (remaining > 0L && (ignoredHolderCount = ignored.cardinality()) != holders.size() && (energyPerHolder = remaining / (long)(holders.size() - ignoredHolderCount)) > 0L) {
            Iterator iterator = ((Iterable)holders).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int idx = n++;
                EnergyHolder holder2 = (EnergyHolder)iterator.next();
                if (ignored.get(idx)) continue;
                long energyForHolder = Math.min(energyPerHolder, ((Number)value.invoke((Object)holder2)).longValue());
                apply.invoke((Object)holder2, (Object)energyForHolder);
                remaining -= energyForHolder;
                if (((Number)value.invoke((Object)holder2)).longValue() > 0L) continue;
                ignored.set(idx);
            }
        }
        if (remaining > 0L) {
            Iterator iterator = ((Iterable)holders).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int idx = n++;
                EnergyHolder holder3 = (EnergyHolder)iterator.next();
                if (ignored.get(idx)) continue;
                long energyForHolder = Math.min(remaining, ((Number)value.invoke((Object)holder3)).longValue());
                apply.invoke((Object)holder3, (Object)energyForHolder);
                if ((remaining -= energyForHolder) > 0L) continue;
                break;
            }
        }
        return energy - remaining;
    }

    private final void balance(long energy, List<? extends EnergyHolder> buffers) {
        long l;
        long totalEnergy;
        long transferCapacity;
        block9: {
            long l2;
            block8: {
                transferCapacity = energy;
                Iterable $this$sumOfNoOverflow$iv = buffers;
                boolean $i$f$sumOfNoOverflow = false;
                long sum$iv = 0L;
                for (Object element$iv : $this$sumOfNoOverflow$iv) {
                    EnergyHolder it = (EnergyHolder)element$iv;
                    boolean bl = false;
                    long element$iv2 = it.getEnergy();
                    long result$iv = sum$iv + element$iv2;
                    if (((sum$iv ^ result$iv) & (element$iv2 ^ result$iv)) < 0L) {
                        l2 = Long.MAX_VALUE;
                        break block8;
                    }
                    sum$iv = result$iv;
                }
                l2 = sum$iv;
            }
            totalEnergy = l2;
            Iterable $this$sumOfNoOverflow$iv = buffers;
            boolean $i$f$sumOfNoOverflow = false;
            long sum$iv = 0L;
            for (Object element$iv : $this$sumOfNoOverflow$iv) {
                EnergyHolder it = (EnergyHolder)element$iv;
                boolean bl = false;
                long element$iv3 = it.getMaxEnergy();
                long result$iv = sum$iv + element$iv3;
                if (((sum$iv ^ result$iv) & (element$iv3 ^ result$iv)) < 0L) {
                    l = Long.MAX_VALUE;
                    break block9;
                }
                sum$iv = result$iv;
            }
            l = sum$iv;
        }
        long totalCapacity = l;
        double targetFillFrac = (double)totalEnergy / (double)totalCapacity;
        List sortedBuffers = CollectionsKt.toMutableList((Collection)buffers);
        while (transferCapacity > 0L && sortedBuffers.size() >= 2) {
            List $this$sortBy$iv = sortedBuffers;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                    final /* synthetic */ EnergyNetwork this$0;
                    {
                        this.this$0 = energyNetwork;
                    }

                    public final int compare(T a, T b) {
                        EnergyHolder it = (EnergyHolder)a;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(EnergyNetwork.access$getFillFrac(this.this$0, it));
                        it = (EnergyHolder)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(EnergyNetwork.access$getFillFrac(this.this$0, it)));
                    }
                });
            }
            EnergyHolder lowestFillHolder = (EnergyHolder)CollectionsKt.first((List)sortedBuffers);
            EnergyHolder highestFillHolder = (EnergyHolder)CollectionsKt.last((List)sortedBuffers);
            double lowestFillFrac = this.getFillFrac(lowestFillHolder);
            double highestFillFrac = this.getFillFrac(highestFillHolder);
            if (highestFillFrac <= lowestFillFrac) break;
            long available = (long)((this.getFillFrac(highestFillHolder) - targetFillFrac) * (double)highestFillHolder.getMaxEnergy());
            long required = (long)((targetFillFrac - this.getFillFrac(lowestFillHolder)) * (double)lowestFillHolder.getMaxEnergy());
            if (available <= 0L || required <= 0L) {
                if (available <= 0L) {
                    sortedBuffers.removeLast();
                }
                if (required > 0L) continue;
                sortedBuffers.removeFirst();
                continue;
            }
            long transferAmount = Math.min(transferCapacity, Math.min(available, required));
            highestFillHolder.setEnergy(highestFillHolder.getEnergy() - transferAmount);
            lowestFillHolder.setEnergy(lowestFillHolder.getEnergy() + transferAmount);
            transferCapacity -= transferAmount;
        }
    }

    private final double getFillFrac(EnergyHolder $this$fillFrac) {
        return (double)$this$fillFrac.getEnergy() / (double)$this$fillFrac.getMaxEnergy();
    }

    @NotNull
    public String toString() {
        return "EnergyNetwork(nodes=" + this.getNodes() + ")";
    }

    @Override
    @NotNull
    public NetworkType<EnergyNetwork> getType() {
        return this.$$delegate_0.getType();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.$$delegate_0.getUuid();
    }

    @Override
    @NotNull
    public Map<BlockPos, NetworkNodeConnection> getNodes() {
        return this.$$delegate_0.getNodes();
    }

    private static final long DEFAULT_TRANSFER_RATE_delegate$lambda$0(Tuple2 tuple2) {
        Intrinsics.checkNotNullParameter((Object)tuple2, (String)"<destruct>");
        double defaultTransferRate = ((Number)tuple2.component1()).doubleValue();
        int tickDelay = ((Number)tuple2.component2()).intValue();
        return MathKt.roundToLong((double)(defaultTransferRate * (double)tickDelay));
    }

    private static final long DEFAULT_TRANSFER_RATE_delegate$lambda$1(long defaultTransferRate) {
        return defaultTransferRate < 0L ? Long.MAX_VALUE : defaultTransferRate;
    }

    public static final /* synthetic */ double access$getFillFrac(EnergyNetwork $this, EnergyHolder $receiver) {
        return $this.getFillFrac($receiver);
    }

    static {
        String[] path$iv;
        Provider<CommentedConfigurationNode> $this$entry$iv;
        Companion = new Companion(null);
        String[] stringArray = new String[]{"network", "energy"};
        stringArray = ENERGY_NETWORK = ConfigProviderKt.weakNodeTyped(ConfigsKt.getMAIN_CONFIG(), stringArray);
        String[] stringArray2 = new String[]{"tick_delay"};
        boolean $i$f$entry = false;
        TICK_DELAY_PROVIDER = ConfigProviderKt.entry((Provider<? extends ConfigurationNode>)$this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Integer.TYPE)), (String[])Arrays.copyOf(path$iv, path$iv.length));
        $this$entry$iv = ENERGY_NETWORK;
        path$iv = new String[]{"default_transfer_rate"};
        $i$f$entry = false;
        DEFAULT_TRANSFER_RATE$delegate = Providers.combinedProvider(ConfigProviderKt.entry($this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Double.TYPE)), Arrays.copyOf(path$iv, path$iv.length)), TICK_DELAY_PROVIDER).map(EnergyNetwork::DEFAULT_TRANSFER_RATE_delegate$lambda$0).map(EnergyNetwork::DEFAULT_TRANSFER_RATE_delegate$lambda$1);
        $this$entry$iv = ENERGY_NETWORK;
        path$iv = new String[]{"max_complexity"};
        $i$f$entry = false;
        MAX_COMPLEXITY$delegate = ConfigProviderKt.entry($this$entry$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(Integer.TYPE)), Arrays.copyOf(path$iv, path$iv.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork$Companion;", "", "<init>", "()V", "ENERGY_NETWORK", "Lxyz/xenondevs/commons/provider/Provider;", "Lorg/spongepowered/configurate/CommentedConfigurationNode;", "kotlin.jvm.PlatformType", "TICK_DELAY_PROVIDER", "", "getTICK_DELAY_PROVIDER", "()Lxyz/xenondevs/commons/provider/Provider;", "DEFAULT_TRANSFER_RATE", "", "getDEFAULT_TRANSFER_RATE", "()J", "DEFAULT_TRANSFER_RATE$delegate", "Lxyz/xenondevs/commons/provider/Provider;", "MAX_COMPLEXITY", "getMAX_COMPLEXITY", "()I", "MAX_COMPLEXITY$delegate", "validateLocal", "", "from", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkEndPoint;", "to", "face", "Lorg/bukkit/block/BlockFace;", "validateLocal$nova", "nova"})
    @SourceDebugExtension(value={"SMAP\nEnergyNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork$Companion\n+ 2 Iterables.kt\nxyz/xenondevs/commons/collections/IterablesKt\n*L\n1#1,256:1\n82#2,9:257\n82#2,9:266\n*S KotlinDebug\n*F\n+ 1 EnergyNetwork.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/energy/EnergyNetwork$Companion\n*L\n246#1:257,9\n247#1:266,9\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Provider<Integer> getTICK_DELAY_PROVIDER() {
            return TICK_DELAY_PROVIDER;
        }

        public final long getDEFAULT_TRANSFER_RATE() {
            return ((Number)DEFAULT_TRANSFER_RATE$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
        }

        public final int getMAX_COMPLEXITY() {
            return ((Number)MAX_COMPLEXITY$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
        }

        public final boolean validateLocal$nova(@NotNull NetworkEndPoint from, @NotNull NetworkEndPoint to, @NotNull BlockFace face) {
            NetworkConnectionType conTo;
            Object v2;
            EnergyHolder itemHolderFrom;
            block5: {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                    Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                    Intrinsics.checkNotNullParameter((Object)face, (String)"face");
                    Iterable $this$firstInstanceOfOrNull$iv = from.getHolders();
                    boolean $i$f$firstInstanceOfOrNull = false;
                    for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                        if (!(element$iv instanceof EnergyHolder)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                EnergyHolder energyHolder = v0;
                if (energyHolder == null) {
                    return false;
                }
                itemHolderFrom = energyHolder;
                Iterable $this$firstInstanceOfOrNull$iv = to.getHolders();
                boolean $i$f$firstInstanceOfOrNull = false;
                for (Object element$iv : $this$firstInstanceOfOrNull$iv) {
                    if (!(element$iv instanceof EnergyHolder)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            EnergyHolder energyHolder = v2;
            if (energyHolder == null) {
                return false;
            }
            EnergyHolder itemHolderTo = energyHolder;
            NetworkConnectionType conFrom = itemHolderFrom.getConnectionConfig().get(face);
            return conFrom != (conTo = itemHolderTo.getConnectionConfig().get(face.getOppositeFace())) || conFrom == NetworkConnectionType.BUFFER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "DEFAULT_TRANSFER_RATE", "getDEFAULT_TRANSFER_RATE()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "MAX_COMPLEXITY", "getMAX_COMPLEXITY()I", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NetworkConnectionType.values().length];
            try {
                nArray[NetworkConnectionType.BUFFER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkConnectionType.INSERT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkConnectionType.EXTRACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

