/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.FluidType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.fluid.container.NetworkedFluidContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B9\u00120\u0010\u0002\u001a,\u0012(\u0012&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002JB\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u0002J4\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J&\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J&\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J\u001e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002R8\u0010\u0002\u001a,\u0012(\u0012&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/channel/FluidDistributor;", "", "priorityLevels", "", "Lkotlin/Triple;", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/container/NetworkedFluidContainer;", "<init>", "(Ljava/util/List;)V", "fluidContainers", "", "distribute", "", "transferAmount", "findFluidType", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/FluidType;", "distributeInScope", "type", "consumersInScope", "providersInScope", "buffersInScope", "distributeBetween", "maxTransfers", "consumers", "", "providers", "giveEqually", "amount", "giveFirst", "takeEqually", "", "takeFirst", "nova"})
@SourceDebugExtension(value={"SMAP\nFluidDistributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FluidDistributor.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/channel/FluidDistributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MathUtils.kt\nxyz/xenondevs/nova/util/MathUtilsKt\n*L\n1#1,166:1\n1869#2,2:167\n1869#2,2:169\n1761#2,3:172\n855#2,2:175\n865#2,2:177\n1869#2,2:192\n1869#2,2:194\n1#3:171\n35#4,13:179\n*S KotlinDebug\n*F\n+ 1 FluidDistributor.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/fluid/channel/FluidDistributor\n*L\n13#1:167,2\n50#1:169,2\n58#1:172,3\n68#1:175,2\n69#1:177,2\n131#1:192,2\n160#1:194,2\n94#1:179,13\n*E\n"})
public final class FluidDistributor {
    @NotNull
    private final List<Triple<List<NetworkedFluidContainer>, List<NetworkedFluidContainer>, List<NetworkedFluidContainer>>> priorityLevels;
    @NotNull
    private final Set<NetworkedFluidContainer> fluidContainers;

    /*
     * WARNING - void declaration
     */
    public FluidDistributor(@NotNull List<? extends Triple<? extends List<? extends NetworkedFluidContainer>, ? extends List<? extends NetworkedFluidContainer>, ? extends List<? extends NetworkedFluidContainer>>> priorityLevels) {
        HashSet hashSet;
        Intrinsics.checkNotNullParameter(priorityLevels, (String)"priorityLevels");
        this.priorityLevels = priorityLevels;
        HashSet hashSet2 = hashSet = new HashSet();
        FluidDistributor fluidDistributor = this;
        boolean bl = false;
        Iterable $this$forEach$iv = this.priorityLevels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            Triple triple = (Triple)element$iv;
            boolean bl2 = false;
            List consumers = (List)triple.component1();
            List providers = (List)triple.component2();
            List buffers = (List)triple.component3();
            CollectionsKt.addAll((Collection)((Collection)it), (Iterable)consumers);
            CollectionsKt.addAll((Collection)((Collection)it), (Iterable)providers);
            CollectionsKt.addAll((Collection)((Collection)it), (Iterable)buffers);
        }
        fluidDistributor.fluidContainers = hashSet;
    }

    public final long distribute(long transferAmount) {
        List buffersInScope;
        List providersInScope;
        Triple<List<NetworkedFluidContainer>, List<NetworkedFluidContainer>, List<NetworkedFluidContainer>> triple;
        List consumersInScope;
        FluidType fluidType = this.findFluidType();
        if (fluidType == null) {
            return transferAmount;
        }
        FluidType type = fluidType;
        long transfersLeft = transferAmount;
        for (int priority = 0; (transfersLeft = this.distributeInScope(transfersLeft, type, consumersInScope = (List)(triple = this.priorityLevels.get(priority)).component1(), providersInScope = (List)triple.component2(), buffersInScope = (List)triple.component3())) != 0L && priority < this.priorityLevels.size() - 1; ++priority) {
        }
        return transfersLeft;
    }

    private final FluidType findFluidType() {
        FluidType fluidType;
        FluidType fluidType2 = null;
        Iterable $this$forEach$iv = this.fluidContainers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            if (fluidType2 != null) {
                if (fluidType2 == it.getType()) continue;
                return null;
            }
            fluidType2 = it.getType();
        }
        FluidType fluidType3 = fluidType2;
        if (fluidType3 != null) {
            boolean bl;
            FluidType fluidType4;
            block7: {
                FluidType it = fluidType4 = fluidType3;
                boolean bl2 = false;
                Iterable $this$any$iv = this.fluidContainers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NetworkedFluidContainer it2 = (NetworkedFluidContainer)element$iv;
                        boolean bl3 = false;
                        if (!(!it2.getAllowedTypes().contains((Object)fluidType2))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            fluidType = !bl ? fluidType4 : null;
        } else {
            fluidType = null;
        }
        return fluidType;
    }

    /*
     * WARNING - void declaration
     */
    private final long distributeInScope(long transferAmount, FluidType type, List<? extends NetworkedFluidContainer> consumersInScope, List<? extends NetworkedFluidContainer> providersInScope, List<? extends NetworkedFluidContainer> buffersInScope) {
        void $this$filterTo$iv;
        void $this$filterNotTo$iv;
        Iterable iterable = consumersInScope;
        Iterable destination$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
            boolean bl = false;
            if (it.isFull()) continue;
            destination$iv.add(element$iv);
        }
        ArrayList consumers = (ArrayList)destination$iv;
        destination$iv = providersInScope;
        Collection destination$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv2.add(element$iv);
        }
        ArrayList providers = (ArrayList)destination$iv2;
        long availableTransfers = transferAmount;
        if ((availableTransfers -= this.distributeBetween(availableTransfers, type, consumers, providers)) != 0L && consumers.isEmpty() ^ providers.isEmpty()) {
            if (consumers.isEmpty()) {
                CollectionsKt.addAll((Collection)consumers, (Iterable)buffersInScope);
            } else {
                CollectionsKt.addAll((Collection)providers, (Iterable)buffersInScope);
            }
            availableTransfers -= this.distributeBetween(availableTransfers, type, consumers, providers);
        }
        return availableTransfers;
    }

    private final long distributeBetween(long maxTransfers, FluidType type, List<NetworkedFluidContainer> consumers, List<NetworkedFluidContainer> providers) {
        long l;
        block3: {
            Iterable $this$sumOfNoOverflow$iv = providers;
            boolean $i$f$sumOfNoOverflow = false;
            long sum$iv = 0L;
            for (Object element$iv : $this$sumOfNoOverflow$iv) {
                NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
                boolean bl = false;
                long element$iv2 = it.getAmount();
                long result$iv = sum$iv + element$iv2;
                if (((sum$iv ^ result$iv) & (element$iv2 ^ result$iv)) < 0L) {
                    l = Long.MAX_VALUE;
                    break block3;
                }
                sum$iv = result$iv;
            }
            l = sum$iv;
        }
        long $this$sumOfNoOverflow$iv = l;
        long availableFluid = Math.min(maxTransfers, $this$sumOfNoOverflow$iv);
        if (availableFluid == 0L) {
            return 0L;
        }
        long distributed = this.giveEqually(availableFluid, type, consumers);
        this.takeEqually(distributed, providers);
        return distributed;
    }

    private final long giveEqually(long amount, FluidType type, List<NetworkedFluidContainer> consumers) {
        if (amount == 0L) {
            return 0L;
        }
        Ref.LongRef remaining = new Ref.LongRef();
        remaining.element = amount;
        while (remaining.element != 0L && !((Collection)consumers).isEmpty()) {
            long cut = remaining.element / (long)consumers.size();
            if (cut == 0L) {
                remaining.element = this.giveFirst(remaining.element, type, consumers);
                break;
            }
            consumers.removeIf(arg_0 -> FluidDistributor.giveEqually$lambda$1(arg_0 -> FluidDistributor.giveEqually$lambda$0(type, cut, remaining, arg_0), arg_0));
        }
        return amount - remaining.element;
    }

    private final long giveFirst(long amount, FluidType type, List<NetworkedFluidContainer> consumers) {
        if (amount == 0L) {
            return 0L;
        }
        long remaining = 0L;
        remaining = amount;
        Iterable $this$forEach$iv = consumers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
            boolean bl = false;
            remaining -= it.addFluid(type, remaining);
        }
        return remaining;
    }

    private final void takeEqually(long amount, List<NetworkedFluidContainer> providers) {
        Ref.LongRef remaining = new Ref.LongRef();
        remaining.element = amount;
        while (remaining.element != 0L && !((Collection)providers).isEmpty()) {
            long cut = remaining.element / (long)providers.size();
            if (cut == 0L) {
                remaining.element = this.takeFirst(remaining.element, providers);
                break;
            }
            providers.removeIf(arg_0 -> FluidDistributor.takeEqually$lambda$1(arg_0 -> FluidDistributor.takeEqually$lambda$0(cut, remaining, arg_0), arg_0));
        }
        if (remaining.element != 0L) {
            throw new IllegalStateException("Could not provide the fluid distributed");
        }
    }

    private final long takeFirst(long amount, List<NetworkedFluidContainer> providers) {
        long remaining = 0L;
        remaining = amount;
        Iterable $this$forEach$iv = providers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkedFluidContainer it = (NetworkedFluidContainer)element$iv;
            boolean bl = false;
            remaining -= it.takeFluid(remaining);
        }
        return remaining;
    }

    private static final boolean giveEqually$lambda$0(FluidType $type, long $cut, Ref.LongRef $remaining, NetworkedFluidContainer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long added = it.addFluid($type, $cut);
        $remaining.element -= added;
        return it.isFull();
    }

    private static final boolean giveEqually$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean takeEqually$lambda$0(long $cut, Ref.LongRef $remaining, NetworkedFluidContainer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long take = it.takeFluid($cut);
        $remaining.element -= take;
        return take == 0L;
    }

    private static final boolean takeEqually$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

