/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.fakeentity;

import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.network.PacketIdRegistry;
import xyz.xenondevs.nova.network.PacketManagerKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.ChunkPosKt;
import xyz.xenondevs.nova.world.fakeentity.FakeEntityManager;
import xyz.xenondevs.nova.world.fakeentity.metadata.Metadata;
import xyz.xenondevs.nova.world.item.logic.PacketItems;

@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u00108\u001a\u000200J\u0006\u00109\u001a\u000200J\u000e\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020\u0013J\u000e\u0010<\u001a\u0002002\u0006\u0010;\u001a\u00020\u0013J'\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020\u00102\u0017\u0010?\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0002\b@J \u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010>\u001a\u00020\u0010J\u001f\u0010F\u001a\u0002002\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0002\b@J\u0018\u0010F\u001a\u0002002\u0006\u0010H\u001a\u00020\u00052\b\b\u0002\u0010I\u001a\u00020\u0010J\u0015\u0010J\u001a\u0002002\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020 H\u0002J\b\u0010M\u001a\u00020 H\u0002J\b\u0010N\u001a\u00020 H\u0002J \u0010O\u001a\u00020 2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020QH\u0002J0\u0010T\u001a\u00020 2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020Q2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020VH\u0002J\u0010\u0010X\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010Y\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0012\u0010\b\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n \u0014*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001e\u0010*\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010,0,0+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010-R(\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u000200\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R(\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u000200\u0018\u00010/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104\u00a8\u0006Z"}, d2={"Lxyz/xenondevs/nova/world/fakeentity/FakeEntity;", "M", "Lxyz/xenondevs/nova/world/fakeentity/metadata/Metadata;", "", "location", "Lorg/bukkit/Location;", "<init>", "(Lorg/bukkit/Location;)V", "metadata", "getMetadata", "()Lxyz/xenondevs/nova/world/fakeentity/metadata/Metadata;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "registered", "", "_viewers", "", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "viewers", "getViewers", "()Ljava/util/Set;", "entityId", "", "getEntityId", "()I", "uuid", "Ljava/util/UUID;", "spawnBuf", "Lnet/minecraft/network/FriendlyByteBuf;", "dataBuf", "equipmentBuf", "despawnBuf", "expectedLocation", "actualLocation", "chunk", "Lxyz/xenondevs/nova/world/ChunkPos;", "getLocation", "()Lorg/bukkit/Location;", "equipment", "", "Lnet/minecraft/world/item/ItemStack;", "[Lnet/minecraft/world/item/ItemStack;", "spawnHandler", "Lkotlin/Function1;", "", "getSpawnHandler", "()Lkotlin/jvm/functions/Function1;", "setSpawnHandler", "(Lkotlin/jvm/functions/Function1;)V", "despawnHandler", "getDespawnHandler", "setDespawnHandler", "register", "remove", "spawn", "player", "despawn", "updateEntityData", "sendPacket", "update", "Lkotlin/ExtensionFunctionType;", "setEquipment", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "bukkitStack", "Lorg/bukkit/inventory/ItemStack;", "teleport", "modifyLocation", "newLocation", "forceTeleport", "updateLocationSilently", "updateLocationSilently$nova", "createSpawnBuf", "createDespawnDataBuf", "createEquipmentBuf", "createPosBuf", "x", "", "y", "z", "createPosRotBuf", "yaw", "", "pitch", "createRotBuf", "createTeleportBuf", "nova"})
@SourceDebugExtension(value={"SMAP\nFakeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeEntity.kt\nxyz/xenondevs/nova/world/fakeentity/FakeEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,321:1\n1#2:322\n12767#3,2:323\n13870#3,3:331\n1869#4,2:325\n1869#4,2:327\n1869#4,2:329\n*S KotlinDebug\n*F\n+ 1 FakeEntity.kt\nxyz/xenondevs/nova/world/fakeentity/FakeEntity\n*L\n90#1:323,2\n266#1:331,3\n124#1:325,2\n143#1:327,2\n202#1:329,2\n*E\n"})
public abstract class FakeEntity<M extends Metadata> {
    private boolean registered;
    private final Set<Player> _viewers;
    private final int entityId;
    private final UUID uuid;
    @Nullable
    private FriendlyByteBuf spawnBuf;
    @Nullable
    private FriendlyByteBuf dataBuf;
    @Nullable
    private FriendlyByteBuf equipmentBuf;
    @NotNull
    private FriendlyByteBuf despawnBuf;
    @NotNull
    private Location expectedLocation;
    @NotNull
    private Location actualLocation;
    @NotNull
    private ChunkPos chunk;
    @NotNull
    private final net.minecraft.world.item.ItemStack[] equipment;
    @Nullable
    private Function1<? super Player, Unit> spawnHandler;
    @Nullable
    private Function1<? super Player, Unit> despawnHandler;

    public FakeEntity(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this._viewers = Collections.newSetFromMap(new WeakHashMap());
        this.entityId = Entity.ENTITY_COUNTER.incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.despawnBuf = this.createDespawnDataBuf();
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        this.expectedLocation = location2;
        Location location3 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"clone(...)");
        this.actualLocation = location3;
        this.chunk = ChunkPosKt.getChunkPos(location);
        int n = 0;
        net.minecraft.world.item.ItemStack[] itemStackArray = new net.minecraft.world.item.ItemStack[6];
        FakeEntity fakeEntity = this;
        while (n < 6) {
            int n2 = n++;
            itemStackArray[n2] = net.minecraft.world.item.ItemStack.EMPTY;
        }
        fakeEntity.equipment = itemStackArray;
    }

    @NotNull
    public abstract M getMetadata();

    @NotNull
    protected abstract EntityType<?> getEntityType();

    @NotNull
    public final Set<Player> getViewers() {
        Set<Player> set = this._viewers;
        Intrinsics.checkNotNullExpressionValue(set, (String)"_viewers");
        return set;
    }

    public final int getEntityId() {
        return this.entityId;
    }

    @NotNull
    public final Location getLocation() {
        Location location = this.expectedLocation.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        return location;
    }

    @Nullable
    public final Function1<Player, Unit> getSpawnHandler() {
        return this.spawnHandler;
    }

    public final void setSpawnHandler(@Nullable Function1<? super Player, Unit> function1) {
        this.spawnHandler = function1;
    }

    @Nullable
    public final Function1<Player, Unit> getDespawnHandler() {
        return this.despawnHandler;
    }

    public final void setDespawnHandler(@Nullable Function1<? super Player, Unit> function1) {
        this.despawnHandler = function1;
    }

    public final void register() {
        if (!this.registered) {
            FakeEntityManager.INSTANCE.addEntity(this.chunk, this);
            this.registered = true;
        } else {
            NovaBootstrapperKt.getLOGGER().warn("Duplicate FakeEntity registration", (Throwable)new Exception());
        }
    }

    public final void remove() {
        if (this.registered) {
            this.registered = false;
            FakeEntityManager.INSTANCE.removeEntity(this.chunk, this);
        }
    }

    public final void spawn(@NotNull Player player) {
        block7: {
            boolean bl;
            net.minecraft.world.item.ItemStack[] $this$all$iv;
            FriendlyByteBuf dataBuf;
            FriendlyByteBuf spawnBuf;
            block6: {
                int n;
                FriendlyByteBuf friendlyByteBuf;
                FriendlyByteBuf it;
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                FriendlyByteBuf friendlyByteBuf2 = this.spawnBuf;
                if (friendlyByteBuf2 == null) {
                    FriendlyByteBuf friendlyByteBuf3;
                    it = friendlyByteBuf3 = this.createSpawnBuf();
                    boolean bl2 = false;
                    this.spawnBuf = it;
                    friendlyByteBuf2 = spawnBuf = friendlyByteBuf3;
                }
                if ((friendlyByteBuf = this.dataBuf) == null) {
                    FriendlyByteBuf it2 = it = ((Metadata)this.getMetadata()).pack$nova(this.entityId);
                    n = 0;
                    this.dataBuf = it2;
                    friendlyByteBuf = it;
                }
                dataBuf = friendlyByteBuf;
                $this$all$iv = this.equipment;
                boolean $i$f$all = false;
                n = $this$all$iv.length;
                for (int j = 0; j < n; ++j) {
                    net.minecraft.world.item.ItemStack element$iv;
                    net.minecraft.world.item.ItemStack it3 = element$iv = $this$all$iv[j];
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it3, (Object)net.minecraft.world.item.ItemStack.EMPTY)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            if (bl) {
                $this$all$iv = new FriendlyByteBuf[]{spawnBuf, dataBuf};
                PacketManagerKt.send$default(player, (FriendlyByteBuf[])$this$all$iv, false, false, 6, null);
            } else {
                FriendlyByteBuf friendlyByteBuf = this.equipmentBuf;
                if (friendlyByteBuf == null) {
                    FriendlyByteBuf friendlyByteBuf4;
                    FriendlyByteBuf it = friendlyByteBuf4 = this.createEquipmentBuf();
                    boolean bl4 = false;
                    this.equipmentBuf = it;
                    friendlyByteBuf = friendlyByteBuf4;
                }
                FriendlyByteBuf equipmentBuf = friendlyByteBuf;
                FriendlyByteBuf[] friendlyByteBufArray = new FriendlyByteBuf[]{spawnBuf, dataBuf, equipmentBuf};
                PacketManagerKt.send$default(player, friendlyByteBufArray, false, false, 6, null);
            }
            Set<Player> set = this._viewers;
            Intrinsics.checkNotNullExpressionValue(set, (String)"_viewers");
            ((Collection)set).add(player);
            Function1<? super Player, Unit> function1 = this.spawnHandler;
            if (function1 == null) break block7;
            function1.invoke((Object)player);
        }
    }

    public final void despawn(@NotNull Player player) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            FriendlyByteBuf[] friendlyByteBufArray = new FriendlyByteBuf[]{this.despawnBuf};
            PacketManagerKt.send$default(player, friendlyByteBufArray, false, false, 6, null);
            Set<Player> set = this._viewers;
            Intrinsics.checkNotNullExpressionValue(set, (String)"_viewers");
            ((Collection)set).remove(player);
            Function1<? super Player, Unit> function1 = this.despawnHandler;
            if (function1 == null) break block0;
            function1.invoke((Object)player);
        }
    }

    public final void updateEntityData(boolean sendPacket, @NotNull Function1<? super M, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        FriendlyByteBuf friendlyByteBuf = this.dataBuf;
        if (friendlyByteBuf != null) {
            friendlyByteBuf.release();
        }
        this.dataBuf = null;
        update.invoke(this.getMetadata());
        if (sendPacket) {
            FriendlyByteBuf buf = ((Metadata)this.getMetadata()).packDirty$nova(this.entityId);
            Iterable $this$forEach$iv = this.getViewers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                FriendlyByteBuf[] friendlyByteBufArray = new FriendlyByteBuf[]{buf};
                PacketManagerKt.send$default(it, friendlyByteBufArray, false, false, 6, null);
            }
            buf.release();
        }
    }

    public final void setEquipment(@NotNull EquipmentSlot slot, @Nullable ItemStack bukkitStack, boolean sendPacket) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        FriendlyByteBuf friendlyByteBuf = this.equipmentBuf;
        if (friendlyByteBuf != null) {
            friendlyByteBuf.release();
        }
        this.equipmentBuf = null;
        int n = slot.ordinal();
        net.minecraft.world.item.ItemStack itemStack = NMSUtilsKt.unwrap(bukkitStack).copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        this.equipment[n] = PacketItems.getClientSideStack$default(PacketItems.INSTANCE, null, itemStack, false, 4, null);
        if (sendPacket) {
            this.equipmentBuf = this.createEquipmentBuf();
            Iterable $this$forEach$iv = this.getViewers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                FriendlyByteBuf[] friendlyByteBufArray = new FriendlyByteBuf[1];
                Intrinsics.checkNotNull((Object)this.equipmentBuf);
                PacketManagerKt.send$default(it, friendlyByteBufArray, false, false, 6, null);
            }
        }
    }

    public final void teleport(@NotNull Function1<? super Location, Unit> modifyLocation) {
        Intrinsics.checkNotNullParameter(modifyLocation, (String)"modifyLocation");
        Location location = this.getLocation();
        modifyLocation.invoke((Object)location);
        FakeEntity.teleport$default(this, location, false, 2, null);
    }

    public final void teleport(@NotNull Location newLocation, boolean forceTeleport) {
        ChunkPos newChunk;
        Intrinsics.checkNotNullParameter((Object)newLocation, (String)"newLocation");
        FriendlyByteBuf friendlyByteBuf = this.spawnBuf;
        if (friendlyByteBuf != null) {
            friendlyByteBuf.release();
        }
        this.spawnBuf = null;
        Set<Player> viewers = this.getViewers();
        if (Intrinsics.areEqual((Object)newLocation.getWorld(), (Object)this.actualLocation.getWorld()) && !((Collection)viewers).isEmpty()) {
            FriendlyByteBuf buf = null;
            if (!forceTeleport && LocationUtilsKt.positionEquals(this.actualLocation, newLocation)) {
                if (!(newLocation.getYaw() == this.actualLocation.getYaw()) || !(newLocation.getPitch() == this.actualLocation.getPitch())) {
                    buf = this.createRotBuf(newLocation);
                    Location location = newLocation.clone();
                    Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
                    this.actualLocation = location;
                }
            } else if (forceTeleport || this.actualLocation.distance(newLocation) > 8.0) {
                buf = this.createTeleportBuf(newLocation);
                Location location = newLocation.clone();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
                this.actualLocation = location;
            } else {
                short deltaX = MathUtilsKt.toFixedPoint(newLocation.getX() - this.actualLocation.getX());
                short deltaY = MathUtilsKt.toFixedPoint(newLocation.getY() - this.actualLocation.getY());
                short deltaZ = MathUtilsKt.toFixedPoint(newLocation.getZ() - this.actualLocation.getZ());
                this.actualLocation.add(MathUtilsKt.fromFixedPoint(deltaX), MathUtilsKt.fromFixedPoint(deltaY), MathUtilsKt.fromFixedPoint(deltaZ));
                if (!(newLocation.getYaw() == this.actualLocation.getYaw()) || !(newLocation.getPitch() == this.actualLocation.getPitch())) {
                    this.actualLocation.setYaw(newLocation.getYaw());
                    this.actualLocation.setPitch(newLocation.getPitch());
                    buf = this.createPosRotBuf(deltaX, deltaY, deltaZ, newLocation.getYaw(), newLocation.getPitch());
                } else {
                    buf = this.createPosBuf(deltaX, deltaY, deltaZ);
                }
            }
            if (buf != null) {
                Iterable $this$forEach$iv = viewers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player it = (Player)element$iv;
                    boolean bl = false;
                    FriendlyByteBuf[] friendlyByteBufArray = new FriendlyByteBuf[]{buf};
                    PacketManagerKt.send$default(it, friendlyByteBufArray, false, false, 6, null);
                }
                buf.release();
            }
        } else {
            Location location = newLocation.clone();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
            this.actualLocation = location;
        }
        Location location = newLocation.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        this.expectedLocation = location;
        ChunkPos previousChunk = this.chunk;
        this.chunk = newChunk = ChunkPosKt.getChunkPos(this.actualLocation);
        if (!Intrinsics.areEqual((Object)previousChunk, (Object)newChunk) && this.registered) {
            FakeEntityManager.INSTANCE.changeEntityChunk(this, previousChunk, newChunk);
        }
    }

    public static /* synthetic */ void teleport$default(FakeEntity fakeEntity, Location location, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: teleport");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        fakeEntity.teleport(location, bl);
    }

    public final void updateLocationSilently$nova(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        FriendlyByteBuf friendlyByteBuf = this.spawnBuf;
        if (friendlyByteBuf != null) {
            friendlyByteBuf.release();
        }
        this.spawnBuf = null;
        ChunkPos previousChunk = this.chunk;
        ChunkPos newChunk = ChunkPosKt.getChunkPos(location);
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        this.expectedLocation = location2;
        Location location3 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"clone(...)");
        this.actualLocation = location3;
        this.chunk = newChunk;
        if (!Intrinsics.areEqual((Object)previousChunk, (Object)newChunk) && this.registered) {
            FakeEntityManager.INSTANCE.changeEntityChunk(this, previousChunk, newChunk);
        }
    }

    private final FriendlyByteBuf createSpawnBuf() {
        RegistryFriendlyByteBuf buf = NMSUtilsKt.RegistryFriendlyByteBuf();
        byte packedYaw = MathUtilsKt.toPackedByte(this.expectedLocation.getYaw());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_ADD_ENTITY());
        buf.writeVarInt(this.entityId);
        buf.writeUUID(this.uuid);
        ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE).encode((Object)buf, this.getEntityType());
        buf.writeDouble(this.getLocation().getX());
        buf.writeDouble(this.getLocation().getY());
        buf.writeDouble(this.getLocation().getZ());
        buf.writeLpVec3(Vec3.ZERO);
        buf.writeByte((int)MathUtilsKt.toPackedByte(this.getLocation().getPitch()));
        buf.writeByte((int)packedYaw);
        buf.writeByte((int)packedYaw);
        buf.writeVarInt(0);
        return (FriendlyByteBuf)buf;
    }

    private final FriendlyByteBuf createDespawnDataBuf() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_REMOVE_ENTITIES());
        int[] nArray = new int[]{this.entityId};
        buf.writeVarIntArray(nArray);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    private final FriendlyByteBuf createEquipmentBuf() {
        RegistryFriendlyByteBuf buf = NMSUtilsKt.RegistryFriendlyByteBuf();
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_SET_EQUIPMENT());
        buf.writeVarInt(this.entityId);
        net.minecraft.world.item.ItemStack[] $this$forEachIndexed$iv = this.equipment;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (net.minecraft.world.item.ItemStack item$iv : $this$forEachIndexed$iv) {
            void item;
            int n = index$iv++;
            net.minecraft.world.item.ItemStack itemStack = item$iv;
            int index = n;
            boolean bl = false;
            buf.writeByte(index != 5 ? index | 0xFFFFFF80 : index);
            net.minecraft.world.item.ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)item);
        }
        return (FriendlyByteBuf)buf;
    }

    private final FriendlyByteBuf createPosBuf(short x, short y, short z) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_MOVE_ENTITY_POS());
        buf.writeVarInt(this.entityId);
        buf.writeShort((int)x);
        buf.writeShort((int)y);
        buf.writeShort((int)z);
        buf.writeBoolean(true);
        return buf;
    }

    private final FriendlyByteBuf createPosRotBuf(short x, short y, short z, float yaw, float pitch) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_MOVE_ENTITY_POS_ROT());
        buf.writeVarInt(this.entityId);
        buf.writeShort((int)x);
        buf.writeShort((int)y);
        buf.writeShort((int)z);
        buf.writeByte((int)MathUtilsKt.toPackedByte(yaw));
        buf.writeByte((int)MathUtilsKt.toPackedByte(pitch));
        buf.writeBoolean(true);
        return buf;
    }

    private final FriendlyByteBuf createRotBuf(Location location) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_MOVE_ENTITY_ROT());
        buf.writeVarInt(this.entityId);
        buf.writeByte((int)MathUtilsKt.toPackedByte(location.getYaw()));
        buf.writeByte((int)MathUtilsKt.toPackedByte(location.getPitch()));
        buf.writeBoolean(true);
        return buf;
    }

    private final FriendlyByteBuf createTeleportBuf(Location location) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(PacketIdRegistry.INSTANCE.getPLAY_CLIENTBOUND_TELEPORT_ENTITY());
        buf.writeVarInt(this.entityId);
        buf.writeDouble(location.getX());
        buf.writeDouble(location.getY());
        buf.writeDouble(location.getZ());
        buf.writeByte((int)MathUtilsKt.toPackedByte(location.getYaw() % (float)360));
        buf.writeByte((int)MathUtilsKt.toPackedByte(location.getPitch()));
        buf.writeBoolean(true);
        return buf;
    }
}

