/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format.chunk;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.format.chunk.NetworkBridgeData;
import xyz.xenondevs.nova.world.format.chunk.NetworkEndPointData;
import xyz.xenondevs.nova.world.format.chunk.NetworkNodeData;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunk;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunkReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B3\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/NetworkChunk;", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "bridges", "", "Lxyz/xenondevs/nova/world/BlockPos;", "Lxyz/xenondevs/nova/world/format/chunk/NetworkBridgeData;", "endPoints", "Lxyz/xenondevs/nova/world/format/chunk/NetworkEndPointData;", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getData", "", "Lxyz/xenondevs/nova/world/format/chunk/NetworkNodeData;", "pos", "getBridgeData", "getEndPointData", "setData", "", "data", "setBridgeData", "setEndPointData", "write", "", "writer", "Lxyz/xenondevs/cbf/io/ByteWriter;", "Companion", "nova"})
public final class NetworkChunk
implements RegionizedChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<BlockPos, NetworkBridgeData> bridges;
    @NotNull
    private final Map<BlockPos, NetworkEndPointData> endPoints;

    public NetworkChunk(@NotNull Map<BlockPos, NetworkBridgeData> bridges, @NotNull Map<BlockPos, NetworkEndPointData> endPoints) {
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(endPoints, (String)"endPoints");
        this.bridges = bridges;
        this.endPoints = endPoints;
    }

    public /* synthetic */ NetworkChunk(Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        if ((n & 2) != 0) {
            map3 = new HashMap();
        }
        this(map2, map3);
    }

    @NotNull
    public final Map<BlockPos, NetworkNodeData> getData() {
        HashMap<BlockPos, NetworkNodeData> map2 = new HashMap<BlockPos, NetworkNodeData>(this.bridges.size() + this.endPoints.size());
        map2.putAll(this.bridges);
        map2.putAll(this.endPoints);
        return map2;
    }

    @Nullable
    public final NetworkNodeData getData(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NetworkBridgeData networkBridgeData = this.bridges.get(pos);
        return networkBridgeData != null ? (NetworkNodeData)networkBridgeData : (NetworkNodeData)this.endPoints.get(pos);
    }

    @Nullable
    public final NetworkBridgeData getBridgeData(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.bridges.get(pos);
    }

    @Nullable
    public final NetworkEndPointData getEndPointData(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.endPoints.get(pos);
    }

    public final void setData(@NotNull BlockPos pos, @Nullable NetworkNodeData data2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        NetworkNodeData networkNodeData = data2;
        if (networkNodeData instanceof NetworkBridgeData) {
            this.bridges.put(pos, (NetworkBridgeData)data2);
            v0 = this.endPoints.remove(pos);
        } else if (networkNodeData instanceof NetworkEndPointData) {
            this.endPoints.put(pos, (NetworkEndPointData)data2);
            v0 = this.endPoints.remove(pos);
        } else {
            this.bridges.remove(pos);
            v0 = this.endPoints.remove(pos);
        }
    }

    public final void setBridgeData(@NotNull BlockPos pos, @Nullable NetworkBridgeData data2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (data2 != null) {
            this.bridges.put(pos, data2);
        } else {
            this.bridges.remove(pos);
        }
    }

    public final void setEndPointData(@NotNull BlockPos pos, @Nullable NetworkEndPointData data2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (data2 != null) {
            this.endPoints.put(pos, data2);
        } else {
            this.endPoints.remove(pos);
        }
    }

    @Override
    public boolean write(@NotNull ByteWriter writer2) {
        BlockPos pos;
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        if (this.bridges.isEmpty() && this.endPoints.isEmpty()) {
            return false;
        }
        writer2.writeVarInt(this.bridges.size());
        for (Map.Entry<BlockPos, NetworkBridgeData> entry : this.bridges.entrySet()) {
            pos = entry.getKey();
            NetworkBridgeData data2 = entry.getValue();
            writer2.writeInt(RegionizedChunk.Companion.packBlockPos(pos));
            data2.write(writer2);
        }
        writer2.writeVarInt(this.endPoints.size());
        for (Map.Entry<BlockPos, NetworkNodeData> entry : this.endPoints.entrySet()) {
            pos = entry.getKey();
            NetworkEndPointData data2 = (NetworkEndPointData)entry.getValue();
            writer2.writeInt(RegionizedChunk.Companion.packBlockPos(pos));
            data2.write(writer2);
        }
        return true;
    }

    public NetworkChunk() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/NetworkChunk$Companion;", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunkReader;", "Lxyz/xenondevs/nova/world/format/chunk/NetworkChunk;", "<init>", "()V", "read", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "createEmpty", "nova"})
    public static final class Companion
    extends RegionizedChunkReader<NetworkChunk> {
        private Companion() {
        }

        @Override
        @NotNull
        public NetworkChunk read(@NotNull ChunkPos pos, @NotNull ByteReader reader) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int bridgeSize = reader.readVarInt();
            HashMap bridges = new HashMap(bridgeSize);
            int n = 0;
            while (n < bridgeSize) {
                int it = n++;
                boolean bl = false;
                BlockPos blockPos = RegionizedChunkReader.Companion.unpackBlockPos(pos, reader.readInt());
                NetworkBridgeData data2 = NetworkBridgeData.Companion.read(reader);
                ((Map)bridges).put(blockPos, data2);
            }
            int endPointSize = reader.readVarInt();
            HashMap endPoints = new HashMap(endPointSize);
            int n2 = 0;
            while (n2 < endPointSize) {
                int it = n2++;
                boolean bl = false;
                BlockPos blockPos = RegionizedChunkReader.Companion.unpackBlockPos(pos, reader.readInt());
                NetworkEndPointData data3 = NetworkEndPointData.Companion.read(reader);
                ((Map)endPoints).put(blockPos, data3);
            }
            return new NetworkChunk(bridges, endPoints);
        }

        @Override
        @NotNull
        public NetworkChunk createEmpty(@NotNull ChunkPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new NetworkChunk(null, null, 3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

