/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format.chunk;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.Cbf;
import xyz.xenondevs.cbf.Compound;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.serialization.DataHolder;
import xyz.xenondevs.nova.util.AsyncExecutor;
import xyz.xenondevs.nova.util.MathUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.concurrent.ThreadUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.block.DefaultBlocks;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.NovaTileEntityBlock;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.block.tileentity.vanilla.VanillaTileEntity;
import xyz.xenondevs.nova.world.format.BlockStateIdResolver;
import xyz.xenondevs.nova.world.format.chunk.RegionChunkKt;
import xyz.xenondevs.nova.world.format.chunk.RegionChunkSection;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunk;
import xyz.xenondevs.nova.world.format.chunk.RegionizedChunkReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 X2\u00020\u0001:\u0001XBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0002J\u0010\u00105\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\nJ\u001a\u00106\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\n2\b\u00107\u001a\u0004\u0018\u00010\u0007J>\u00108\u001a\u00020326\u00109\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(\u0002\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002030:J\u0010\u0010>\u001a\u0004\u0018\u00010&2\u0006\u0010\u0002\u001a\u00020\nJ\f\u0010?\u001a\b\u0012\u0004\u0012\u00020&0@J\u0016\u0010A\u001a\u0002032\u0006\u0010\u0002\u001a\u00020\n2\u0006\u0010B\u001a\u00020\u000bJ\u001a\u0010C\u001a\u0004\u0018\u00010&2\u0006\u0010\u0002\u001a\u00020\n2\b\u0010D\u001a\u0004\u0018\u00010&J\u0010\u0010E\u001a\u0004\u0018\u00010(2\u0006\u0010\u0002\u001a\u00020\nJ\f\u0010F\u001a\b\u0012\u0004\u0012\u00020(0@J\u001a\u0010G\u001a\u0004\u0018\u00010(2\u0006\u0010\u0002\u001a\u00020\n2\b\u0010H\u001a\u0004\u0018\u00010(J\u0018\u0010I\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010J\u001a\u00020!H\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u0010J\u001a\u00020!H\u0002J\u0006\u0010L\u001a\u000203J\u0006\u0010M\u001a\u000203J\b\u0010N\u001a\u000203H\u0002J\u0006\u0010O\u001a\u000203J\u0006\u0010P\u001a\u000203J\b\u0010Q\u001a\u000203H\u0002J\b\u0010R\u001a\u000203H\u0002J\u000e\u0010S\u001a\u000203H\u0086@\u00a2\u0006\u0002\u0010TJ\b\u0010-\u001a\u000203H\u0002J\u0010\u0010U\u001a\u00020\u00152\u0006\u0010V\u001a\u00020WH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020&0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020(0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/RegionChunk;", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunk;", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "sections", "", "Lxyz/xenondevs/nova/world/format/chunk/RegionChunkSection;", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "vanillaTileEntityData", "", "Lxyz/xenondevs/nova/world/BlockPos;", "Lxyz/xenondevs/cbf/Compound;", "tileEntityData", "<init>", "(Lxyz/xenondevs/nova/world/ChunkPos;[Lxyz/xenondevs/nova/world/format/chunk/RegionChunkSection;Ljava/util/Map;Ljava/util/Map;)V", "getPos", "()Lxyz/xenondevs/nova/world/ChunkPos;", "[Lxyz/xenondevs/nova/world/format/chunk/RegionChunkSection;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "value", "", "isEnabled", "()Z", "hasBeenEnabled", "getHasBeenEnabled", "tickingAllowed", "isTicking", "world", "Lorg/bukkit/World;", "level", "Lnet/minecraft/server/level/ServerLevel;", "minHeight", "", "maxHeight", "minSection", "maxSection", "vanillaTileEntities", "Lxyz/xenondevs/nova/world/block/tileentity/vanilla/VanillaTileEntity;", "tileEntities", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "randomTickBlockCounts", "", "randomTickBlockCount", "tickingTileEntityCount", "tick", "coroutineSupervisor", "Lkotlinx/coroutines/Job;", "tickTask", "Lorg/bukkit/scheduler/BukkitTask;", "initVanillaTileEntities", "", "initNovaTileEntities", "getBlockState", "setBlockState", "state", "forEachNonEmpty", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "blockState", "getVanillaTileEntity", "getVanillaTileEntities", "", "setVanillaTileEntityData", "data", "setVanillaTileEntity", "vte", "getTileEntity", "getTileEntities", "setTileEntity", "tileEntity", "getSection", "y", "getSectionIndex", "enable", "disable", "reconsiderTicking", "allowTicking", "disallowTicking", "startTicking", "stopTicking", "awaitShutdown", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "write", "writer", "Lxyz/xenondevs/cbf/io/ByteWriter;", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nRegionChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionChunk.kt\nxyz/xenondevs/nova/world/format/chunk/RegionChunk\n+ 2 Arrays.kt\nxyz/xenondevs/commons/collections/ArraysKt\n+ 3 RegionChunkSection.kt\nxyz/xenondevs/nova/world/format/chunk/RegionChunkSection\n+ 4 Compound.kt\nxyz/xenondevs/cbf/Compound\n+ 5 Maps.kt\nxyz/xenondevs/commons/collections/MapsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,663:1\n53#2:664\n37#3,3:665\n358#4:668\n148#5,7:669\n12767#6,2:676\n1869#7,2:678\n1869#7,2:680\n*S KotlinDebug\n*F\n+ 1 RegionChunk.kt\nxyz/xenondevs/nova/world/format/chunk/RegionChunk\n*L\n70#1:664\n70#1:665,3\n89#1:668\n343#1:669,7\n575#1:676,2\n591#1:678,2\n592#1:680,2\n*E\n"})
public final class RegionChunk
implements RegionizedChunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChunkPos pos;
    @NotNull
    private final RegionChunkSection<NovaBlockState>[] sections;
    @NotNull
    private final Map<BlockPos, Compound> vanillaTileEntityData;
    @NotNull
    private final Map<BlockPos, Compound> tileEntityData;
    @NotNull
    private final ReentrantLock lock;
    private volatile boolean isEnabled;
    private volatile boolean hasBeenEnabled;
    private boolean tickingAllowed;
    private boolean isTicking;
    @NotNull
    private final World world;
    @NotNull
    private final ServerLevel level;
    private final int minHeight;
    private final int maxHeight;
    private final int minSection;
    private final int maxSection;
    @NotNull
    private final Map<BlockPos, VanillaTileEntity> vanillaTileEntities;
    @NotNull
    private final Map<BlockPos, TileEntity> tileEntities;
    @NotNull
    private int[] randomTickBlockCounts;
    private int randomTickBlockCount;
    private int tickingTileEntityCount;
    private int tick;
    @Nullable
    private Job coroutineSupervisor;
    @Nullable
    private BukkitTask tickTask;

    /*
     * WARNING - void declaration
     */
    public RegionChunk(@NotNull ChunkPos pos, @NotNull RegionChunkSection<NovaBlockState>[] sections, @NotNull Map<BlockPos, Compound> vanillaTileEntityData, @NotNull Map<BlockPos, Compound> tileEntityData) {
        void $this$mapToIntArray$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(sections, (String)"sections");
        Intrinsics.checkNotNullParameter(vanillaTileEntityData, (String)"vanillaTileEntityData");
        Intrinsics.checkNotNullParameter(tileEntityData, (String)"tileEntityData");
        this.pos = pos;
        this.sections = sections;
        this.vanillaTileEntityData = vanillaTileEntityData;
        this.tileEntityData = tileEntityData;
        this.lock = new ReentrantLock();
        World world = this.pos.getWorld();
        Intrinsics.checkNotNull((Object)world);
        this.world = world;
        this.level = NMSUtilsKt.getServerLevel(this.world);
        this.minHeight = this.world.getMinHeight();
        this.maxHeight = this.world.getMaxHeight();
        this.minSection = this.minHeight >> 4;
        this.maxSection = this.maxHeight >> 4;
        this.vanillaTileEntities = new HashMap();
        this.tileEntities = new ConcurrentHashMap();
        RegionChunkSection<NovaBlockState>[] regionChunkSectionArray = this.sections;
        RegionChunk regionChunk2 = this;
        boolean $i$f$mapToIntArray = false;
        int n = 0;
        int n2 = ((void)$this$mapToIntArray$iv).length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            void it;
            int n4 = n++;
            void var11_12 = $this$mapToIntArray$iv[n4];
            int n5 = n4;
            int[] nArray2 = nArray;
            boolean bl = false;
            void this_$iv = it;
            boolean $i$f$countNonEmpty = false;
            Ref.IntRef i$iv = new Ref.IntRef();
            this_$iv.getContainer().forEachNonEmpty((Function4)new Function4<Integer, Integer, Integer, T, Unit>(i$iv){
                final /* synthetic */ Ref.IntRef $i;
                {
                    this.$i = $i;
                }

                public final void invoke(int n, int n2, int n3, T value) {
                    NovaBlockState state = (NovaBlockState)value;
                    boolean bl = false;
                    if (state.getTicksRandomly$nova()) {
                        int n4 = this.$i.element;
                        this.$i.element = n4 + 1;
                    }
                }
            });
            nArray2[n5] = n3 = i$iv.element;
        }
        regionChunk2.randomTickBlockCounts = nArray;
        this.randomTickBlockCount = ArraysKt.sum((int[])this.randomTickBlockCounts);
        this.initVanillaTileEntities();
        this.initNovaTileEntities();
    }

    public /* synthetic */ RegionChunk(ChunkPos chunkPos, RegionChunkSection[] regionChunkSectionArray, Map map2, Map map3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            int n2 = 0;
            World world = chunkPos.getWorld();
            Intrinsics.checkNotNull((Object)world);
            int n3 = RegionChunk.Companion.getSectionCount(world);
            RegionChunkSection[] regionChunkSectionArray2 = new RegionChunkSection[n3];
            while (n2 < n3) {
                int n4 = n2++;
                regionChunkSectionArray2[n4] = new RegionChunkSection(BlockStateIdResolver.INSTANCE);
            }
            regionChunkSectionArray = regionChunkSectionArray2;
        }
        if ((n & 4) != 0) {
            map2 = new HashMap();
        }
        if ((n & 8) != 0) {
            map3 = new HashMap();
        }
        this(chunkPos, regionChunkSectionArray, map2, map3);
    }

    @NotNull
    public final ChunkPos getPos() {
        return this.pos;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean getHasBeenEnabled() {
        return this.hasBeenEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private final void initVanillaTileEntities() {
        for (Map.Entry<BlockPos, Compound> entry : this.vanillaTileEntityData.entrySet()) {
            BlockPos pos = entry.getKey();
            Compound data2 = entry.getValue();
            try {
                void this_$iv;
                Compound compound = data2;
                String key$iv = "type";
                boolean $i$f$get = false;
                VanillaTileEntity.Type type = (VanillaTileEntity.Type)((Object)this_$iv.get(KTypes.withNullability((KType)Reflection.typeOf(VanillaTileEntity.Type.class), (boolean)true), key$iv));
                if (type == null) continue;
                this.vanillaTileEntities.put(pos, type.create(pos, data2));
            }
            catch (Throwable t) {
                NovaBootstrapperKt.getLOGGER().error("Failed to initialize vanilla tile entity pos=" + pos + ", data=" + data2, t);
            }
        }
    }

    private final void initNovaTileEntities() {
        for (Map.Entry<BlockPos, Compound> entry : this.tileEntityData.entrySet()) {
            NovaTileEntityBlock block;
            BlockPos pos = entry.getKey();
            Compound data2 = entry.getValue();
            NovaBlockState blockState = this.getBlockState(pos);
            if (blockState == null) {
                NovaBootstrapperKt.getLOGGER().error("Failed to initialize tile entity at " + pos + " because there is no block state");
                return;
            }
            NovaBlock novaBlock = blockState.getBlock();
            NovaTileEntityBlock novaTileEntityBlock = block = novaBlock instanceof NovaTileEntityBlock ? (NovaTileEntityBlock)novaBlock : null;
            if (Intrinsics.areEqual((Object)blockState.getBlock(), (Object)DefaultBlocks.INSTANCE.getUNKNOWN())) continue;
            if (block == null) {
                NovaBootstrapperKt.getLOGGER().error("Failed to initialize tile entity at " + pos + " because " + blockState.getBlock() + " is not a tile entity type");
                return;
            }
            try {
                this.tileEntities.put(pos, (TileEntity)block.getTileEntityConstructor$nova().invoke((Object)pos, (Object)blockState, (Object)data2));
                if (block.getTickrate() <= 0) continue;
                int n = this.tickingTileEntityCount;
                this.tickingTileEntityCount = n + 1;
            }
            catch (Throwable t) {
                NovaBootstrapperKt.getLOGGER().error("Failed to initialize tile entity pos=" + pos + ", blockState=" + blockState + ", data=" + data2, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final NovaBlockState getBlockState(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            RegionChunkSection<NovaBlockState> regionChunkSection = this.getSection(pos.getY());
            NovaBlockState novaBlockState = regionChunkSection != null ? regionChunkSection.get(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF) : null;
            return novaBlockState;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final NovaBlockState setBlockState(@NotNull BlockPos pos, @Nullable NovaBlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            int n;
            int n2;
            int[] nArray;
            RegionChunkSection regionChunkSection;
            boolean bl = false;
            int sectionIdx = this.getSectionIndex(pos.getY());
            if ((RegionChunkSection)ArraysKt.getOrNull((Object[])this.sections, (int)sectionIdx) == null) {
                NovaBlockState novaBlockState = null;
                return novaBlockState;
            }
            RegionChunkSection section = regionChunkSection;
            NovaBlockState previous = section.set(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF, state);
            if (previous != null && previous.getTicksRandomly$nova()) {
                nArray = this.randomTickBlockCounts;
                n2 = nArray[sectionIdx];
                nArray[sectionIdx] = n2 + -1;
                n = this.randomTickBlockCount;
                this.randomTickBlockCount = n + -1;
            }
            if (state != null) {
                if (state.getTicksRandomly$nova()) {
                    nArray = this.randomTickBlockCounts;
                    n2 = nArray[sectionIdx];
                    nArray[sectionIdx] = n2 + 1;
                    n = this.randomTickBlockCount;
                    this.randomTickBlockCount = n + 1;
                }
                TileEntity tileEntity = this.tileEntities.get(pos);
                if (tileEntity != null) {
                    tileEntity.setBlockState$nova(state);
                }
            }
            this.reconsiderTicking();
            NovaBlockState novaBlockState = previous;
            return novaBlockState;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachNonEmpty(@NotNull Function2<? super BlockPos, ? super NovaBlockState, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            RegionChunkSection<NovaBlockState>[] regionChunkSectionArray = this.sections;
            int n = regionChunkSectionArray.length;
            for (int j = 0; j < n; ++j) {
                int idx = j;
                RegionChunkSection<NovaBlockState> section = regionChunkSectionArray[j];
                if (section.isEmpty()) continue;
                int bottomY = (idx << 4) + this.minHeight;
                section.getContainer().forEachNonEmpty((Function4<Integer, Integer, Integer, NovaBlockState, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> RegionChunk.forEachNonEmpty$lambda$0$0(action, this, bottomY, arg_0, arg_1, arg_2, arg_3)));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VanillaTileEntity getVanillaTileEntity(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            VanillaTileEntity vanillaTileEntity = this.vanillaTileEntities.get(pos);
            return vanillaTileEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<VanillaTileEntity> getVanillaTileEntities() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            List list = new ArrayList<VanillaTileEntity>(this.vanillaTileEntities.values());
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVanillaTileEntityData(@NotNull BlockPos pos, @NotNull Compound data2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.vanillaTileEntityData.put(pos, data2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final VanillaTileEntity setVanillaTileEntity(@NotNull BlockPos pos, @Nullable VanillaTileEntity vte) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            VanillaTileEntity previous = null;
            if (vte == null) {
                previous = this.vanillaTileEntities.remove(pos);
                this.vanillaTileEntityData.remove(pos);
            } else {
                previous = this.vanillaTileEntities.put(pos, vte);
                this.vanillaTileEntityData.put(pos, vte.getData$nova());
                if (this.isEnabled) {
                    try {
                        vte.handleEnable();
                    }
                    catch (Throwable t) {
                        NovaBootstrapperKt.getLOGGER().error("Failed to enable vanilla tile-entity " + vte, t);
                    }
                }
            }
            try {
                VanillaTileEntity vanillaTileEntity = previous;
                if (vanillaTileEntity != null) {
                    vanillaTileEntity.handleDisable();
                }
            }
            catch (Throwable t) {
                NovaBootstrapperKt.getLOGGER().error("Failed to disable vanilla tile-entity " + previous, t);
            }
            VanillaTileEntity vanillaTileEntity = previous;
            return vanillaTileEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TileEntity getTileEntity(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TileEntity tileEntity = this.tileEntities.get(pos);
            return tileEntity;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<TileEntity> getTileEntities() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            List list = CollectionsKt.toList((Iterable)this.tileEntities.values());
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TileEntity setTileEntity(@NotNull BlockPos pos, @Nullable TileEntity tileEntity) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TileEntity previous = null;
            if (tileEntity == null) {
                previous = this.tileEntities.remove(pos);
                this.tileEntityData.remove(pos);
            } else {
                previous = this.tileEntities.put(pos, tileEntity);
                this.tileEntityData.put(pos, tileEntity.getData$nova());
                if (this.isEnabled) {
                    tileEntity.setEnabled$nova(true);
                    try {
                        tileEntity.handleEnable();
                    }
                    catch (Throwable t) {
                        NovaBootstrapperKt.getLOGGER().error("Failed to enable tile-entity " + tileEntity, t);
                    }
                }
                if (tileEntity.getBlock().getTickrate() > 0) {
                    int t = this.tickingTileEntityCount;
                    this.tickingTileEntityCount = t + 1;
                    if (this.isTicking) {
                        try {
                            tileEntity.setCoroutineSupervisor$nova((Job)SupervisorKt.SupervisorJob((Job)this.coroutineSupervisor));
                            tileEntity.handleEnableTicking();
                        }
                        catch (Throwable t2) {
                            NovaBootstrapperKt.getLOGGER().error("Failed to enable ticking for " + tileEntity, t2);
                        }
                    }
                }
            }
            if (previous != null) {
                if (previous.getBlock().getTickrate() > 0) {
                    int t2 = this.tickingTileEntityCount;
                    this.tickingTileEntityCount = t2 + -1;
                    if (this.isTicking) {
                        try {
                            previous.handleDisableTicking();
                        }
                        catch (Throwable t) {
                            NovaBootstrapperKt.getLOGGER().error("Failed to disable ticking for " + tileEntity, t);
                        }
                    }
                }
                try {
                    previous.handleDisable();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to disable tile-entity " + previous, t);
                }
                previous.setEnabled$nova(false);
            }
            this.reconsiderTicking();
            TileEntity tileEntity2 = previous;
            return tileEntity2;
        }
        finally {
            lock.unlock();
        }
    }

    private final RegionChunkSection<NovaBlockState> getSection(int y) {
        return (RegionChunkSection)ArraysKt.getOrNull((Object[])this.sections, (int)this.getSectionIndex(y));
    }

    private final int getSectionIndex(int y) {
        return y - this.minHeight >> 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enable() {
        ThreadUtilsKt.checkServerThread();
        Lock lock = this.lock;
        lock.lock();
        try {
            Object vteType;
            boolean bl = false;
            if (this.isEnabled) {
                return;
            }
            for (Map.Entry<BlockPos, Compound> entry : this.vanillaTileEntityData.entrySet()) {
                BlockPos pos = entry.getKey();
                Compound vteData = entry.getValue();
                if (this.vanillaTileEntities.containsKey(pos)) continue;
                Material material = pos.getBlock().getType();
                Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
                vteType = VanillaTileEntity.Type.Companion.of(material);
                if (vteType != null) {
                    this.vanillaTileEntities.put(pos, ((VanillaTileEntity.Type)((Object)vteType)).create(pos, vteData));
                    continue;
                }
                this.vanillaTileEntityData.remove(pos);
            }
            Map<BlockPos, VanillaTileEntity> $this$removeIf$iv = this.vanillaTileEntities;
            int $i$f$removeIf = 0;
            Iterator<Map.Entry<BlockPos, VanillaTileEntity>> iterator$iv22 = $this$removeIf$iv.entrySet().iterator();
            while (iterator$iv22.hasNext()) {
                boolean invalid;
                Map.Entry<BlockPos, VanillaTileEntity> entry$iv = iterator$iv22.next();
                vteType = entry$iv;
                boolean bl2 = false;
                BlockPos pos = vteType.getKey();
                VanillaTileEntity vte = vteType.getValue();
                boolean bl3 = invalid = !vte.getType().getMaterials().contains(pos.getBlock().getType());
                if (invalid) {
                    this.vanillaTileEntityData.remove(pos);
                }
                if (!invalid) continue;
                iterator$iv22.remove();
            }
            RegionChunkSection<NovaBlockState>[] regionChunkSectionArray = this.sections;
            int iterator$iv22 = regionChunkSectionArray.length;
            for ($i$f$removeIf = 0; $i$f$removeIf < iterator$iv22; ++$i$f$removeIf) {
                int i2 = $i$f$removeIf;
                RegionChunkSection<NovaBlockState> section = regionChunkSectionArray[$i$f$removeIf];
                int sectionY = this.minHeight + (i2 << 4);
                section.forEachNonEmpty((Function4<Integer, Integer, Integer, NovaBlockState, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> RegionChunk.enable$lambda$0$1(this, sectionY, arg_0, arg_1, arg_2, arg_3)));
            }
            for (TileEntity tileEntity : this.tileEntities.values()) {
                tileEntity.setEnabled$nova(true);
                try {
                    tileEntity.handleEnable();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to enable tile-entity " + tileEntity, t);
                }
            }
            for (VanillaTileEntity vte : this.vanillaTileEntities.values()) {
                try {
                    vte.handleEnable();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to enable vanilla tile-entity " + vte, t);
                }
            }
            this.hasBeenEnabled = true;
            this.isEnabled = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disable() {
        ThreadUtilsKt.checkServerThread();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.isEnabled) {
                return;
            }
            if (this.isTicking) {
                this.stopTicking();
            }
            Object object = this.sections;
            int n = ((RegionChunkSection<NovaBlockState>[])object).length;
            for (int j = 0; j < n; ++j) {
                int i2 = j;
                RegionChunkSection<NovaBlockState> section = object[j];
                int sectionY = this.minHeight + (i2 << 4);
                section.forEachNonEmpty((Function4<Integer, Integer, Integer, NovaBlockState, Unit>)((Function4)(arg_0, arg_1, arg_2, arg_3) -> RegionChunk.disable$lambda$0$0(this, sectionY, arg_0, arg_1, arg_2, arg_3)));
            }
            object = this.tileEntities.entrySet().iterator();
            while (object.hasNext()) {
                TileEntity tileEntity = (TileEntity)((Map.Entry)object.next()).getValue();
                tileEntity.setEnabled$nova(false);
                try {
                    tileEntity.handleDisable();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to disable tile-entity " + tileEntity, t);
                }
            }
            for (VanillaTileEntity vte : this.vanillaTileEntities.values()) {
                try {
                    vte.handleDisable();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to disable vanilla tile-entity " + vte, t);
                }
            }
            this.isEnabled = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reconsiderTicking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isTicking) {
                if (!this.tickingAllowed || this.randomTickBlockCount == 0 && this.tickingTileEntityCount == 0) {
                    this.stopTicking();
                }
            } else if (this.tickingAllowed && (this.randomTickBlockCount > 0 || this.tickingTileEntityCount > 0)) {
                this.startTicking();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void allowTicking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.tickingAllowed = true;
            this.reconsiderTicking();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disallowTicking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.tickingAllowed = false;
            this.reconsiderTicking();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startTicking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.isTicking) {
                return;
            }
            this.tickTask = SchedulerUtilsKt.runTaskTimer(0L, 1L, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    RegionChunk.access$tick((RegionChunk)this.receiver);
                }
            }));
            CompletableJob chunkSupervisor = SupervisorKt.SupervisorJob((Job)((Job)AsyncExecutor.INSTANCE.getSUPERVISOR()));
            this.coroutineSupervisor = (Job)chunkSupervisor;
            Iterator<Map.Entry<BlockPos, TileEntity>> iterator = this.tileEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                TileEntity tileEntity = iterator.next().getValue();
                if (tileEntity.getBlock().getTickrate() <= 0) continue;
                try {
                    tileEntity.setCoroutineSupervisor$nova((Job)SupervisorKt.SupervisorJob((Job)((Job)chunkSupervisor)));
                    tileEntity.handleEnableTicking();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to enable ticking for " + tileEntity, t);
                }
            }
            this.isTicking = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTicking() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!this.isTicking) {
                return;
            }
            BukkitTask bukkitTask = this.tickTask;
            if (bukkitTask != null) {
                bukkitTask.cancel();
            }
            this.tickTask = null;
            Job job2 = this.coroutineSupervisor;
            if (job2 != null) {
                JobKt.cancel$default((Job)job2, (String)"Ticking disabled", null, (int)2, null);
            }
            Iterator<Map.Entry<BlockPos, TileEntity>> iterator = this.tileEntities.entrySet().iterator();
            while (iterator.hasNext()) {
                TileEntity tileEntity = iterator.next().getValue();
                if (tileEntity.getBlock().getTickrate() <= 0) continue;
                try {
                    tileEntity.handleDisableTicking();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to disable ticking for " + tileEntity, t);
                }
            }
            this.isTicking = false;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public final Object awaitShutdown(@NotNull Continuation<? super Unit> $completion) {
        Job job2 = this.coroutineSupervisor;
        if (job2 != null) {
            Object object = job2.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tick() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            int n = this.tick;
            this.tick = n + 1;
            for (TileEntity tileEntity : this.tileEntities.values()) {
                int interval;
                int tickRate = tileEntity.getBlock().getTickrate();
                if (tickRate == 0 || (interval = 20 - tickRate) != 0 && this.tick % interval != 0) continue;
                try {
                    if (!tileEntity.isEnabled()) continue;
                    tileEntity.handleTick();
                }
                catch (Throwable t) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred while ticking tile entity " + tileEntity, t);
                }
            }
            if (this.randomTickBlockCount == 0) {
                return;
            }
            int randomTickSpeed = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
            if (randomTickSpeed > 0) {
                RegionChunkSection<NovaBlockState>[] regionChunkSectionArray = this.sections;
                int n2 = regionChunkSectionArray.length;
                for (int j = 0; j < n2; ++j) {
                    int sectionIdx = j;
                    RegionChunkSection<NovaBlockState> section = regionChunkSectionArray[j];
                    if (this.randomTickBlockCounts[sectionIdx] <= 0) continue;
                    for (int k = 0; k < randomTickSpeed; ++k) {
                        int z;
                        int y;
                        int it = k;
                        boolean bl2 = false;
                        int rand = Random.Default.nextInt();
                        int x = rand >> 8 & 0xF;
                        NovaBlockState blockState = section.get(x, y = rand >> 4 & 0xF, z = rand & 0xF);
                        if (blockState == null || !blockState.getTicksRandomly$nova()) continue;
                        BlockPos pos = new BlockPos(this.world, (this.pos.getX() << 4) + x, (sectionIdx << 4) + this.minHeight + y, (this.pos.getZ() << 4) + z);
                        try {
                            blockState.getBlock().handleRandomTick(pos, blockState);
                            continue;
                        }
                        catch (Throwable t) {
                            NovaBootstrapperKt.getLOGGER().error("An exception occurred while ticking block " + blockState + " at " + pos, t);
                        }
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean write(@NotNull ByteWriter writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        Lock lock = this.lock;
        lock.lock();
        try {
            BlockPos pos;
            DataHolder p0;
            void entry;
            boolean bl = false;
            if (this.vanillaTileEntityData.isEmpty() && this.tileEntityData.isEmpty()) {
                boolean bl2;
                block12: {
                    RegionChunkSection<NovaBlockState>[] $this$all$iv = this.sections;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int j = 0; j < n; ++j) {
                        RegionChunkSection<NovaBlockState> regionChunkSection;
                        RegionChunkSection<NovaBlockState> it = regionChunkSection = $this$all$iv[j];
                        boolean bl3 = false;
                        if (it.isEmpty()) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            writer2.writeInt(this.minSection);
            writer2.writeInt(this.maxSection);
            BitSet sectionBitmask = new BitSet(this.sections.length);
            ByteArrayOutputStream sectionsBuffer = new ByteArrayOutputStream();
            ByteWriter sectionsWriter = ByteWriter.Companion.fromStream((OutputStream)sectionsBuffer);
            Object object = this.sections;
            boolean bl4 = false;
            int it = ((RegionChunkSection<NovaBlockState>[])object).length;
            while (entry < it) {
                void sectionIdx = entry;
                RegionChunkSection<NovaBlockState> section = object[entry];
                sectionBitmask.set((int)sectionIdx, section.write(sectionsWriter));
                ++entry;
            }
            byte[] byArray = sectionBitmask.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            object = byArray;
            int entry2 = MathUtilsKt.ceilDiv(this.sections.length, 8);
            byte[] byArray2 = Arrays.copyOf(object, entry2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            writer2.writeBytes(byArray2);
            byte[] byArray3 = sectionsBuffer.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
            writer2.writeBytes(byArray3);
            Iterable $this$forEach$iv = this.vanillaTileEntities.values();
            boolean bl5 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                p0 = (VanillaTileEntity)element$iv3;
                boolean bl52 = false;
                ((VanillaTileEntity)p0).saveData();
            }
            $this$forEach$iv = this.tileEntities.values();
            boolean bl6 = false;
            for (Object element$iv4 : $this$forEach$iv) {
                p0 = (TileEntity)element$iv4;
                boolean bl62 = false;
                ((TileEntity)p0).saveData();
            }
            writer2.writeVarInt(this.vanillaTileEntityData.size());
            for (Map.Entry entry3 : this.vanillaTileEntityData.entrySet()) {
                pos = (BlockPos)entry3.getKey();
                Compound data2 = (Compound)entry3.getValue();
                writer2.writeInt(RegionizedChunk.Companion.packBlockPos(pos));
                RegionChunkKt.access$getCOMPOUND_SERIALIZER$p().write((Object)data2, writer2);
            }
            writer2.writeVarInt(this.tileEntityData.size());
            for (Map.Entry entry4 : this.tileEntityData.entrySet()) {
                pos = (BlockPos)entry4.getKey();
                Compound data3 = (Compound)entry4.getValue();
                writer2.writeInt(RegionizedChunk.Companion.packBlockPos(pos));
                RegionChunkKt.access$getCOMPOUND_SERIALIZER$p().write((Object)data3, writer2);
            }
            boolean bl7 = true;
            return bl7;
        }
        finally {
            lock.unlock();
        }
    }

    private static final Unit forEachNonEmpty$lambda$0$0(Function2 $action, RegionChunk this$0, int $bottomY, int x, int y, int z, NovaBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        $action.invoke((Object)this$0.pos.blockPos(x, $bottomY + y, z), (Object)blockState);
        return Unit.INSTANCE;
    }

    private static final Unit enable$lambda$0$1(RegionChunk this$0, int $sectionY, int x, int y, int z, NovaBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockPos pos = this$0.pos.blockPos(x, $sectionY + y, z);
        try {
            blockState.getModelProvider$nova().load(pos);
        }
        catch (Throwable t) {
            NovaBootstrapperKt.getLOGGER().error("Failed to load model provider for " + blockState + " at " + pos, t);
        }
        return Unit.INSTANCE;
    }

    private static final Unit disable$lambda$0$0(RegionChunk this$0, int $sectionY, int x, int y, int z, NovaBlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockPos pos = this$0.pos.blockPos(x, $sectionY + y, z);
        try {
            blockState.getModelProvider$nova().unload(pos);
        }
        catch (Throwable t) {
            NovaBootstrapperKt.getLOGGER().error("Failed to unload model provider for " + blockState + " at " + pos, t);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$tick(RegionChunk $this) {
        $this.tick();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/RegionChunk$Companion;", "Lxyz/xenondevs/nova/world/format/chunk/RegionizedChunkReader;", "Lxyz/xenondevs/nova/world/format/chunk/RegionChunk;", "<init>", "()V", "read", "pos", "Lxyz/xenondevs/nova/world/ChunkPos;", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "readPosCompoundMap", "Ljava/util/HashMap;", "Lxyz/xenondevs/nova/world/BlockPos;", "Lxyz/xenondevs/cbf/Compound;", "chunkPos", "createEmpty", "getSectionCount", "", "world", "Lorg/bukkit/World;", "nova"})
    @SourceDebugExtension(value={"SMAP\nRegionChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionChunk.kt\nxyz/xenondevs/nova/world/format/chunk/RegionChunk$Companion\n+ 2 CosmicBinaryFormat.kt\nxyz/xenondevs/cbf/Cbf\n*L\n1#1,663:1\n136#2:664\n247#2:665\n*S KotlinDebug\n*F\n+ 1 RegionChunk.kt\nxyz/xenondevs/nova/world/format/chunk/RegionChunk$Companion\n*L\n648#1:664\n648#1:665\n*E\n"})
    public static final class Companion
    extends RegionizedChunkReader<RegionChunk> {
        private Companion() {
        }

        @Override
        @NotNull
        public RegionChunk read(@NotNull ChunkPos pos, @NotNull ByteReader reader) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int minFileSection = reader.readInt();
            int maxFileSection = reader.readInt();
            int fileSectionCount = maxFileSection - minFileSection;
            BitSet sectionsBitmask = BitSet.valueOf(reader.readBytes(MathUtilsKt.ceilDiv(fileSectionCount, 8)));
            Object[] objectArray = new RegionChunkSection[fileSectionCount];
            for (int j = 0; j < fileSectionCount; ++j) {
                int n = j;
                objectArray[n] = sectionsBitmask.get(n) ? RegionChunkSection.Companion.read(BlockStateIdResolver.INSTANCE, reader) : new RegionChunkSection(BlockStateIdResolver.INSTANCE);
            }
            Object[] fileSections = objectArray;
            World world = pos.getWorld();
            Intrinsics.checkNotNull((Object)world);
            int minWorldSection = world.getMinHeight() >> 4;
            World world2 = pos.getWorld();
            Intrinsics.checkNotNull((Object)world2);
            int maxWorldSection = world2.getMaxHeight() >> 4;
            int worldSectionCount = maxWorldSection - minWorldSection;
            Object[] sections = null;
            if (fileSectionCount != worldSectionCount) {
                int d = minWorldSection - minFileSection;
                RegionChunkSection[] regionChunkSectionArray = new RegionChunkSection[worldSectionCount];
                for (int j = 0; j < worldSectionCount; ++j) {
                    int n = j;
                    RegionChunkSection regionChunkSection = (RegionChunkSection)ArraysKt.getOrNull((Object[])fileSections, (int)(n + d));
                    if (regionChunkSection == null) {
                        regionChunkSection = new RegionChunkSection(BlockStateIdResolver.INSTANCE);
                    }
                    regionChunkSectionArray[n] = regionChunkSection;
                }
                sections = regionChunkSectionArray;
            } else {
                sections = fileSections;
            }
            HashMap<BlockPos, Compound> vanillaTileEntityData = this.readPosCompoundMap(pos, reader);
            HashMap<BlockPos, Compound> tileEntityData = this.readPosCompoundMap(pos, reader);
            return new RegionChunk(pos, (RegionChunkSection<NovaBlockState>[])sections, (Map<BlockPos, Compound>)vanillaTileEntityData, (Map<BlockPos, Compound>)tileEntityData);
        }

        /*
         * WARNING - void declaration
         */
        private final HashMap<BlockPos, Compound> readPosCompoundMap(ChunkPos chunkPos, ByteReader reader) {
            int size = reader.readVarInt();
            HashMap<BlockPos, Compound> map2 = new HashMap<BlockPos, Compound>(size);
            int n = 0;
            while (n < size) {
                void this_$iv;
                int it = n++;
                boolean bl = false;
                BlockPos pos = RegionizedChunkReader.Companion.unpackBlockPos(chunkPos, reader.readInt());
                Cbf cbf = Cbf.INSTANCE;
                ByteReader reader$iv = reader;
                boolean $i$f$read = false;
                void this_$iv$iv = this_$iv;
                boolean $i$f$getSerializer = false;
                Object object = this_$iv$iv.getSerializer(Reflection.typeOf(Compound.class)).read(reader$iv);
                Intrinsics.checkNotNull((Object)object);
                Compound data2 = (Compound)object;
                ((Map)map2).put(pos, data2);
            }
            return map2;
        }

        @Override
        @NotNull
        public RegionChunk createEmpty(@NotNull ChunkPos pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new RegionChunk(pos, null, null, null, 14, null);
        }

        private final int getSectionCount(World world) {
            return world.getMaxHeight() - world.getMinHeight() >> 4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

