/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ChargedProjectiles;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.event.entity.EntityLoadCrossbowEvent;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u0012J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH&J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/CrossbowLogic;", "", "canDraw", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "crossbow", "Lorg/bukkit/inventory/ItemStack;", "getDrawTime", "", "handleDrawTick", "", "tick", "chooseProjectile", "Lio/papermc/paper/datacomponent/item/ChargedProjectiles;", "shoot", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "Vanilla", "nova"})
public interface CrossbowLogic {
    public boolean canDraw(@NotNull LivingEntity var1, @NotNull ItemStack var2);

    public int getDrawTime(@NotNull LivingEntity var1, @NotNull ItemStack var2);

    public void handleDrawTick(@NotNull LivingEntity var1, @NotNull ItemStack var2, int var3);

    @Nullable
    public ChargedProjectiles chooseProjectile(@NotNull LivingEntity var1, @NotNull ItemStack var2);

    @NotNull
    public ItemStack shoot(@NotNull LivingEntity var1, @NotNull EquipmentSlot var2, @NotNull ItemStack var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u001a\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000fH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/CrossbowLogic$Vanilla;", "Lxyz/xenondevs/nova/world/item/behavior/CrossbowLogic;", "<init>", "()V", "crossbowItem", "Lnet/minecraft/world/item/CrossbowItem;", "getCrossbowItem", "()Lnet/minecraft/world/item/CrossbowItem;", "crossbowItem$delegate", "Lkotlin/Lazy;", "canDraw", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "crossbow", "Lorg/bukkit/inventory/ItemStack;", "getDrawTime", "", "handleDrawTick", "", "tick", "chooseProjectile", "Lio/papermc/paper/datacomponent/item/ChargedProjectiles;", "shoot", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "playSoundIfPresent", "optSound", "Ljava/util/Optional;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/sounds/SoundEvent;", "createDummyCrossbow", "novaCrossbow", "nova"})
    @SourceDebugExtension(value={"SMAP\nCrossbow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crossbow.kt\nxyz/xenondevs/nova/world/item/behavior/CrossbowLogic$Vanilla\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
    public static final class Vanilla
    implements CrossbowLogic {
        @NotNull
        public static final Vanilla INSTANCE = new Vanilla();
        @NotNull
        private static final Lazy crossbowItem$delegate = LazyKt.lazy(Vanilla::crossbowItem_delegate$lambda$0);

        private Vanilla() {
        }

        private final CrossbowItem getCrossbowItem() {
            Lazy lazy = crossbowItem$delegate;
            return (CrossbowItem)lazy.getValue();
        }

        @Override
        public boolean canDraw(@NotNull LivingEntity entity, @NotNull ItemStack crossbow) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)crossbow, (String)"crossbow");
            return !NMSUtilsKt.getNmsEntity(entity).getProjectile(NMSUtilsKt.unwrap(this.createDummyCrossbow(crossbow))).isEmpty();
        }

        @Override
        public int getDrawTime(@NotNull LivingEntity entity, @NotNull ItemStack crossbow) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)crossbow, (String)"crossbow");
            return CrossbowItem.getChargeDuration((net.minecraft.world.item.ItemStack)NMSUtilsKt.unwrap(crossbow), (net.minecraft.world.entity.LivingEntity)NMSUtilsKt.getNmsEntity(entity));
        }

        @Override
        public void handleDrawTick(@NotNull LivingEntity entity, @NotNull ItemStack crossbow, int tick2) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)crossbow, (String)"crossbow");
            CrossbowItem.ChargingSounds chargingSounds = this.getCrossbowItem().getChargingSounds(NMSUtilsKt.unwrap(crossbow));
            int chargeTime = this.getDrawTime(entity, crossbow);
            if (tick2 == (int)((double)chargeTime * 0.2)) {
                Optional optional = chargingSounds.start();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"start(...)");
                this.playSoundIfPresent(entity, optional);
            }
            if (tick2 == (int)((double)chargeTime * 0.5)) {
                Optional optional = chargingSounds.mid();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"mid(...)");
                this.playSoundIfPresent(entity, optional);
            }
        }

        @Override
        @Nullable
        public ChargedProjectiles chooseProjectile(@NotNull LivingEntity entity, @NotNull ItemStack crossbow) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)crossbow, (String)"crossbow");
            EntityLoadCrossbowEvent event = new EntityLoadCrossbowEvent(entity, crossbow.clone(), entity.getActiveItemHand());
            if (!event.callEvent()) {
                return null;
            }
            ItemStack itemStack = entity.getActiveItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getActiveItem(...)");
            ItemStack dummyCrossbow = this.createDummyCrossbow(itemStack);
            if (CrossbowItem.tryLoadProjectiles((net.minecraft.world.entity.LivingEntity)NMSUtilsKt.getNmsEntity(entity), (net.minecraft.world.item.ItemStack)NMSUtilsKt.unwrap(dummyCrossbow), (boolean)event.shouldConsumeItem())) {
                CrossbowItem.ChargingSounds chargingSounds = this.getCrossbowItem().getChargingSounds(NMSUtilsKt.unwrap(crossbow));
                Optional optional = chargingSounds.end();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"end(...)");
                this.playSoundIfPresent(entity, optional);
            }
            return (ChargedProjectiles)dummyCrossbow.getData(DataComponentTypes.CHARGED_PROJECTILES);
        }

        @Override
        @NotNull
        public ItemStack shoot(@NotNull LivingEntity entity, @NotNull EquipmentSlot hand, @NotNull ItemStack crossbow) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            Intrinsics.checkNotNullParameter((Object)crossbow, (String)"crossbow");
            net.minecraft.world.item.component.ChargedProjectiles chargedProjectiles = (net.minecraft.world.item.component.ChargedProjectiles)NMSUtilsKt.unwrap(crossbow).get(DataComponents.CHARGED_PROJECTILES);
            if (chargedProjectiles == null) {
                return crossbow;
            }
            net.minecraft.world.item.component.ChargedProjectiles projectile = chargedProjectiles;
            this.getCrossbowItem().performShooting(NMSUtilsKt.getNmsEntity(entity).level(), NMSUtilsKt.getNmsEntity(entity), NMSUtilsKt.getNmsInteractionHand(hand), NMSUtilsKt.unwrap(crossbow), CrossbowItem.getShootingPower((net.minecraft.world.item.component.ChargedProjectiles)projectile), 1.0f, null);
            return crossbow;
        }

        private final void playSoundIfPresent(LivingEntity entity, Optional<Holder<SoundEvent>> optSound) {
            Holder holder2 = (Holder)OptionalsKt.getOrNull(optSound);
            if (holder2 == null) {
                return;
            }
            Holder sound = holder2;
            World world = entity.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            NMSUtilsKt.getServerLevel(world).playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)sound.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }

        private final ItemStack createDummyCrossbow(ItemStack novaCrossbow) {
            ItemStack dummyCrossbow;
            block0: {
                ItemStack itemStack = ItemStack.of((Material)Material.CROSSBOW);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"of(...)");
                dummyCrossbow = itemStack;
                ItemEnchantments itemEnchantments = (ItemEnchantments)novaCrossbow.getData(DataComponentTypes.ENCHANTMENTS);
                if (itemEnchantments == null) break block0;
                ItemEnchantments it = itemEnchantments;
                boolean bl = false;
                dummyCrossbow.setData(DataComponentTypes.ENCHANTMENTS, (Object)it);
            }
            return dummyCrossbow;
        }

        private static final CrossbowItem crossbowItem_delegate$lambda$0() {
            Item item = Items.CROSSBOW;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.CrossbowItem");
            return (CrossbowItem)item;
        }
    }
}

