/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.region;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import xyz.xenondevs.nova.util.LocationUtils;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.property.BlockStateProperty;
import xyz.xenondevs.nova.world.block.state.property.DefaultBlockStateProperties;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/world/region/Region;", "", "min", "Lorg/bukkit/Location;", "max", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/Location;)V", "_min", "Lorg/jetbrains/annotations/NotNull;", "_max", "getMin", "()Lorg/bukkit/Location;", "getMax", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "world$delegate", "Lkotlin/Lazy;", "contains", "", "loc", "block", "Lorg/bukkit/block/Block;", "toBoundingBox", "Lorg/bukkit/util/BoundingBox;", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Region.kt\nxyz/xenondevs/nova/world/region/Region\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class Region {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Location _min;
    @NotNull
    private final Location _max;
    @NotNull
    private final Lazy world$delegate;

    public Region(@NotNull Location min, @NotNull Location max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        Location location = min.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        this._min = location;
        Location location2 = max.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        this._max = location2;
        this.world$delegate = LazyKt.lazy(() -> Region.world_delegate$lambda$0(min));
        if (!(min.getWorld() != null && Intrinsics.areEqual((Object)min.getWorld(), (Object)max.getWorld()))) {
            boolean bl = false;
            String string = "Points must be in the same world.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Location getMin() {
        Location location = this._min.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        return location;
    }

    @NotNull
    public final Location getMax() {
        Location location = this._max.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        return location;
    }

    @NotNull
    public final World getWorld() {
        Lazy lazy = this.world$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (World)object;
    }

    public final boolean contains(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        return Intrinsics.areEqual((Object)loc.getWorld(), (Object)this._min.getWorld()) && loc.getX() >= this._min.getX() && loc.getX() <= this._max.getX() && loc.getY() >= this._min.getY() && loc.getY() <= this._max.getY() && loc.getZ() >= this._min.getZ() && loc.getZ() <= this._max.getZ();
    }

    public final boolean contains(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location loc = location;
        return Intrinsics.areEqual((Object)loc.getWorld(), (Object)this._min.getWorld()) && loc.getX() >= this._min.getX() && loc.getX() < this._max.getX() && loc.getY() >= this._min.getY() && loc.getY() < this._max.getY() && loc.getZ() >= this._min.getZ() && loc.getZ() < this._max.getZ();
    }

    @NotNull
    public final BoundingBox toBoundingBox() {
        return new BoundingBox(this._min.getX(), this._min.getY(), this._min.getZ(), this._max.getX(), this._max.getY(), this._max.getZ());
    }

    private static final World world_delegate$lambda$0(Location $min) {
        return $min.getWorld();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fJ.\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ6\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ6\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t\u00a8\u0006\u0019"}, d2={"Lxyz/xenondevs/nova/world/region/Region$Companion;", "", "<init>", "()V", "surrounding", "Lxyz/xenondevs/nova/world/region/Region;", "location", "Lorg/bukkit/Location;", "radius", "", "pos", "Lxyz/xenondevs/nova/world/BlockPos;", "", "inFrontOf", "tileEntity", "Lxyz/xenondevs/nova/world/block/tileentity/TileEntity;", "depth", "width", "height", "translateY", "facing", "Lorg/bukkit/block/BlockFace;", "inDirection", "direction", "Lorg/joml/Vector3d;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Region surrounding(@NotNull Location location, @NotNull Number radius) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)radius, (String)"radius");
            double radiusD = radius.doubleValue();
            Location location2 = location.clone().subtract(radiusD, radiusD, radiusD);
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"subtract(...)");
            Location location3 = location.clone().add(radiusD, radiusD, radiusD);
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"add(...)");
            return new Region(location2, location3);
        }

        @NotNull
        public final Region surrounding(@NotNull BlockPos pos, int radius) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Region(LocationUtilsKt.Location$default(pos.getWorld(), pos.getX() - radius, pos.getY() - radius, pos.getZ() - radius, null, null, 48, null), LocationUtilsKt.Location$default(pos.getWorld(), pos.getX() + radius + 1, pos.getY() + radius + 1, pos.getZ() + radius + 1, null, null, 48, null));
        }

        @NotNull
        public final Region inFrontOf(@NotNull TileEntity tileEntity, @NotNull Number depth, @NotNull Number width, @NotNull Number height, @NotNull Number translateY) {
            Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
            Intrinsics.checkNotNullParameter((Object)depth, (String)"depth");
            Intrinsics.checkNotNullParameter((Object)width, (String)"width");
            Intrinsics.checkNotNullParameter((Object)height, (String)"height");
            Intrinsics.checkNotNullParameter((Object)translateY, (String)"translateY");
            NovaBlockState blockState = tileEntity.getBlockState();
            BlockFace facing = (BlockFace)blockState.getOrThrow((BlockStateProperty)DefaultBlockStateProperties.INSTANCE.getFACING());
            return this.inFrontOf(tileEntity.getPos(), facing, depth, width, height, translateY);
        }

        @NotNull
        public final Region inFrontOf(@NotNull BlockPos pos, @NotNull BlockFace facing, @NotNull Number depth, @NotNull Number width, @NotNull Number height, @NotNull Number translateY) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
            Intrinsics.checkNotNullParameter((Object)depth, (String)"depth");
            Intrinsics.checkNotNullParameter((Object)width, (String)"width");
            Intrinsics.checkNotNullParameter((Object)height, (String)"height");
            Intrinsics.checkNotNullParameter((Object)translateY, (String)"translateY");
            Location location = pos.getLocation().add(0.5, 0.0, 0.5);
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
            Location location2 = LocationUtilsKt.advance(location, facing, 0.5);
            Vector3d vector3d = facing.getDirection().toVector3d();
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"toVector3d(...)");
            Vector3d direction = vector3d;
            return this.inDirection(location2, direction, depth, width, height, translateY);
        }

        @NotNull
        public final Region inDirection(@NotNull Location location, @NotNull Vector3d direction, @NotNull Number depth, @NotNull Number width, @NotNull Number height, @NotNull Number translateY) {
            Pair<Location, Location> pair;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)depth, (String)"depth");
            Intrinsics.checkNotNullParameter((Object)width, (String)"width");
            Intrinsics.checkNotNullParameter((Object)height, (String)"height");
            Intrinsics.checkNotNullParameter((Object)translateY, (String)"translateY");
            Vector3d leftDir = new Vector3d((Vector3dc)direction).rotateY(Math.toRadians(-90.0));
            Vector3d rightDir = new Vector3d((Vector3dc)direction).rotateY(Math.toRadians(90.0));
            Pair<Location, Location> $this$inDirection_u24lambda_u240 = pair = location.clone();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$inDirection_u24lambda_u240);
            Vector3d vector3d = leftDir.mul(width.doubleValue() / (double)2);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"mul(...)");
            LocationUtilsKt.add((Location)$this$inDirection_u24lambda_u240, vector3d);
            $this$inDirection_u24lambda_u240.setY($this$inDirection_u24lambda_u240.getY() + translateY.doubleValue());
            Pair<Location, Location> pair2 = pair;
            Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"apply(...)");
            Pair<Location, Location> pos1 = pair2;
            Pair<Location, Location> $this$inDirection_u24lambda_u241 = $this$inDirection_u24lambda_u240 = location.clone();
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)$this$inDirection_u24lambda_u241);
            Vector3d vector3d2 = direction.mul(depth.doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"mul(...)");
            LocationUtilsKt.add((Location)$this$inDirection_u24lambda_u241, vector3d2);
            Vector3d vector3d3 = rightDir.mul(width.doubleValue() / (double)2);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"mul(...)");
            LocationUtilsKt.add((Location)$this$inDirection_u24lambda_u241, vector3d3);
            $this$inDirection_u24lambda_u241.add(0.0, translateY.doubleValue() + height.doubleValue(), 0.0);
            Pair<Location, Location> pair3 = $this$inDirection_u24lambda_u240;
            Intrinsics.checkNotNullExpressionValue((Object)pair3, (String)"apply(...)");
            Pair<Location, Location> pos2 = pair3;
            pair = LocationUtils.INSTANCE.sort((Location)pos1, (Location)pos2);
            Location min = (Location)pair.component1();
            Location max = (Location)pair.component2();
            return new Region(min, max);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

