/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.origami;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;

public class OrigamiAgent {
    private static final Path LIBRARIES_DIR = Path.of("libraries/", new String[0]);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static ClassLoader origamiLoader;
    private static Object origami;

    public static void premain(String agentArgs, Instrumentation instrumentation) throws Throwable {
        if (Boolean.getBoolean("origami.agent.loaded")) {
            return;
        }
        System.setProperty("origami.agent.loaded", "true");
        origamiLoader = new URLClassLoader(OrigamiAgent.buildClasspath(), OrigamiAgent.class.getClassLoader().getParent());
        Class<?> origamiClass = Class.forName("xyz.xenondevs.origami.Origami", true, origamiLoader);
        origami = origamiClass.getConstructor(Instrumentation.class, ClassLoader.class).newInstance(instrumentation, OrigamiAgent.class.getClassLoader());
    }

    public static URL[] buildClasspath() {
        try {
            List<String> lines;
            try (InputStream libsStream = OrigamiAgent.class.getResourceAsStream("/origami-libraries");){
                Objects.requireNonNull(libsStream);
                BufferedReader reader = new BufferedReader(new InputStreamReader(libsStream));
                lines = reader.lines().toList();
            }
            String inZipLibsDir = lines.getFirst();
            URL[] urls = new URL[lines.size() - 1];
            for (int i2 = 1; i2 < lines.size(); ++i2) {
                String src = lines.get(i2);
                Path dst = LIBRARIES_DIR.resolve(src.substring(inZipLibsDir.length()));
                if (!Files.exists(dst, new LinkOption[0])) {
                    Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                    try (InputStream srcStream = OrigamiAgent.class.getResourceAsStream(src);){
                        Objects.requireNonNull(srcStream);
                        Files.copy(srcStream, dst, new CopyOption[0]);
                    }
                }
                urls[i2 - 1] = dst.toUri().toURL();
            }
            return urls;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract Origami libraries", e);
        }
    }

    public static void initOrigami(URL[] urls, ClassLoader classLoader) {
        try {
            MethodHandle handle = LOOKUP.findVirtual(origami.getClass(), "init", MethodType.methodType(Void.TYPE, URL[].class, ClassLoader.class));
            handle.invoke(origami, urls, classLoader);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to initialize Origami", e);
        }
    }

    public static ClassLoader createClassLoader(URL[] urls, ClassLoader parent) {
        try {
            Class<?> loaderClass = Class.forName("xyz.xenondevs.origami.PatchingClassLoader", true, origamiLoader);
            MethodHandle handle = LOOKUP.findConstructor(loaderClass, MethodType.methodType(Void.TYPE, URL[].class, ClassLoader.class));
            return handle.invoke(urls, parent);
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to load Origami class loader", e);
        }
    }

    public static void startMain(String className, ClassLoader classLoader, String[] args) {
        try {
            Class<?> mainClass = Class.forName(className, true, classLoader);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to start main method in " + className, e);
        }
    }
}

